/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.impl.io.CPStorageFactory;
import org.apache.derby.impl.io.InputStreamFile;
import org.apache.derby.io.StorageFile;

class CPFile
extends InputStreamFile {
    private final CPStorageFactory storageFactory;
    private int actionCode;
    private static final int EXISTS_ACTION = 1;

    CPFile(CPStorageFactory cPStorageFactory, String string) {
        super(cPStorageFactory, string);
        this.storageFactory = cPStorageFactory;
    }

    CPFile(CPStorageFactory cPStorageFactory, String string, String string2) {
        super((BaseStorageFactory)cPStorageFactory, string, string2);
        this.storageFactory = cPStorageFactory;
    }

    CPFile(CPFile cPFile, String string) {
        super(cPFile, string);
        this.storageFactory = cPFile.storageFactory;
    }

    private CPFile(CPStorageFactory cPStorageFactory, String string, int n) {
        super((BaseStorageFactory)cPStorageFactory, string, n);
        this.storageFactory = cPStorageFactory;
    }

    public boolean exists() {
        ClassLoader classLoader;
        if (this.storageFactory.useContextLoader && (classLoader = Thread.currentThread().getContextClassLoader()) != null && classLoader.getResource(this.path) != null) {
            return true;
        }
        if (this.getClass().getResource(this.path) != null) {
            if (this.storageFactory.useContextLoader) {
                this.storageFactory.useContextLoader = false;
            }
            return true;
        }
        return false;
    }

    StorageFile getParentDir(int n) {
        return new CPFile(this.storageFactory, this.path, n);
    }

    public InputStream getInputStream() throws FileNotFoundException {
        ClassLoader classLoader;
        InputStream inputStream = null;
        if (this.storageFactory.useContextLoader && (inputStream = (classLoader = Thread.currentThread().getContextClassLoader()).getResourceAsStream(this.path)) != null) {
            return inputStream;
        }
        inputStream = this.getClass().getResourceAsStream(this.path);
        if (inputStream != null && this.storageFactory.useContextLoader) {
            this.storageFactory.useContextLoader = false;
        }
        if (inputStream == null) {
            throw new FileNotFoundException("Not in class path: " + this.path);
        }
        return inputStream;
    }
}

