use utf8;
use strict;

use Test::More 'no_plan';
use lib 't/lib';

use Schema::TPathSync;


# test synchonization between dbix backend and treepath

my $schema = Schema::TPathSync->connect('t/conf/treewithsync.yml');
$schema->deploy;
$schema->_populate;


my $tp = $schema->treepath;
is ( $tp->count, 19, 'tree has 19 nodes');

my @pages    = $tp->search({source => 'Page'});
is(@pages, 11, "tree has 11 pages");
is( $schema->resultset('Page')->search()->count, 11, 'db has 11 pages');

my @comments = $tp->search({source => 'Comment'});
is(@comments, 8, "Tree 8 comments");
is( $schema->resultset('Comment')->search()->count, 8, 'db has 8 comments');


my $new_page = $schema->resultset('Page')->create({ name => 'New Page', parent_id => 1 });

# treepath is synchronized
is ( $schema->treepath->count, 20, 'tree has 20 nodes');


# Update name of New Page
$new_page->name('NewName');
ok($new_page->update,'update rs (name => NewName)');
my $newname = $tp->search({source => 'Page', name => 'NewName'});
is($newname->{name}, 'NewName', 'node is updated');

# delete page new_page;
ok($new_page->delete, 'delete rs page (new_page)');
is ( $schema->treepath->count, 19, 'tree has 19 nodes');



unlink ('t/db/tpsync.db');
exit;
