/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.caching;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.sysds.runtime.controlprogram.caching.ByteBuffer;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.util.LocalFileUtils;

public class CacheMaintenanceService {
    protected ExecutorService _pool = null;

    public CacheMaintenanceService() {
        if (this.isAsync()) {
            this._pool = Executors.newCachedThreadPool();
        }
    }

    public void deleteFile(String fname) {
        this._pool.submit(new FileCleanerTask(fname));
    }

    public void serializeData(ByteBuffer bbuff, CacheBlock<?> cb) {
        if (CacheableData.CACHING_ASYNC_SERIALIZE) {
            this._pool.submit(new DataSerializerTask(bbuff, cb));
        } else {
            bbuff.serializeBlock(cb);
        }
    }

    public void close() {
        if (this.isAsync()) {
            this._pool.shutdown();
        }
    }

    public boolean isAsync() {
        return true;
    }

    private static class DataSerializerTask
    implements Runnable {
        private ByteBuffer _bbuff = null;
        private CacheBlock<?> _cb = null;

        public DataSerializerTask(ByteBuffer bbuff, CacheBlock<?> cb) {
            this._bbuff = bbuff;
            this._cb = cb;
        }

        @Override
        public void run() {
            this._bbuff.serializeBlock(this._cb);
        }
    }

    private static class FileCleanerTask
    implements Runnable {
        private String _fname = null;

        public FileCleanerTask(String fname) {
            this._fname = fname;
        }

        @Override
        public void run() {
            LocalFileUtils.deleteFileIfExists(this._fname, true);
        }
    }
}

