/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.decode;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.transform.decode.Decoder;
import org.apache.sysds.runtime.transform.encode.ColumnEncoderRecode;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DecoderRecode
extends Decoder {
    private static final long serialVersionUID = -3784249774608228805L;
    private HashMap<Long, Object>[] _rcMaps = null;
    private Object[][] _rcMapsDirect = null;
    private boolean _onOut = false;

    public DecoderRecode() {
        super(null, null);
    }

    protected DecoderRecode(Types.ValueType[] schema, boolean onOut, int[] rcCols) {
        super(schema, rcCols);
        this._onOut = onOut;
    }

    public Object getRcMapValue(int i, long key) {
        return this._rcMapsDirect != null ? this._rcMapsDirect[i][(int)key - 1] : this._rcMaps[i].get(key);
    }

    @Override
    public FrameBlock decode(MatrixBlock in, FrameBlock out) {
        this.decode(in, out, 0, in.getNumRows());
        return out;
    }

    @Override
    public void decode(MatrixBlock in, FrameBlock out, int rl, int ru) {
        if (this._onOut) {
            for (int i = rl; i < ru; ++i) {
                for (int j = 0; j < this._colList.length; ++j) {
                    int colID = this._colList[j];
                    double val = UtilFunctions.objectToDouble(out.getSchema()[colID - 1], out.get(i, colID - 1));
                    long key = UtilFunctions.toLong(val);
                    out.set(i, colID - 1, this.getRcMapValue(j, key));
                }
            }
        } else {
            out.ensureAllocatedColumns(in.getNumRows());
            for (int i = rl; i < ru; ++i) {
                for (int j = 0; j < this._colList.length; ++j) {
                    double val = in.get(i, this._colList[j] - 1);
                    long key = UtilFunctions.toLong(val);
                    out.set(i, this._colList[j] - 1, this.getRcMapValue(j, key));
                }
            }
        }
    }

    @Override
    public Decoder subRangeDecoder(int colStart, int colEnd, int dummycodedOffset) {
        ArrayList<Integer> cols = new ArrayList<Integer>();
        ArrayList<HashMap<Long, Object>> rcMaps = new ArrayList<HashMap<Long, Object>>();
        for (int i2 = 0; i2 < this._colList.length; ++i2) {
            int col = this._colList[i2];
            if (col < colStart || col >= colEnd) continue;
            int corrColumn = col - (colStart - 1);
            cols.add(corrColumn);
            rcMaps.add(new HashMap<Long, Object>(this._rcMaps[i2]));
        }
        if (cols.isEmpty()) {
            return null;
        }
        int[] colList = cols.stream().mapToInt(i -> i).toArray();
        DecoderRecode subRangeDecoder = new DecoderRecode(Arrays.copyOfRange(this._schema, colStart - 1, colEnd - 1), this._onOut, colList);
        subRangeDecoder._rcMaps = rcMaps.toArray(new HashMap[0]);
        return subRangeDecoder;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        this._rcMaps = new HashMap[this._colList.length];
        long[] max = new long[this._colList.length];
        for (int j = 0; j < this._colList.length; ++j) {
            HashMap<Long, Object> map = new HashMap<Long, Object>();
            for (int i = 0; i < meta.getNumRows() && meta.get(i, this._colList[j] - 1) != null; ++i) {
                String[] tmp = ColumnEncoderRecode.splitRecodeMapEntry(meta.get(i, this._colList[j] - 1).toString());
                Object obj = UtilFunctions.stringToObject(this._schema[this._colList[j] - 1], tmp[0]);
                long lval = Long.parseLong(tmp[1]);
                map.put(lval, obj);
                max[j] = Math.max(lval, max[j]);
            }
            this._rcMaps[j] = map;
        }
        if (Arrays.stream(max).allMatch(v -> v < Integer.MAX_VALUE)) {
            this._rcMapsDirect = new Object[this._rcMaps.length][];
            for (int i = 0; i < this._rcMaps.length; ++i) {
                Object[] arr = new Object[(int)max[i]];
                for (Map.Entry<Long, Object> e1 : this._rcMaps[i].entrySet()) {
                    arr[e1.getKey().intValue() - 1] = e1.getValue();
                }
                this._rcMapsDirect[i] = arr;
            }
        }
    }

    public static void parseRecodeMapEntry(String entry, Pair<String, String> pair) {
        int ixq = entry.lastIndexOf(34);
        String token = UtilFunctions.unquote(entry.substring(0, ixq + 1));
        int idx = ixq + 2;
        while (entry.charAt(idx) != ",".charAt(0)) {
            ++idx;
        }
        String id = entry.substring(ixq + 2, idx);
        pair.set(token, id);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this._onOut);
        out.writeInt(this._rcMaps.length);
        for (int i = 0; i < this._rcMaps.length; ++i) {
            out.writeInt(this._rcMaps[i].size());
            for (Map.Entry<Long, Object> e1 : this._rcMaps[i].entrySet()) {
                out.writeLong(e1.getKey());
                out.writeUTF(e1.getValue().toString());
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        super.readExternal(in);
        this._onOut = in.readBoolean();
        this._rcMaps = new HashMap[in.readInt()];
        for (int i = 0; i < this._rcMaps.length; ++i) {
            HashMap<Long, String> maps = new HashMap<Long, String>();
            int size = in.readInt();
            for (int j = 0; j < size; ++j) {
                maps.put(in.readLong(), in.readUTF());
            }
            this._rcMaps[i] = maps;
        }
    }
}

