/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.telemetry.internals;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.KafkaException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.Uuid;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.compress.Compression;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.CompressionType;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.telemetry.internals.ClientTelemetryReporter;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.telemetry.internals.MetricKeyable;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Utils;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.shaded.io.opentelemetry.proto.metrics.v1.MetricsData;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;
import org.apache.skywalking.apm.dependencies.org.slf4j.LoggerFactory;

public class ClientTelemetryUtils {
    private static final Logger log = LoggerFactory.getLogger(ClientTelemetryUtils.class);
    public static final Predicate<? super MetricKeyable> SELECTOR_NO_METRICS = k -> false;
    public static final Predicate<? super MetricKeyable> SELECTOR_ALL_METRICS = k -> true;

    public static Optional<Integer> maybeFetchErrorIntervalMs(short errorCode, int intervalMs) {
        String reason;
        int pushIntervalMs;
        if (errorCode == Errors.NONE.code()) {
            return Optional.empty();
        }
        Errors error = Errors.forCode(errorCode);
        switch (error) {
            case INVALID_REQUEST: 
            case INVALID_RECORD: 
            case UNSUPPORTED_VERSION: {
                pushIntervalMs = Integer.MAX_VALUE;
                reason = "The broker response indicates the client sent an request that cannot be resolved by re-trying, hence disable telemetry";
                break;
            }
            case UNKNOWN_SUBSCRIPTION_ID: 
            case UNSUPPORTED_COMPRESSION_TYPE: {
                pushIntervalMs = 0;
                reason = error.message();
                break;
            }
            case TELEMETRY_TOO_LARGE: 
            case THROTTLING_QUOTA_EXCEEDED: {
                reason = error.message();
                pushIntervalMs = intervalMs != -1 ? intervalMs : 300000;
                break;
            }
            default: {
                reason = "Unwrapped error code";
                log.error("Error code: {}. Unmapped error for telemetry, disable telemetry.", (Object)errorCode);
                pushIntervalMs = Integer.MAX_VALUE;
            }
        }
        log.debug("Error code: {}, reason: {}. Push interval update to {} ms.", errorCode, reason, pushIntervalMs);
        return Optional.of(pushIntervalMs);
    }

    public static Predicate<? super MetricKeyable> getSelectorFromRequestedMetrics(List<String> requestedMetrics) {
        if (requestedMetrics == null || requestedMetrics.isEmpty()) {
            log.debug("Telemetry subscription has specified no metric names; telemetry will record no metrics");
            return SELECTOR_NO_METRICS;
        }
        if (requestedMetrics.size() == 1 && requestedMetrics.get(0) != null && requestedMetrics.get(0).equals("*")) {
            log.debug("Telemetry subscription has specified a single '*' metric name; using all metrics");
            return SELECTOR_ALL_METRICS;
        }
        log.debug("Telemetry subscription has specified to include only metrics that are prefixed with the following strings: {}", (Object)requestedMetrics);
        return k -> requestedMetrics.stream().anyMatch(f -> k.key().name().startsWith((String)f));
    }

    public static List<CompressionType> getCompressionTypesFromAcceptedList(List<Byte> acceptedCompressionTypes) {
        if (acceptedCompressionTypes == null || acceptedCompressionTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CompressionType> result = new ArrayList<CompressionType>();
        for (Byte compressionByte : acceptedCompressionTypes) {
            int compressionId = compressionByte.intValue();
            try {
                CompressionType compressionType = CompressionType.forId(compressionId);
                result.add(compressionType);
            }
            catch (IllegalArgumentException e) {
                log.warn("Accepted compressionByte type with ID {} is not a known compressionByte type; ignoring", (Object)compressionId, (Object)e);
            }
        }
        return result;
    }

    public static Uuid validateClientInstanceId(Uuid clientInstanceId) {
        if (clientInstanceId == null || clientInstanceId.equals(Uuid.ZERO_UUID)) {
            throw new IllegalArgumentException("clientInstanceId is not valid");
        }
        return clientInstanceId;
    }

    public static int validateIntervalMs(int intervalMs) {
        if (intervalMs <= 0) {
            log.warn("Telemetry subscription push interval value from broker was invalid ({}), substituting with default value of {}", (Object)intervalMs, (Object)300000);
            return 300000;
        }
        log.debug("Telemetry subscription push interval value from broker: {}", (Object)intervalMs);
        return intervalMs;
    }

    public static boolean validateResourceLabel(Map<String, ?> m, String key) {
        if (!m.containsKey(key)) {
            log.trace("{} does not exist in map {}", (Object)key, (Object)m);
            return false;
        }
        if (m.get(key) == null) {
            log.trace("{} is null. map {}", (Object)key, (Object)m);
            return false;
        }
        if (!(m.get(key) instanceof String)) {
            log.trace("{} is not a string. map {}", (Object)key, (Object)m);
            return false;
        }
        String val = (String)m.get(key);
        if (val.isEmpty()) {
            log.trace("{} is empty string. value = {} map {}", key, val, m);
            return false;
        }
        return true;
    }

    public static boolean validateRequiredResourceLabels(Map<String, String> metadata) {
        return ClientTelemetryUtils.validateResourceLabel(metadata, "_namespace");
    }

    public static CompressionType preferredCompressionType(List<CompressionType> acceptedCompressionTypes) {
        if (acceptedCompressionTypes != null && !acceptedCompressionTypes.isEmpty()) {
            return acceptedCompressionTypes.get(0);
        }
        return CompressionType.NONE;
    }

    public static byte[] compress(byte[] raw, CompressionType compressionType) throws IOException {
        try (ByteBufferOutputStream compressedOut = new ByteBufferOutputStream(512);){
            Compression compression = Compression.of(compressionType).build();
            try (OutputStream out = compression.wrapForOutput(compressedOut, (byte)2);){
                out.write(raw);
                out.flush();
            }
            compressedOut.buffer().flip();
            byte[] byArray = Utils.toArray(compressedOut.buffer());
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    public static ByteBuffer decompress(byte[] metrics, CompressionType compressionType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static MetricsData deserializeMetricsData(ByteBuffer serializedMetricsData) {
        try {
            return MetricsData.parseFrom(serializedMetricsData);
        }
        catch (IOException e) {
            throw new KafkaException("Unable to parse MetricsData payload", e);
        }
    }

    public static Uuid fetchClientInstanceId(ClientTelemetryReporter clientTelemetryReporter, Duration timeout) {
        if (timeout.isNegative()) {
            throw new IllegalArgumentException("The timeout cannot be negative.");
        }
        Optional<Uuid> optionalUuid = clientTelemetryReporter.telemetrySender().clientInstanceId(timeout);
        return optionalUuid.orElse(null);
    }
}

