/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.cassandra.java.driver.v3;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Statement;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.cassandra.java.driver.v3.ConnectionInfo;

public class SessionManagerExecuteAndExecuteAsyncWithStatementArgInterceptor
implements InstanceMethodsAroundInterceptor {
    public final void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        ConnectionInfo connectionInfo = (ConnectionInfo)objInst.getSkyWalkingDynamicField();
        if (connectionInfo == null) {
            return;
        }
        Statement statement = (Statement)allArguments[0];
        String remotePeer = statement.getHost() == null ? connectionInfo.getContactPoints() : statement.getHost().getSocketAddress().getHostName() + ":" + statement.getHost().getSocketAddress().getPort();
        String keyspace = statement.getKeyspace() == null ? connectionInfo.getKeyspace() : statement.getKeyspace();
        String query = statement.toString();
        if (statement instanceof BoundStatement) {
            query = ((BoundStatement)statement).preparedStatement().getQueryString();
        }
        AbstractSpan span = ContextManager.createExitSpan((String)("Cassandra/" + method.getName()), (String)remotePeer);
        span.setComponent((Component)ComponentsDefine.CASSANDRA_JAVA_DRIVER);
        Tags.DB_TYPE.set(span, "cassandra");
        Tags.DB_INSTANCE.set(span, keyspace);
        Tags.DB_STATEMENT.set(span, query);
        SpanLayer.asDB((AbstractSpan)span);
    }

    public final Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ConnectionInfo connectionInfo = (ConnectionInfo)objInst.getSkyWalkingDynamicField();
        if (connectionInfo != null && ContextManager.isActive()) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public final void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (ContextManager.isActive()) {
            AbstractSpan span = ContextManager.activeSpan();
            span.log(t);
        }
    }
}

