/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.logging.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.logging.core.Converter;
import org.apache.skywalking.apm.agent.core.logging.core.converters.LiteralConverter;

public class Parser {
    private final Map<String, Class<? extends Converter>> convertMaps;
    public static final char ESCAPE_CHAR = '\\';
    public static final char PERCENT_CHAR = '%';
    private final String pattern;
    private final int patternLength;
    private int pointer = 0;
    private State state = State.LITERAL_STATE;

    public Parser(String pattern, Map<String, Class<? extends Converter>> convertMaps) {
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("null or empty pattern string not allowed");
        }
        this.convertMaps = convertMaps;
        this.pattern = pattern;
        this.patternLength = pattern.length();
    }

    public List<Converter> parse() {
        ArrayList<Converter> patternConverters = new ArrayList<Converter>();
        StringBuilder buf = new StringBuilder();
        while (this.pointer < this.patternLength) {
            char c = this.pattern.charAt(this.pointer);
            ++this.pointer;
            switch (this.state) {
                case LITERAL_STATE: {
                    this.handleLiteralState(c, buf, patternConverters);
                    break;
                }
                case KEYWORD_STATE: {
                    this.handleKeywordState(c, buf, patternConverters);
                    break;
                }
            }
        }
        switch (this.state) {
            case LITERAL_STATE: {
                this.addConverter(buf, patternConverters, LiteralConverter.class);
                break;
            }
            case KEYWORD_STATE: {
                this.addConverterWithKeyword(buf, patternConverters);
                break;
            }
        }
        return this.combineLiteral(patternConverters);
    }

    private List<Converter> combineLiteral(List<Converter> patternConverters) {
        ArrayList<Converter> converterList = new ArrayList<Converter>();
        StringBuilder stringBuilder = new StringBuilder();
        for (Converter patternConverter : patternConverters) {
            if (patternConverter instanceof LiteralConverter) {
                stringBuilder.append(patternConverter.convert(null));
                continue;
            }
            if (stringBuilder.length() > 0) {
                converterList.add(new LiteralConverter(stringBuilder.toString()));
                stringBuilder.setLength(0);
            }
            converterList.add(patternConverter);
        }
        return converterList;
    }

    private void handleKeywordState(char c, StringBuilder buf, List<Converter> patternConverters) {
        if (Character.isJavaIdentifierPart(c)) {
            buf.append(c);
        } else if (c == '%') {
            this.addConverterWithKeyword(buf, patternConverters);
        } else {
            this.addConverterWithKeyword(buf, patternConverters);
            if (c == '\\') {
                this.escape("%", buf);
            } else {
                buf.append(c);
            }
            this.state = State.LITERAL_STATE;
        }
    }

    private void addConverterWithKeyword(StringBuilder buf, List<Converter> patternConverters) {
        String keyword = buf.toString();
        if (this.convertMaps.containsKey(keyword)) {
            this.addConverter(buf, patternConverters, this.convertMaps.get(keyword));
        } else {
            buf.insert(0, "%");
            this.addConverter(buf, patternConverters, LiteralConverter.class);
        }
    }

    private void handleLiteralState(char c, StringBuilder buf, List<Converter> patternConverters) {
        switch (c) {
            case '\\': {
                this.escape("%", buf);
                break;
            }
            case '%': {
                this.addConverter(buf, patternConverters, LiteralConverter.class);
                this.state = State.KEYWORD_STATE;
                break;
            }
            default: {
                buf.append(c);
            }
        }
    }

    private void escape(String escapeChars, StringBuilder buf) {
        if (this.pointer < this.patternLength) {
            char next = this.pattern.charAt(this.pointer++);
            this.escape(escapeChars, buf, next);
        }
    }

    private void addConverter(StringBuilder buf, List<Converter> patternConverters, Class<? extends Converter> aClass) {
        if (buf.length() > 0) {
            String result = buf.toString();
            if (LiteralConverter.class.equals(aClass)) {
                patternConverters.add(new LiteralConverter(result));
            } else {
                try {
                    patternConverters.add(aClass.newInstance());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Create Converter error. Class: " + aClass, e);
                }
            }
            buf.setLength(0);
        }
    }

    private void escape(String escapeChars, StringBuilder buf, char next) {
        if (escapeChars.indexOf(next) >= 0) {
            buf.append(next);
        } else {
            switch (next) {
                case '_': {
                    break;
                }
                case '\\': {
                    buf.append(next);
                    break;
                }
                case 't': {
                    buf.append('\t');
                    break;
                }
                case 'r': {
                    buf.append('\r');
                    break;
                }
                case 'n': {
                    buf.append('\n');
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal char " + next + ". It not allowed as escape characters.");
                }
            }
        }
    }

    static enum State {
        LITERAL_STATE,
        KEYWORD_STATE;

    }
}

