/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.asyncprofiler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.dependencies.one.profiler.AsyncProfiler;
import org.apache.skywalking.apm.util.StringUtil;

public class AsyncProfilerTask {
    private static final ILog LOGGER = LogManager.getLogger(AsyncProfilerTask.class);
    private static final String COMMA = ",";
    private String taskId;
    private String execArgs;
    private int duration;
    private long createTime;
    private Path tempFile;

    private static String execute(AsyncProfiler asyncProfiler, String args) throws IllegalArgumentException, IOException {
        LOGGER.info("async profiler execute args:{}", args);
        return asyncProfiler.execute(args);
    }

    public String start(AsyncProfiler asyncProfiler) throws IOException {
        this.tempFile = this.getProfilerFilePath();
        StringBuilder startArgs = new StringBuilder();
        startArgs.append("start").append(COMMA);
        if (StringUtil.isNotEmpty(this.execArgs)) {
            startArgs.append(this.execArgs).append(COMMA);
        }
        startArgs.append("file=").append(this.tempFile.toString());
        return AsyncProfilerTask.execute(asyncProfiler, startArgs.toString());
    }

    public File stop(AsyncProfiler asyncProfiler) throws IOException {
        LOGGER.info("async profiler process stop and dump file");
        String stopArgs = "stop,file=" + this.tempFile.toAbsolutePath();
        AsyncProfilerTask.execute(asyncProfiler, stopArgs);
        return this.tempFile.toFile();
    }

    public Path getProfilerFilePath() throws IOException {
        if (StringUtil.isNotEmpty(Config.AsyncProfiler.OUTPUT_PATH)) {
            Path tempFilePath = Paths.get(Config.AsyncProfiler.OUTPUT_PATH, this.taskId + this.getFileExtension());
            return Files.createFile(tempFilePath.toAbsolutePath(), new FileAttribute[0]);
        }
        return Files.createTempFile(this.taskId, this.getFileExtension(), new FileAttribute[0]);
    }

    private String getFileExtension() {
        return ".jfr";
    }

    public void setExecArgs(String execArgs) {
        this.execArgs = execArgs;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setTempFile(Path tempFile) {
        this.tempFile = tempFile;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String getExecArgs() {
        return this.execArgs;
    }

    public int getDuration() {
        return this.duration;
    }

    public Path getTempFile() {
        return this.tempFile;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public long getCreateTime() {
        return this.createTime;
    }
}

