/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.message.view;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.james.jmap.draft.model.Keywords;
import org.apache.james.jmap.draft.model.message.view.MessageFullViewFactory;
import org.apache.james.jmap.draft.model.message.view.MessageView;
import org.apache.james.jmap.draft.utils.KeywordsCombiner;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.util.ReactorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface MessageViewFactory<T extends MessageView> {
    public static final Logger LOGGER = LoggerFactory.getLogger(MessageViewFactory.class);
    public static final KeywordsCombiner KEYWORDS_COMBINER = new KeywordsCombiner();
    public static final Keywords.KeywordsFactory KEYWORDS_FACTORY = Keywords.lenientFactory();
    public static final String JMAP_MULTIVALUED_FIELD_DELIMITER = "\n";

    public Flux<T> fromMessageIds(List<MessageId> var1, MailboxSession var2);

    public static class Helpers {
        static void assertOneMessageId(Collection<MessageResult> messageResults) {
            Preconditions.checkArgument((!messageResults.isEmpty() ? 1 : 0) != 0, (Object)"MessageResults cannot be empty");
            Preconditions.checkArgument((boolean)Helpers.hasOnlyOneMessageId(messageResults), (Object)"MessageResults need to share the same messageId");
        }

        private static boolean hasOnlyOneMessageId(Collection<MessageResult> messageResults) {
            if (messageResults.size() == 1) {
                return true;
            }
            return messageResults.stream().map(MessageResult::getMessageId).distinct().count() == 1L;
        }

        static Set<MailboxId> getMailboxIds(Collection<MessageResult> messageResults) {
            return (Set)messageResults.stream().map(MessageResult::getMailboxId).collect(ImmutableSet.toImmutableSet());
        }

        static Keywords getKeywords(Collection<MessageResult> messageResults) {
            return messageResults.stream().map(MessageResult::getFlags).map(KEYWORDS_FACTORY::fromFlags).reduce(KEYWORDS_COMBINER).get();
        }

        static String getHeaderValue(Message message, String header) {
            Field field = message.getHeader().getField(header);
            if (field == null) {
                return null;
            }
            return field.getBody();
        }

        static ImmutableMap<String, String> toHeaderMap(Header header) {
            return (ImmutableMap)header.getFieldsAsMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((Field)((List)entry.getValue()).get(0)).getName(), entry -> ((List)entry.getValue()).stream().map(Field::getBody).map(body -> DecoderUtil.decodeEncodedWords((String)body, (DecodeMonitor)DecodeMonitor.SILENT)).collect(Collectors.joining(MessageViewFactory.JMAP_MULTIVALUED_FIELD_DELIMITER))));
        }

        static <T extends MessageView> Function<Collection<MessageResult>, Mono<T>> toMessageViews(FromMessageResult<T> converter) {
            return messageResults -> converter.fromMessageResults((Collection<MessageResult>)messageResults).doOnEach(ReactorUtils.logOnError(e -> LOGGER.error("Can not convert MessageResults to Message for {}", (Object)((MessageResult)messageResults.iterator().next()).getMessageId().serialize(), e))).onErrorResume(e -> Mono.empty());
        }

        static <T extends MessageView> Flux<T> toMessageViews(Flux<MessageResult> messageResults, FromMessageResult<T> converter) {
            return messageResults.groupBy(MessageResult::getMessageId).flatMap(Flux::collectList, 16).filter(Predicate.not(List::isEmpty)).flatMap(Helpers.toMessageViews(converter), 16);
        }

        static Instant getDateFromHeaderOrInternalDateOtherwise(Message mimeMessage, MessageResult message) {
            return Optional.ofNullable(mimeMessage.getDate()).map(Date::toInstant).orElse(message.getInternalDate().toInstant());
        }

        static Message retrieveMessage(MessageFullViewFactory.MetaDataWithContent metaDataWithContent) {
            return metaDataWithContent.getMessage().orElseGet(Throwing.supplier(() -> Helpers.parse(metaDataWithContent.getContent())).sneakyThrow());
        }

        static Message parse(InputStream messageContent) throws IOException {
            DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
            defaultMessageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
            return defaultMessageBuilder.parseMessage(messageContent);
        }

        static interface FromMessageResult<T extends MessageView> {
            public Mono<T> fromMessageResults(Collection<MessageResult> var1);
        }
    }
}

