/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationBase;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.ValueType;
import org.opensearch.client.opensearch._types.aggregations.WeightedAverageValue;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class WeightedAverageAggregation
extends AggregationBase
implements AggregationVariant {
    @Nullable
    private final String format;
    @Nullable
    private final WeightedAverageValue value;
    @Nullable
    private final ValueType valueType;
    @Nullable
    private final WeightedAverageValue weight;
    public static final JsonpDeserializer<WeightedAverageAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WeightedAverageAggregation::setupWeightedAverageAggregationDeserializer);

    private WeightedAverageAggregation(Builder builder) {
        super(builder);
        this.format = builder.format;
        this.value = builder.value;
        this.valueType = builder.valueType;
        this.weight = builder.weight;
    }

    public static WeightedAverageAggregation of(Function<Builder, ObjectBuilder<WeightedAverageAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.WeightedAvg;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final WeightedAverageValue value() {
        return this.value;
    }

    @Nullable
    public final ValueType valueType() {
        return this.valueType;
    }

    @Nullable
    public final WeightedAverageValue weight() {
        return this.weight;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.value != null) {
            generator.writeKey("value");
            this.value.serialize(generator, mapper);
        }
        if (this.valueType != null) {
            generator.writeKey("value_type");
            this.valueType.serialize(generator, mapper);
        }
        if (this.weight != null) {
            generator.writeKey("weight");
            this.weight.serialize(generator, mapper);
        }
    }

    protected static void setupWeightedAverageAggregationDeserializer(ObjectDeserializer<Builder> op) {
        WeightedAverageAggregation.setupAggregationBaseDeserializer(op);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::value, WeightedAverageValue._DESERIALIZER, "value");
        op.add(Builder::valueType, ValueType._DESERIALIZER, "value_type");
        op.add(Builder::weight, WeightedAverageValue._DESERIALIZER, "weight");
    }

    public static class Builder
    extends AggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<WeightedAverageAggregation> {
        @Nullable
        private String format;
        @Nullable
        private WeightedAverageValue value;
        @Nullable
        private ValueType valueType;
        @Nullable
        private WeightedAverageValue weight;

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder value(@Nullable WeightedAverageValue value) {
            this.value = value;
            return this;
        }

        public final Builder value(Function<WeightedAverageValue.Builder, ObjectBuilder<WeightedAverageValue>> fn) {
            return this.value(fn.apply(new WeightedAverageValue.Builder()).build());
        }

        public final Builder valueType(@Nullable ValueType value) {
            this.valueType = value;
            return this;
        }

        public final Builder weight(@Nullable WeightedAverageValue value) {
            this.weight = value;
            return this;
        }

        public final Builder weight(Function<WeightedAverageValue.Builder, ObjectBuilder<WeightedAverageValue>> fn) {
            return this.weight(fn.apply(new WeightedAverageValue.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WeightedAverageAggregation build() {
            this._checkSingleUse();
            return new WeightedAverageAggregation(this);
        }
    }
}

