/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpUtils;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.opensearch._types.aggregations.AggregateVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class StatsAggregate
extends AggregateBase
implements AggregateVariant {
    private final long count;
    private final double min;
    private final double max;
    private final double avg;
    private final double sum;
    @Nullable
    private final String minAsString;
    @Nullable
    private final String maxAsString;
    @Nullable
    private final String avgAsString;
    @Nullable
    private final String sumAsString;
    public static final JsonpDeserializer<StatsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StatsAggregate::setupStatsAggregateDeserializer);

    protected StatsAggregate(AbstractBuilder<?> builder) {
        super(builder);
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.min = ApiTypeHelper.requireNonNull(builder.min, this, "min");
        this.max = ApiTypeHelper.requireNonNull(builder.max, this, "max");
        this.avg = ApiTypeHelper.requireNonNull(builder.avg, this, "avg");
        this.sum = ApiTypeHelper.requireNonNull(builder.sum, this, "sum");
        this.minAsString = builder.minAsString;
        this.maxAsString = builder.maxAsString;
        this.avgAsString = builder.avgAsString;
        this.sumAsString = builder.sumAsString;
    }

    public static StatsAggregate statsAggregateOf(Function<Builder, ObjectBuilder<StatsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.Stats;
    }

    public final long count() {
        return this.count;
    }

    public final double min() {
        return this.min;
    }

    public final double max() {
        return this.max;
    }

    public final double avg() {
        return this.avg;
    }

    public final double sum() {
        return this.sum;
    }

    @Nullable
    public final String minAsString() {
        return this.minAsString;
    }

    @Nullable
    public final String maxAsString() {
        return this.maxAsString;
    }

    @Nullable
    public final String avgAsString() {
        return this.avgAsString;
    }

    @Nullable
    public final String sumAsString() {
        return this.sumAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("min");
        JsonpUtils.serializeDoubleOrNull(generator, this.min, Double.POSITIVE_INFINITY);
        generator.writeKey("max");
        JsonpUtils.serializeDoubleOrNull(generator, this.max, Double.NEGATIVE_INFINITY);
        generator.writeKey("avg");
        JsonpUtils.serializeDoubleOrNull(generator, this.avg, 0.0);
        generator.writeKey("sum");
        generator.write(this.sum);
        if (this.minAsString != null) {
            generator.writeKey("min_as_string");
            generator.write(this.minAsString);
        }
        if (this.maxAsString != null) {
            generator.writeKey("max_as_string");
            generator.write(this.maxAsString);
        }
        if (this.avgAsString != null) {
            generator.writeKey("avg_as_string");
            generator.write(this.avgAsString);
        }
        if (this.sumAsString != null) {
            generator.writeKey("sum_as_string");
            generator.write(this.sumAsString);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupStatsAggregateDeserializer(ObjectDeserializer<BuilderT> op) {
        StatsAggregate.setupAggregateBaseDeserializer(op);
        op.add(AbstractBuilder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(AbstractBuilder::min, JsonpDeserializer.doubleOrNullDeserializer(Double.POSITIVE_INFINITY), "min");
        op.add(AbstractBuilder::max, JsonpDeserializer.doubleOrNullDeserializer(Double.NEGATIVE_INFINITY), "max");
        op.add(AbstractBuilder::avg, JsonpDeserializer.doubleOrNullDeserializer(0.0), "avg");
        op.add(AbstractBuilder::sum, JsonpDeserializer.doubleDeserializer(), "sum");
        op.add(AbstractBuilder::minAsString, JsonpDeserializer.stringDeserializer(), "min_as_string");
        op.add(AbstractBuilder::maxAsString, JsonpDeserializer.stringDeserializer(), "max_as_string");
        op.add(AbstractBuilder::avgAsString, JsonpDeserializer.stringDeserializer(), "avg_as_string");
        op.add(AbstractBuilder::sumAsString, JsonpDeserializer.stringDeserializer(), "sum_as_string");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregateBase.AbstractBuilder<BuilderT> {
        private Long count;
        private Double min;
        private Double max;
        private Double avg;
        private Double sum;
        @Nullable
        private String minAsString;
        @Nullable
        private String maxAsString;
        @Nullable
        private String avgAsString;
        @Nullable
        private String sumAsString;

        protected AbstractBuilder() {
        }

        public final BuilderT count(long value) {
            this.count = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT min(double value) {
            this.min = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT max(double value) {
            this.max = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT avg(double value) {
            this.avg = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT sum(double value) {
            this.sum = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT minAsString(@Nullable String value) {
            this.minAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT maxAsString(@Nullable String value) {
            this.maxAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT avgAsString(@Nullable String value) {
            this.avgAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT sumAsString(@Nullable String value) {
            this.sumAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<StatsAggregate> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StatsAggregate build() {
            this._checkSingleUse();
            return new StatsAggregate(this);
        }
    }
}

