/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.subtle.ChaCha20Base;
import java.security.InvalidKeyException;

class ChaCha20
extends ChaCha20Base {
    ChaCha20(byte[] key, int initialCounter) throws InvalidKeyException {
        super(key, initialCounter);
    }

    @Override
    int[] createInitialState(int[] nonce, int counter) {
        if (nonce.length != this.nonceSizeInBytes() / 4) {
            throw new IllegalArgumentException(String.format("ChaCha20 uses 96-bit nonces, but got a %d-bit nonce", nonce.length * 32));
        }
        int[] state = new int[16];
        ChaCha20Base.setSigmaAndKey(state, this.key);
        state[12] = counter;
        System.arraycopy(nonce, 0, state, 13, nonce.length);
        return state;
    }

    @Override
    int nonceSizeInBytes() {
        return 12;
    }
}

