/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableShortListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;
import org.eclipse.collections.impl.factory.primitive.ShortLists;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableShortArrayList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableShortEmptyList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableShortSingletonList;

public class ImmutableShortListFactoryImpl
implements ImmutableShortListFactory {
    public static final ImmutableShortListFactory INSTANCE = new ImmutableShortListFactoryImpl();

    @Override
    public ImmutableShortList empty() {
        return ImmutableShortEmptyList.INSTANCE;
    }

    @Override
    public ImmutableShortList of() {
        return this.empty();
    }

    @Override
    public ImmutableShortList with() {
        return this.empty();
    }

    @Override
    public ImmutableShortList of(short one) {
        return this.with(one);
    }

    @Override
    public ImmutableShortList with(short one) {
        return new ImmutableShortSingletonList(one);
    }

    @Override
    public ImmutableShortList of(short ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableShortList with(short ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableShortArrayList.newListWith(items);
    }

    @Override
    public ImmutableShortList ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableShortList withAll(ShortIterable items) {
        if (items instanceof ImmutableShortList) {
            return (ImmutableShortList)items;
        }
        if (items == null || items.size() == 0) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray()[0]);
        }
        return ImmutableShortArrayList.newList(items);
    }

    @Override
    public ImmutableShortList ofAll(Iterable<Short> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableShortList withAll(Iterable<Short> iterable) {
        return ShortLists.mutable.withAll(iterable).toImmutable();
    }
}

