/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.path.PathPatternTreeUtils;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.component.WhereCondition;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowStatement;
import org.apache.iotdb.rpc.TSStatusCode;

public class ShowTimeSeriesStatement
extends ShowStatement {
    private final PartialPath pathPattern;
    private SchemaFilter schemaFilter;
    private final boolean orderByHeat;
    private WhereCondition timeCondition;

    public ShowTimeSeriesStatement(PartialPath pathPattern, boolean orderByHeat) {
        this.pathPattern = pathPattern;
        this.orderByHeat = orderByHeat;
    }

    public PartialPath getPathPattern() {
        return this.pathPattern;
    }

    public SchemaFilter getSchemaFilter() {
        return this.schemaFilter;
    }

    public void setSchemaFilter(SchemaFilter schemaFilter) {
        this.schemaFilter = schemaFilter;
    }

    public boolean isOrderByHeat() {
        return this.orderByHeat;
    }

    public void setTimeCondition(WhereCondition timeCondition) {
        this.timeCondition = timeCondition;
    }

    public WhereCondition getTimeCondition() {
        return this.timeCondition;
    }

    public boolean hasTimeCondition() {
        return this.timeCondition != null;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (this.hasTimeCondition()) {
            try {
                if (!AuthorityChecker.SUPER_USER.equals(userName)) {
                    this.authorityScope = PathPatternTreeUtils.intersectWithFullPathPrefixTree((PathPatternTree)AuthorityChecker.getAuthorizedPathTree(userName, PrivilegeType.READ_SCHEMA), (PathPatternTree)AuthorityChecker.getAuthorizedPathTree(userName, PrivilegeType.READ_DATA));
                }
            }
            catch (AuthException e) {
                return new TSStatus(e.getCode().getStatusCode());
            }
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return super.checkPermissionBeforeProcess(userName);
    }

    @Override
    public List<PartialPath> getPaths() {
        return Collections.singletonList(this.pathPattern);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitShowTimeSeries(this, context);
    }
}

