/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.LogicalIndexNavigation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrLabel;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class LogicalIndexPointer {
    private final Set<IrLabel> labels;
    private final boolean last;
    private final boolean running;
    private final int logicalOffset;
    private final int physicalOffset;

    public LogicalIndexPointer(Set<IrLabel> labels, boolean last, boolean running, int logicalOffset, int physicalOffset) {
        this.labels = Objects.requireNonNull(labels, "labels is null");
        this.last = last;
        this.running = running;
        Preconditions.checkArgument((logicalOffset >= 0 ? 1 : 0) != 0, (String)"logical offset must be >= 0, actual: %s", (int)logicalOffset);
        this.logicalOffset = logicalOffset;
        this.physicalOffset = physicalOffset;
    }

    public Set<IrLabel> getLabels() {
        return this.labels;
    }

    public boolean isLast() {
        return this.last;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getLogicalOffset() {
        return this.logicalOffset;
    }

    public int getPhysicalOffset() {
        return this.physicalOffset;
    }

    public LogicalIndexNavigation toLogicalIndexNavigation(Map<IrLabel, Integer> mapping) {
        return new LogicalIndexNavigation((Set)this.labels.stream().map(mapping::get).collect(ImmutableSet.toImmutableSet()), this.last, this.running, this.logicalOffset, this.physicalOffset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalIndexPointer that = (LogicalIndexPointer)o;
        return this.last == that.last && this.running == that.running && this.logicalOffset == that.logicalOffset && this.physicalOffset == that.physicalOffset && this.labels.equals(that.labels);
    }

    public int hashCode() {
        return Objects.hash(this.labels, this.last, this.running, this.logicalOffset, this.physicalOffset);
    }

    public static void serialize(LogicalIndexPointer pointer, ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)pointer.labels.size(), (ByteBuffer)byteBuffer);
        for (IrLabel label : pointer.labels) {
            IrLabel.serialize(label, byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)pointer.last, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)pointer.running, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)pointer.logicalOffset, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)pointer.physicalOffset, (ByteBuffer)byteBuffer);
    }

    public static void serialize(LogicalIndexPointer pointer, DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)pointer.labels.size(), (OutputStream)stream);
        for (IrLabel label : pointer.labels) {
            IrLabel.serialize(label, stream);
        }
        ReadWriteIOUtils.write((Boolean)pointer.last, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)pointer.running, (OutputStream)stream);
        ReadWriteIOUtils.write((int)pointer.logicalOffset, (OutputStream)stream);
        ReadWriteIOUtils.write((int)pointer.physicalOffset, (OutputStream)stream);
    }

    public static LogicalIndexPointer deserialize(ByteBuffer byteBuffer) {
        int labelCount = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        HashSet<IrLabel> labels = new HashSet<IrLabel>();
        for (int i = 0; i < labelCount; ++i) {
            labels.add(IrLabel.deserialize(byteBuffer));
        }
        boolean last = ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer);
        boolean running = ReadWriteIOUtils.readBoolean((ByteBuffer)byteBuffer);
        int logicalOffset = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        int physicalOffset = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        return new LogicalIndexPointer(labels, last, running, logicalOffset, physicalOffset);
    }
}

