/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceNode;
import org.eclipse.milo.opcua.stack.core.types.structured.TypeNode;

public class ObjectTypeNode
extends TypeNode
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=264");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=266");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=265");
    private final Boolean isAbstract;

    public ObjectTypeNode(NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, ReferenceNode[] references, Boolean isAbstract) {
        super(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references);
        this.isAbstract = isAbstract;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public Boolean getIsAbstract() {
        return this.isAbstract;
    }

    protected ObjectTypeNode(ObjectTypeNodeBuilder<?, ?> b) {
        super((TypeNode.TypeNodeBuilder<?, ?>)b);
        this.isAbstract = ((ObjectTypeNodeBuilder)b).isAbstract;
    }

    public static ObjectTypeNodeBuilder<?, ?> builder() {
        return new ObjectTypeNodeBuilderImpl();
    }

    @Override
    public ObjectTypeNodeBuilder<?, ?> toBuilder() {
        return new ObjectTypeNodeBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectTypeNode)) {
            return false;
        }
        ObjectTypeNode other = (ObjectTypeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isAbstract = this.getIsAbstract();
        Boolean other$isAbstract = other.getIsAbstract();
        return !(this$isAbstract == null ? other$isAbstract != null : !((Object)this$isAbstract).equals(other$isAbstract));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObjectTypeNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isAbstract = this.getIsAbstract();
        result = result * 59 + ($isAbstract == null ? 43 : ((Object)$isAbstract).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ObjectTypeNode(isAbstract=" + this.getIsAbstract() + ")";
    }

    private static final class ObjectTypeNodeBuilderImpl
    extends ObjectTypeNodeBuilder<ObjectTypeNode, ObjectTypeNodeBuilderImpl> {
        private ObjectTypeNodeBuilderImpl() {
        }

        @Override
        protected ObjectTypeNodeBuilderImpl self() {
            return this;
        }

        @Override
        public ObjectTypeNode build() {
            return new ObjectTypeNode(this);
        }
    }

    public static abstract class ObjectTypeNodeBuilder<C extends ObjectTypeNode, B extends ObjectTypeNodeBuilder<C, B>>
    extends TypeNode.TypeNodeBuilder<C, B> {
        private Boolean isAbstract;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ObjectTypeNodeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ObjectTypeNode instance, ObjectTypeNodeBuilder<?, ?> b) {
            b.isAbstract(instance.isAbstract);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B isAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ObjectTypeNode.ObjectTypeNodeBuilder(super=" + super.toString() + ", isAbstract=" + this.isAbstract + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ObjectTypeNode> {
        @Override
        public Class<ObjectTypeNode> getType() {
            return ObjectTypeNode.class;
        }

        @Override
        public ObjectTypeNode decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            NodeClass nodeClass = decoder.readEnum("NodeClass", NodeClass.class);
            QualifiedName browseName = decoder.readQualifiedName("BrowseName");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            ReferenceNode[] references = (ReferenceNode[])decoder.readStructArray("References", ReferenceNode.TYPE_ID);
            Boolean isAbstract = decoder.readBoolean("IsAbstract");
            return new ObjectTypeNode(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references, isAbstract);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ObjectTypeNode value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeEnum("NodeClass", value.getNodeClass());
            encoder.writeQualifiedName("BrowseName", value.getBrowseName());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
            encoder.writeStructArray("References", (Object[])value.getReferences(), ReferenceNode.TYPE_ID);
            encoder.writeBoolean("IsAbstract", value.getIsAbstract());
        }
    }
}

