/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.util.HashSet;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.StartupChecks;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeStartupCheck
extends StartupChecks {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeStartupCheck.class);
    private final IoTDBConfig config;
    private static final int DATANODE_PORTS = 6;

    public DataNodeStartupCheck(String nodeRole, IoTDBConfig config) {
        super(nodeRole);
        this.config = config;
    }

    private void checkDataNodePortUnique() throws StartupException {
        HashSet<Integer> portSet = new HashSet<Integer>();
        portSet.add(this.config.getInternalPort());
        portSet.add(this.config.getMqttPort());
        portSet.add(this.config.getRpcPort());
        portSet.add(this.config.getMppDataExchangePort());
        portSet.add(this.config.getDataRegionConsensusPort());
        portSet.add(this.config.getSchemaRegionConsensusPort());
        if (portSet.size() != 6) {
            throw new StartupException("ports used in datanode have repeat.");
        }
        LOGGER.info("DataNode port check successful.");
    }

    protected void portCheck() {
        this.preChecks.add(this::checkDataNodePortUnique);
    }

    public void startUpCheck() throws StartupException {
        this.envCheck();
        this.portCheck();
        this.verify();
    }
}

