/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.nio.charset.Charset;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.jdbc.IoTDBJDBCResultSet;
import org.apache.iotdb.jdbc.IoTDBNonAlignJDBCResultSet;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.thrift.TException;
import org.apache.tsfile.common.conf.TSFileConfig;

public class IoTDBStatement
implements Statement {
    private final IoTDBConnection connection;
    private ResultSet resultSet = null;
    private int fetchSize;
    private int maxRows = 0;
    protected final ZoneId zoneId;
    protected final Charset charset;
    private int queryTimeout = -1;
    protected IClientRPCService.Iface client;
    private List<String> batchSQLList;
    private static final String NOT_SUPPORT_EXECUTE = "Not support execute";
    private static final String NOT_SUPPORT_EXECUTE_UPDATE = "Not support executeUpdate";
    private boolean isClosed = false;
    private boolean isCancelled = false;
    private SQLWarning warningChain = null;
    private long sessionId;
    private long stmtId = -1L;
    private long queryId = -1L;

    IoTDBStatement(IoTDBConnection connection, IClientRPCService.Iface client, long sessionId, int fetchSize, ZoneId zoneId, Charset charset, int seconds) throws SQLException {
        this.connection = connection;
        this.client = client;
        this.sessionId = sessionId;
        this.fetchSize = fetchSize;
        this.batchSQLList = new ArrayList<String>();
        this.zoneId = zoneId;
        this.charset = charset;
        this.queryTimeout = seconds;
        this.requestStmtId();
    }

    IoTDBStatement(IoTDBConnection connection, IClientRPCService.Iface client, long sessionId, ZoneId zoneId, Charset charset, int seconds) throws SQLException {
        this(connection, client, sessionId, 5000, zoneId, charset, seconds);
    }

    IoTDBStatement(IoTDBConnection connection, IClientRPCService.Iface client, long sessionId, ZoneId zoneId, Charset charset) throws SQLException {
        this(connection, client, sessionId, 5000, zoneId, charset, 0);
    }

    IoTDBStatement(IoTDBConnection connection, IClientRPCService.Iface client, long sessionId, ZoneId zoneId, int seconds) throws SQLException {
        this(connection, client, sessionId, 5000, zoneId, TSFileConfig.STRING_CHARSET, seconds);
    }

    IoTDBStatement(IoTDBConnection connection, IClientRPCService.Iface client, long sessionId, ZoneId zoneId, int seconds, long statementId) {
        this.connection = connection;
        this.client = client;
        this.sessionId = sessionId;
        this.fetchSize = 5000;
        this.batchSQLList = new ArrayList<String>();
        this.zoneId = zoneId;
        this.charset = TSFileConfig.STRING_CHARSET;
        this.queryTimeout = seconds;
        this.stmtId = statementId;
    }

    IoTDBStatement(IoTDBConnection connection, IClientRPCService.Iface client, long sessionId, ZoneId zoneId) throws SQLException {
        this(connection, client, sessionId, 5000, zoneId, TSFileConfig.STRING_CHARSET, 0);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public void addBatch(String sql) {
        if (this.batchSQLList == null) {
            this.batchSQLList = new ArrayList<String>();
        }
        this.batchSQLList.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkConnection("cancel");
        if (this.isCancelled) {
            return;
        }
        try {
            if (this.queryId != -1L) {
                TSCancelOperationReq closeReq = new TSCancelOperationReq(this.sessionId, this.queryId);
                TSStatus closeResp = this.client.cancelOperation(closeReq);
                RpcUtils.verifySuccess((TSStatus)closeResp);
            }
        }
        catch (Exception e) {
            throw new SQLException("Error occurs when canceling statement.", e);
        }
        this.isCancelled = true;
    }

    @Override
    public void clearBatch() {
        if (this.batchSQLList == null) {
            this.batchSQLList = new ArrayList<String>();
        }
        this.batchSQLList.clear();
    }

    @Override
    public void clearWarnings() {
        this.warningChain = null;
    }

    private void closeClientOperation() throws SQLException {
        try {
            if (this.stmtId != -1L) {
                TSCloseOperationReq closeReq = new TSCloseOperationReq(this.sessionId);
                closeReq.setStatementId(this.stmtId);
                TSStatus closeResp = this.client.closeOperation(closeReq);
                RpcUtils.verifySuccess((TSStatus)closeResp);
                this.stmtId = -1L;
            }
        }
        catch (Exception e) {
            throw new SQLException("Error occurs when closing statement.", e);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeClientOperation();
        this.isClosed = true;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLException("Not support closeOnCompletion");
    }

    public boolean execute(byte[] sql) throws SQLException {
        return this.execute(new String(sql, this.charset));
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkConnection("execute");
        this.isClosed = false;
        try {
            return this.executeSQL(sql);
        }
        catch (TException e) {
            if (this.reConnect()) {
                try {
                    return this.executeSQL(sql);
                }
                catch (TException e2) {
                    throw new SQLException(e2);
                }
            }
            throw new SQLException(String.format("Fail to reconnect to server when executing %s. please check server status", sql), e);
        }
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        throw new SQLException(NOT_SUPPORT_EXECUTE);
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        throw new SQLException(NOT_SUPPORT_EXECUTE);
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        throw new SQLException(NOT_SUPPORT_EXECUTE);
    }

    private boolean executeSQL(String sql) throws TException, SQLException {
        this.isCancelled = false;
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionId, sql, this.stmtId);
        int rows = this.fetchSize;
        if (this.maxRows != 0 && this.fetchSize > this.maxRows) {
            rows = this.maxRows;
        }
        execReq.setFetchSize(rows);
        execReq.setTimeout((long)this.queryTimeout * 1000L);
        TSExecuteStatementResp execResp = this.client.executeStatementV2(execReq);
        try {
            RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        }
        catch (StatementExecutionException e) {
            throw new IoTDBSQLException(e.getMessage(), execResp.getStatus());
        }
        if (execResp.isSetColumns()) {
            this.queryId = execResp.getQueryId();
            if (execResp.queryResult == null) {
                BitSet aliasColumn = this.listToBitSet(execResp.getAliasColumns());
                this.resultSet = new IoTDBNonAlignJDBCResultSet(this, execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.ignoreTimeStamp, this.client, sql, this.queryId, this.sessionId, execResp.nonAlignQueryDataSet, execResp.tracingInfo, execReq.timeout, execResp.operationType, execResp.getSgColumns(), aliasColumn, this.zoneId);
            } else {
                this.resultSet = new IoTDBJDBCResultSet(this, execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.ignoreTimeStamp, this.client, sql, this.queryId, this.sessionId, execResp.queryResult, execResp.tracingInfo, execReq.timeout, execResp.moreData, this.zoneId, this.charset);
            }
            return true;
        }
        return false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkConnection("executeBatch");
        this.isClosed = false;
        try {
            int[] nArray = this.executeBatchSQL();
            return nArray;
        }
        catch (TException e) {
            if (this.reConnect()) {
                try {
                    int[] nArray = this.executeBatchSQL();
                    return nArray;
                }
                catch (TException e2) {
                    throw new SQLException("Fail to execute batch sqls after reconnecting. please check server status", e2);
                }
            }
            throw new SQLException("Fail to reconnect to server when executing batch sqls. please check server status", e);
        }
        finally {
            this.clearBatch();
        }
    }

    private int[] executeBatchSQL() throws TException, BatchUpdateException {
        this.isCancelled = false;
        TSExecuteBatchStatementReq execReq = new TSExecuteBatchStatementReq(this.sessionId, this.batchSQLList);
        TSStatus execResp = this.client.executeBatchStatement(execReq);
        int[] result = new int[this.batchSQLList.size()];
        boolean allSuccess = true;
        StringBuilder message = new StringBuilder(System.lineSeparator());
        for (int i = 0; i < result.length; ++i) {
            if (execResp.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                result[i] = ((TSStatus)execResp.getSubStatus().get((int)i)).code;
                if (result[i] == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result[i] == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) continue;
                allSuccess = false;
                message.append(((TSStatus)execResp.getSubStatus().get((int)i)).message).append(" for SQL: \"").append(this.batchSQLList.get(i)).append("\"").append(System.lineSeparator());
                continue;
            }
            allSuccess = allSuccess && (execResp.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || execResp.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode());
            result[i] = execResp.getCode();
            message.setLength(0);
            message.append(execResp.getMessage());
        }
        if (!allSuccess) {
            throw new BatchUpdateException(message.toString(), result);
        }
        return result;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQuery(sql, (long)this.queryTimeout * 1000L);
    }

    public ResultSet executeQuery(String sql, long timeoutInMS) throws SQLException {
        this.checkConnection("execute query");
        this.isClosed = false;
        try {
            return this.executeQuerySQL(sql, timeoutInMS);
        }
        catch (TException e) {
            if (this.reConnect()) {
                try {
                    return this.executeQuerySQL(sql, timeoutInMS);
                }
                catch (TException e2) {
                    throw new SQLException("Fail to executeQuery " + sql + "after reconnecting. please check server status", e2);
                }
            }
            throw new SQLException("Fail to reconnect to server when execute query " + sql + ". please check server status", e);
        }
    }

    private ResultSet executeQuerySQL(String sql, long timeoutInMS) throws TException, SQLException {
        this.isCancelled = false;
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionId, sql, this.stmtId);
        int rows = this.fetchSize;
        if (this.maxRows != 0 && this.fetchSize > this.maxRows) {
            rows = this.maxRows;
        }
        execReq.setFetchSize(rows);
        execReq.setTimeout(timeoutInMS);
        execReq.setJdbcQuery(true);
        TSExecuteStatementResp execResp = this.client.executeQueryStatementV2(execReq);
        this.queryId = execResp.getQueryId();
        try {
            RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        }
        catch (StatementExecutionException e) {
            throw new IoTDBSQLException(e.getMessage(), execResp.getStatus());
        }
        BitSet aliasColumn = null;
        if (execResp.getAliasColumns() != null && !execResp.getAliasColumns().isEmpty()) {
            aliasColumn = this.listToBitSet(execResp.getAliasColumns());
        }
        this.resultSet = execResp.queryResult == null ? new IoTDBNonAlignJDBCResultSet(this, execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.ignoreTimeStamp, this.client, sql, this.queryId, this.sessionId, execResp.nonAlignQueryDataSet, execResp.tracingInfo, execReq.timeout, execResp.operationType, execResp.sgColumns, aliasColumn, this.zoneId) : new IoTDBJDBCResultSet(this, execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.ignoreTimeStamp, this.client, sql, this.queryId, this.sessionId, execResp.queryResult, execResp.tracingInfo, execReq.timeout, execResp.operationType, execResp.columns, execResp.sgColumns, aliasColumn, execResp.moreData, this.zoneId, this.charset);
        return this.resultSet;
    }

    private BitSet listToBitSet(List<Byte> listAlias) {
        byte[] byteAlias = new byte[listAlias.size()];
        for (int i = 0; i < listAlias.size(); ++i) {
            byteAlias[i] = listAlias.get(i);
        }
        return BitSet.valueOf(byteAlias);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkConnection("execute update");
        this.isClosed = false;
        try {
            return this.executeUpdateSQL(sql);
        }
        catch (TException e) {
            if (this.reConnect()) {
                try {
                    return this.executeUpdateSQL(sql);
                }
                catch (TException e2) {
                    throw new SQLException("Fail to execute update " + sql + "after reconnecting. please check server status", e2);
                }
            }
            throw new SQLException("Fail to reconnect to server when execute update " + sql + ". please check server status", e);
        }
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        throw new SQLException(NOT_SUPPORT_EXECUTE_UPDATE);
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        throw new SQLException(NOT_SUPPORT_EXECUTE_UPDATE);
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        throw new SQLException(NOT_SUPPORT_EXECUTE_UPDATE);
    }

    private int executeUpdateSQL(String sql) throws TException, IoTDBSQLException {
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionId, sql, this.stmtId);
        TSExecuteStatementResp execResp = this.client.executeUpdateStatement(execReq);
        if (execResp.isSetQueryId()) {
            this.queryId = execResp.getQueryId();
        }
        try {
            RpcUtils.verifySuccess((TSStatus)execResp.getStatus());
        }
        catch (StatementExecutionException e) {
            throw new IoTDBSQLException(e.getMessage(), execResp.getStatus());
        }
        return 0;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkConnection("getFetchDirection");
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkConnection("setFetchDirection");
        if (direction != 1000) {
            throw new SQLException(String.format("direction %d is not supported!", direction));
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkConnection("getFetchSize");
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.checkConnection("setFetchSize");
        if (fetchSize < 0) {
            throw new SQLException(String.format("fetchSize %d must be >= 0!", fetchSize));
        }
        this.fetchSize = fetchSize == 0 ? 5000 : fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("Not support getGeneratedKeys");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLException("Not support getMaxFieldSize");
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        throw new SQLException("Not support getMaxFieldSize");
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int num) throws SQLException {
        this.checkConnection("setMaxRows");
        if (num < 0) {
            throw new SQLException(String.format("maxRows %d must be >= 0!", num));
        }
        this.maxRows = num;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        throw new SQLException("Not support getMoreResults");
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkConnection("setQueryTimeout");
        this.queryTimeout = seconds;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkConnection("getResultSet");
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLException("Not support getResultSetConcurrency");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("Not support getResultSetHoldability");
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkConnection("getResultSetType");
        return 1003;
    }

    @Override
    public int getUpdateCount() {
        return -1;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warningChain;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLException("Not support isCloseOnCompletion");
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLException("Not support isPoolable");
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        throw new SQLException("Not support setPoolable");
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
        throw new SQLException("Not support setCursorName");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLException("Not support setEscapeProcessing");
    }

    private void checkConnection(String action) throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException(String.format("Cannot %s after connection has been closed!", action));
        }
    }

    private boolean reInit() throws SQLException {
        this.client = this.connection.getClient();
        this.sessionId = this.connection.getSessionId();
        try {
            this.stmtId = this.client.requestStatementId(this.sessionId);
            return true;
        }
        catch (Exception e) {
            throw new SQLException("Cannot get id for statement after reconnecting. please check server status", e);
        }
    }

    private void requestStmtId() throws SQLException {
        try {
            this.stmtId = this.client.requestStatementId(this.sessionId);
        }
        catch (TException e) {
            if (this.reConnect()) {
                try {
                    this.stmtId = this.client.requestStatementId(this.sessionId);
                }
                catch (TException e2) {
                    throw new SQLException("Cannot get id for statement after reconnecting. please check server status", e2);
                }
            }
            throw new SQLException("Cannot get id for statement after reconnecting. please check server status", e);
        }
    }

    private boolean reConnect() throws SQLException {
        boolean flag = this.connection.reconnect();
        flag = flag && this.reInit();
        return flag;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public long getStmtId() {
        return this.stmtId;
    }
}

