/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import javax.cache.Cache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.query.AbstractScanQueryIterator;
import org.apache.ignite.internal.processors.cache.query.CacheQuery;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.jetbrains.annotations.Nullable;

public final class ScanQueryIterator<K, V, R>
extends AbstractScanQueryIterator<K, V, R> {
    private static final long serialVersionUID = 0L;
    private final GridDhtCacheAdapter<K, V> dht;
    private final GridDhtLocalPartition locPart;
    private final GridIterator<CacheDataRow> it;
    private final GridCacheAdapter<K, V> cache;
    private final AffinityTopologyVersion topVer;
    private final IgniteLogger log;
    private IgniteCacheExpiryPolicy expiryPlc;
    private final boolean incBackups;
    private final long startTime;
    private final int pageSize;
    @Nullable
    private final GridConcurrentHashSet<ScanQueryIterator<K, V, R>> locIters;

    ScanQueryIterator(GridIterator<CacheDataRow> it, CacheQuery<R> qry, AffinityTopologyVersion topVer, GridDhtLocalPartition locPart, IgniteClosure<Cache.Entry<K, V>, R> transformer, boolean locNode, @Nullable GridConcurrentHashSet<ScanQueryIterator<K, V, R>> locIters, GridCacheContext<K, V> cctx, IgniteLogger log) throws IgniteCheckedException {
        super(cctx, qry, transformer, locNode);
        assert (!locNode || locIters != null) : "Local iterators can't be null for local query.";
        this.it = it;
        this.topVer = topVer;
        this.locPart = locPart;
        this.log = log;
        this.locIters = locIters;
        this.incBackups = qry.includeBackups();
        this.dht = cctx.isNear() ? cctx.near().dht() : cctx.dht();
        this.cache = this.dht != null ? this.dht : cctx.cache();
        this.expiryPlc = this.cctx.cache().expiryPolicy(null);
        this.startTime = U.currentTimeMillis();
        this.pageSize = qry.pageSize();
    }

    @Override
    protected void onClose() {
        if (this.expiryPlc != null && this.dht != null) {
            this.dht.sendTtlUpdateRequest(this.expiryPlc);
            this.expiryPlc = null;
        }
        if (this.locPart != null) {
            this.locPart.release();
        }
        super.onClose();
        if (this.locIters != null) {
            this.locIters.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected R advance() {
        long start = this.statsEnabled ? System.nanoTime() : 0L;
        R next0 = null;
        while (this.it.hasNext()) {
            CacheObject val;
            CacheDataRow row = (CacheDataRow)this.it.next();
            KeyCacheObject key = row.key();
            if (this.expiryPlc != null) {
                try {
                    CacheDataRow tmp = row;
                    while (true) {
                        this.cctx.shared().database().checkpointReadLock();
                        try {
                            GridCacheEntryEx entry = this.cache.entryEx(key);
                            entry.unswap(tmp);
                            val = entry.peek(true, true, this.topVer, this.expiryPlc);
                            entry.touch();
                        }
                        catch (GridCacheEntryRemovedException ignore) {
                            tmp = null;
                            continue;
                        }
                        finally {
                            this.cctx.shared().database().checkpointReadUnlock();
                            continue;
                        }
                        break;
                    }
                }
                catch (IgniteCheckedException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Failed to peek value: " + e);
                    }
                    val = null;
                }
                if (this.dht != null && this.expiryPlc.readyToFlush(100)) {
                    this.dht.sendTtlUpdateRequest(this.expiryPlc);
                }
            } else {
                val = row.value();
            }
            if (!(this.cctx.isReplicated() || this.locPart != null || this.incBackups || this.cctx.affinity().primaryByKey(this.cctx.localNode(), key, this.topVer))) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Ignoring backup element [row=" + row + ", cacheMode=" + this.cctx.config().getCacheMode() + ", incBackups=" + this.incBackups + ", primary=" + this.cctx.affinity().primaryByKey(this.cctx.localNode(), key, this.topVer) + "]");
                continue;
            }
            if (this.log.isDebugEnabled()) {
                ClusterNode primaryNode = this.cctx.affinity().primaryByKey(key, this.cctx.affinity().affinityTopologyVersion());
                this.log.debug(S.toString("Record", "key", (Object)key, true, "val", (Object)val, true, "incBackups", (Object)this.incBackups, false, "priNode", (Object)(primaryNode != null ? U.id8(primaryNode.id()) : null), false, "node", (Object)U.id8(this.cctx.localNode().id()), false));
            }
            if (val == null || (next0 = (R)this.filterAndTransform(key, val, start)) == null) continue;
            break;
        }
        if (next0 == null && this.expiryPlc != null && this.dht != null) {
            this.dht.sendTtlUpdateRequest(this.expiryPlc);
            this.expiryPlc = null;
        }
        return next0;
    }

    public AffinityTopologyVersion topVer() {
        return this.topVer;
    }

    public GridDhtLocalPartition localPartition() {
        return this.locPart;
    }

    public long startTime() {
        return this.startTime;
    }

    public int pageSize() {
        return this.pageSize;
    }
}

