/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class RotatedIdPartRecord
extends PageDeltaRecord {
    private byte rotatedIdPart;

    public RotatedIdPartRecord(int grpId, long pageId, int rotatedIdPart) {
        super(grpId, pageId);
        assert (rotatedIdPart >= 0 && rotatedIdPart <= 255);
        this.rotatedIdPart = (byte)rotatedIdPart;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        PageIO.setRotatedIdPart(pageAddr, this.rotatedIdPart);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.ROTATED_ID_PART_RECORD;
    }

    public byte rotatedIdPart() {
        return this.rotatedIdPart;
    }

    @Override
    public String toString() {
        return S.toString(RotatedIdPartRecord.class, this, "super", (Object)super.toString());
    }
}

