/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.encryption;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.encryption.CacheGroupEncryptionTaskResult;
import org.apache.ignite.internal.management.encryption.EncryptionCacheGroupArg;

abstract class CacheGroupEncryptionCommand<T>
implements ComputeCommand<EncryptionCacheGroupArg, CacheGroupEncryptionTaskResult<T>> {
    CacheGroupEncryptionCommand() {
    }

    @Override
    public void printResult(EncryptionCacheGroupArg arg, CacheGroupEncryptionTaskResult<T> res, Consumer<String> printer) {
        Map<UUID, IgniteException> exceptions = res.exceptions();
        for (Map.Entry<UUID, IgniteException> entry : exceptions.entrySet()) {
            printer.accept("  Node " + entry.getKey() + ":");
            printer.accept(String.format("%sfailed to execute command for the cache group \"%s\": %s.", "    ", arg.cacheGroupName(), entry.getValue().getMessage()));
        }
        Map<UUID, T> results = res.results();
        for (Map.Entry<UUID, T> entry : results.entrySet()) {
            printer.accept("  Node " + entry.getKey() + ":");
            this.printNodeResult(entry.getValue(), arg.cacheGroupName(), printer);
        }
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, EncryptionCacheGroupArg arg) {
        return nodes;
    }

    protected abstract void printNodeResult(T var1, String var2, Consumer<String> var3);
}

