/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ClassSet {
    private static final Map<String, Node> ALL = Collections.emptyMap();
    private Node root = new Node();

    public void add(String clsName) {
        String[] tokens = clsName.split("\\.");
        Node cur = this.root;
        for (int i = 0; i < tokens.length; ++i) {
            Node n;
            if (cur.children == ALL) {
                return;
            }
            if (tokens[i].equals("*")) {
                if (i != tokens.length - 1) {
                    throw new IllegalArgumentException("Incorrect class name format.");
                }
                cur.children = ALL;
                return;
            }
            if (cur.children == null) {
                cur.children = new HashMap<String, Node>();
            }
            if ((n = cur.children.get(tokens[i])) == null) {
                n = new Node();
                cur.children.put(tokens[i], n);
            }
            cur = n;
        }
    }

    public boolean contains(String clsName) {
        String[] tokens = clsName.split("\\.");
        Node cur = this.root;
        for (int i = 0; i < tokens.length; ++i) {
            if (cur.children == ALL) {
                return true;
            }
            if (cur.children == null) {
                return false;
            }
            Node n = cur.children.get(tokens[i]);
            if (n == null) {
                return false;
            }
            if (i == tokens.length - 1) {
                return true;
            }
            cur = n;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassSet)) {
            return false;
        }
        ClassSet other = (ClassSet)o;
        return Objects.equals(this.root, other.root);
    }

    public int hashCode() {
        return Objects.hashCode(this.root);
    }

    private static class Node {
        private Map<String, Node> children;

        private Node() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            return Objects.equals(this.children, other.children);
        }

        public int hashCode() {
            return Objects.hashCode(this.children);
        }
    }
}

