/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.replicator.handlers;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.partition.replicator.ReplicationRaftCommandApplicator;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.command.BuildIndexCommand;
import org.apache.ignite3.internal.partition.replicator.network.replication.BuildIndexReplicaRequest;
import org.apache.ignite3.internal.table.distributed.index.IndexMeta;
import org.apache.ignite3.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite3.internal.table.distributed.index.MetaIndexStatus;
import org.apache.ignite3.internal.table.distributed.index.MetaIndexStatusChange;
import org.apache.ignite3.internal.table.distributed.replicator.IndexBuilderTxRwOperationTracker;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.PendingComparableValuesTracker;

public class BuildIndexReplicaRequestHandler {
    private static final PartitionReplicationMessagesFactory PARTITION_REPLICATION_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private final IndexMetaStorage indexMetaStorage;
    private final IndexBuilderTxRwOperationTracker txRwOperationTracker;
    private final PendingComparableValuesTracker<HybridTimestamp, Void> safeTime;
    private final ReplicationRaftCommandApplicator commandApplicator;

    public BuildIndexReplicaRequestHandler(IndexMetaStorage indexMetaStorage, IndexBuilderTxRwOperationTracker txRwOperationTracker, PendingComparableValuesTracker<HybridTimestamp, Void> safeTime, ReplicationRaftCommandApplicator commandApplicator) {
        this.indexMetaStorage = indexMetaStorage;
        this.txRwOperationTracker = txRwOperationTracker;
        this.safeTime = safeTime;
        this.commandApplicator = commandApplicator;
    }

    public CompletableFuture<?> handle(BuildIndexReplicaRequest request) {
        IndexMeta indexMeta = this.indexMetaStorage.indexMeta(request.indexId());
        if (indexMeta == null || indexMeta.isDropped()) {
            return CompletableFutures.nullCompletedFuture();
        }
        MetaIndexStatusChange registeredChangeInfo = indexMeta.statusChange(MetaIndexStatus.REGISTERED);
        MetaIndexStatusChange buildingChangeInfo = indexMeta.statusChange(MetaIndexStatus.BUILDING);
        return ((CompletableFuture)this.txRwOperationTracker.awaitCompleteTxRwOperations(registeredChangeInfo.catalogVersion()).thenCompose(unused -> this.safeTime.waitFor(HybridTimestamp.hybridTimestamp(buildingChangeInfo.activationTimestamp())))).thenCompose(unused -> this.commandApplicator.applyCommand(BuildIndexReplicaRequestHandler.toBuildIndexCommand(request, buildingChangeInfo)));
    }

    private static BuildIndexCommand toBuildIndexCommand(BuildIndexReplicaRequest request, MetaIndexStatusChange buildingChangeInfo) {
        return PARTITION_REPLICATION_MESSAGES_FACTORY.buildIndexCommandV2().indexId(request.indexId()).tableId(request.tableId()).rowIds(request.rowIds()).finish(request.finish()).requiredCatalogVersion(buildingChangeInfo.catalogVersion()).build();
    }
}

