/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.util.GradualTaskExecutor;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.index.IndexStorage;
import org.apache.ignite3.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite3.internal.storage.index.StorageIndexDescriptor;
import org.apache.ignite3.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.storage.pagememory.index.AbstractPageMemoryIndexStorage;
import org.apache.ignite3.internal.storage.pagememory.index.hash.PageMemoryHashIndexStorage;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMeta;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMetaKey;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.PageMemorySortedIndexStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.IndexStorageFactory;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

class PageMemoryIndexes {
    private final Consumer<MvPartitionStorage.WriteClosure<Void>> runConsistently;
    private final GradualTaskExecutor destructionExecutor;
    private final FailureProcessor failureProcessor;
    private final ConcurrentMap<Integer, PageMemoryHashIndexStorage> hashIndexes = new ConcurrentHashMap<Integer, PageMemoryHashIndexStorage>();
    private final ConcurrentMap<Integer, PageMemorySortedIndexStorage> sortedIndexes = new ConcurrentHashMap<Integer, PageMemorySortedIndexStorage>();

    PageMemoryIndexes(GradualTaskExecutor destructionExecutor, FailureProcessor failureProcessor, Consumer<MvPartitionStorage.WriteClosure<Void>> runConsistently) {
        this.runConsistently = runConsistently;
        this.destructionExecutor = destructionExecutor;
        this.failureProcessor = failureProcessor;
    }

    @Nullable
    IndexStorage getIndex(int indexId) {
        PageMemoryHashIndexStorage hashIndexStorage = (PageMemoryHashIndexStorage)this.hashIndexes.get(indexId);
        if (hashIndexStorage != null) {
            return hashIndexStorage;
        }
        return (IndexStorage)this.sortedIndexes.get(indexId);
    }

    void createHashIndex(StorageHashIndexDescriptor indexDescriptor, IndexStorageFactory indexStorageFactory) {
        assert (!this.sortedIndexes.containsKey(indexDescriptor.id())) : indexDescriptor;
        this.hashIndexes.computeIfAbsent(indexDescriptor.id(), id -> indexStorageFactory.createHashIndexStorage(indexDescriptor));
    }

    void createSortedIndex(StorageSortedIndexDescriptor indexDescriptor, IndexStorageFactory indexStorageFactory) {
        assert (!this.hashIndexes.containsKey(indexDescriptor.id())) : indexDescriptor;
        this.sortedIndexes.computeIfAbsent(indexDescriptor.id(), id -> indexStorageFactory.createSortedIndexStorage(indexDescriptor));
    }

    void performRecovery(IndexMetaTree indexMetaTree, IndexStorageFactory indexStorageFactory, StorageIndexDescriptorSupplier indexDescriptorSupplier) throws IgniteInternalCheckedException {
        try (Cursor cursor = indexMetaTree.find(null, null);){
            for (IndexMeta indexMeta : cursor) {
                AbstractPageMemoryIndexStorage indexStorage;
                int indexId = indexMeta.indexId();
                StorageIndexDescriptor indexDescriptor = indexDescriptorSupplier.get(indexId);
                if (indexDescriptor == null) {
                    this.runConsistently.accept(locker -> {
                        this.destroyIndexOnRecovery(indexMeta, indexStorageFactory, indexMetaTree).whenComplete((v, e) -> {
                            if (e != null) {
                                String errorMessage = String.format("Unable to destroy existing index %s, that has been removed from the Catalog", indexId);
                                this.failureProcessor.process(new FailureContext((Throwable)e, errorMessage));
                            }
                        });
                        return null;
                    });
                    continue;
                }
                if (indexDescriptor instanceof StorageHashIndexDescriptor) {
                    indexStorage = indexStorageFactory.restoreHashIndexStorage((StorageHashIndexDescriptor)indexDescriptor, indexMeta);
                    this.hashIndexes.put(indexId, (PageMemoryHashIndexStorage)indexStorage);
                    continue;
                }
                if (indexDescriptor instanceof StorageSortedIndexDescriptor) {
                    indexStorage = indexStorageFactory.restoreSortedIndexStorage((StorageSortedIndexDescriptor)indexDescriptor, indexMeta);
                    this.sortedIndexes.put(indexId, (PageMemorySortedIndexStorage)indexStorage);
                    continue;
                }
                throw new AssertionError((Object)("Unexpected index descriptor type: " + indexDescriptor));
            }
        }
    }

    private CompletableFuture<Void> destroyIndexOnRecovery(IndexMeta indexMeta, IndexStorageFactory indexStorageFactory, IndexMetaTree indexMetaTree) {
        switch (indexMeta.indexType()) {
            case HASH: {
                PageMemoryHashIndexStorage hashIndexStorage = indexStorageFactory.restoreHashIndexStorageForDestroy(indexMeta);
                return this.destroyStorage(indexMeta.indexId(), hashIndexStorage, indexMetaTree);
            }
            case SORTED: {
                PageMemorySortedIndexStorage sortedIndexStorage = indexStorageFactory.restoreSortedIndexStorageForDestroy(indexMeta);
                return this.destroyStorage(indexMeta.indexId(), sortedIndexStorage, indexMetaTree);
            }
        }
        throw new AssertionError((Object)String.format("Unexpected index type %s for index %d", new Object[]{indexMeta.indexType(), indexMeta.indexId()}));
    }

    CompletableFuture<Void> destroyIndex(int indexId, IndexMetaTree indexMetaTree) {
        PageMemoryHashIndexStorage hashIndexStorage = (PageMemoryHashIndexStorage)this.hashIndexes.remove(indexId);
        if (hashIndexStorage != null) {
            assert (!this.sortedIndexes.containsKey(indexId)) : indexId;
            return this.destroyStorage(indexId, hashIndexStorage, indexMetaTree);
        }
        PageMemorySortedIndexStorage sortedIndexStorage = (PageMemorySortedIndexStorage)this.sortedIndexes.remove(indexId);
        if (sortedIndexStorage != null) {
            return this.destroyStorage(indexId, sortedIndexStorage, indexMetaTree);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private CompletableFuture<Void> destroyStorage(int indexId, AbstractPageMemoryIndexStorage<?, ?, ?> storage, IndexMetaTree indexMetaTree) {
        if (!storage.transitionToDestroyedState()) {
            return CompletableFutures.nullCompletedFuture();
        }
        return ((CompletableFuture)storage.startDestructionOn(this.destructionExecutor).whenComplete((v, e) -> storage.closeStructures())).thenRunAsync(() -> this.runConsistently.accept(locker -> {
            try {
                indexMetaTree.removex(new IndexMetaKey(indexId));
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException(e);
            }
            return null;
        }), this.destructionExecutor.executorService());
    }

    CompletableFuture<Void> destroyStructures() {
        CompletableFuture[] indexDestroyFutures = (CompletableFuture[])Stream.concat(this.hashIndexes.values().stream(), this.sortedIndexes.values().stream()).map(indexStorage -> indexStorage.startDestructionOn(this.destructionExecutor)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(indexDestroyFutures);
    }

    void startRebalance() {
        this.forEachIndex(AbstractPageMemoryIndexStorage::startRebalance);
    }

    void completeRebalance() {
        this.forEachIndex(AbstractPageMemoryIndexStorage::completeRebalance);
    }

    void startCleanup() {
        this.forEachIndex(AbstractPageMemoryIndexStorage::startCleanup);
    }

    void finishCleanup() {
        this.forEachIndex(AbstractPageMemoryIndexStorage::finishCleanup);
    }

    void transitionToDestroyedState() {
        this.forEachIndex(AbstractPageMemoryIndexStorage::transitionToDestroyedState);
    }

    void updateDataStructures(IndexStorageFactory indexStorageFactory) {
        this.hashIndexes.values().forEach(indexStorageFactory::updateDataStructuresIn);
        this.sortedIndexes.values().forEach(indexStorageFactory::updateDataStructuresIn);
    }

    List<AutoCloseable> getResourcesToClose() {
        ArrayList<AutoCloseable> resources = new ArrayList<AutoCloseable>();
        this.forEachIndex(index -> resources.add(index::close));
        resources.add(this.hashIndexes::clear);
        resources.add(this.sortedIndexes::clear);
        return resources;
    }

    private void forEachIndex(Consumer<AbstractPageMemoryIndexStorage<?, ?, ?>> consumer) {
        this.hashIndexes.values().forEach(consumer);
        this.sortedIndexes.values().forEach(consumer);
    }
}

