/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.ignite3.internal.sql.engine.sql.ParseMode;
import org.apache.ignite3.internal.sql.engine.sql.ParseResult;
import org.apache.ignite3.internal.sql.engine.sql.StatementParseResult;
import org.apache.ignite3.internal.tostring.S;

public final class ScriptParseResult
extends ParseResult {
    public static final ParseMode<ScriptParseResult> MODE = new ParseMode<ScriptParseResult>(){

        @Override
        ScriptParseResult createResult(List<SqlNode> list, int dynamicParamsCount) {
            if (list.size() == 1) {
                return new ScriptParseResult(List.of(new StatementParseResult(list.get(0), dynamicParamsCount)), dynamicParamsCount);
            }
            SqlDynamicParamsAdjuster dynamicParamsAdjuster = new SqlDynamicParamsAdjuster();
            List<StatementParseResult> results = list.stream().map(node -> {
                if (dynamicParamsCount == 0) {
                    return new StatementParseResult((SqlNode)node, 0);
                }
                dynamicParamsAdjuster.reset();
                SqlNode newTree = (SqlNode)dynamicParamsAdjuster.visitNode((SqlNode)node);
                assert (newTree != null);
                return new StatementParseResult(newTree, dynamicParamsAdjuster.paramsCount());
            }).collect(Collectors.toList());
            return new ScriptParseResult(results, dynamicParamsCount);
        }
    };
    private final List<StatementParseResult> results;

    private ScriptParseResult(List<StatementParseResult> results, int dynamicParamsCount) {
        super(dynamicParamsCount);
        this.results = results;
    }

    public List<StatementParseResult> results() {
        return this.results;
    }

    public String toString() {
        return S.toString(ScriptParseResult.class, this);
    }

    @NotThreadSafe
    private static final class SqlDynamicParamsAdjuster
    extends SqlShuttle {
        private int counter;

        private SqlDynamicParamsAdjuster() {
        }

        public SqlNode visit(SqlDynamicParam param) {
            return new SqlDynamicParam(this.counter++, param.getParserPosition());
        }

        void reset() {
            this.counter = 0;
        }

        int paramsCount() {
            return this.counter;
        }
    }
}

