/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadWriteSingleRowPkReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadWriteSingleRowPkReplicaRequestImpl;

class ReadWriteSingleRowPkReplicaRequestSerializer
implements MessageSerializer<ReadWriteSingleRowPkReplicaRequest> {
    public static final ReadWriteSingleRowPkReplicaRequestSerializer INSTANCE = new ReadWriteSingleRowPkReplicaRequestSerializer();

    private ReadWriteSingleRowPkReplicaRequestSerializer() {
    }

    @Override
    public boolean writeMessage(ReadWriteSingleRowPkReplicaRequest msg, MessageWriter writer) throws MessageMappingException {
        ReadWriteSingleRowPkReplicaRequestImpl message = (ReadWriteSingleRowPkReplicaRequestImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)12)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("commitPartitionId", message.commitPartitionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeUuid("coordinatorId", message.coordinatorId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeBoxedLong("enlistmentConsistencyToken", message.enlistmentConsistencyToken());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeBoolean("full", message.full());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeMessage("groupId", message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeByteBuffer("primaryKey", message.primaryKey());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                int idShifted = message.requestType() == null ? 0 : message.requestType().id() + 1;
                boolean written = writer.writeInt("requestType", idShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeInt("schemaVersion", message.schemaVersion());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                boolean written = writer.writeBoolean("skipDelayedAck", message.skipDelayedAck());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                boolean written = writer.writeInt("tableId", message.tableId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                boolean written = writer.writeUuid("transactionId", message.transactionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

