/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.partition.replicator.network.command.TimedBinaryRowMessage;
import org.apache.ignite3.internal.partition.replicator.network.command.TimedBinaryRowMessageBuilder;
import org.apache.ignite3.internal.partition.replicator.network.command.TimedBinaryRowMessageSerializer;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryRowMessage;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class TimedBinaryRowMessageImpl
implements TimedBinaryRowMessage,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 24;
    @IgniteToStringInclude
    private final BinaryRowMessage binaryRowMessage;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;

    private TimedBinaryRowMessageImpl(BinaryRowMessage binaryRowMessage, HybridTimestamp timestamp) {
        this.binaryRowMessage = binaryRowMessage;
        this.timestamp = timestamp;
    }

    @Override
    public BinaryRowMessage binaryRowMessage() {
        return this.binaryRowMessage;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public MessageSerializer serializer() {
        return TimedBinaryRowMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(TimedBinaryRowMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 24;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TimedBinaryRowMessageImpl otherMessage = (TimedBinaryRowMessageImpl)other;
        return Objects.equals(this.binaryRowMessage, otherMessage.binaryRowMessage) && Objects.equals(this.timestamp, otherMessage.timestamp);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.binaryRowMessage, this.timestamp);
        return result;
    }

    @Override
    public TimedBinaryRowMessageImpl clone() {
        try {
            return (TimedBinaryRowMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TimedBinaryRowMessageBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.binaryRowMessage != null) {
            this.binaryRowMessage.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.binaryRowMessage != null) {
            this.binaryRowMessage.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements TimedBinaryRowMessageBuilder {
        private BinaryRowMessage binaryRowMessage;
        private HybridTimestamp timestamp;

        private Builder() {
        }

        @Override
        public TimedBinaryRowMessageBuilder binaryRowMessage(BinaryRowMessage binaryRowMessage) {
            this.binaryRowMessage = binaryRowMessage;
            return this;
        }

        @Override
        public TimedBinaryRowMessageBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public BinaryRowMessage binaryRowMessage() {
            return this.binaryRowMessage;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public TimedBinaryRowMessage build() {
            return new TimedBinaryRowMessageImpl(this.binaryRowMessage, this.timestamp);
        }
    }
}

