/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence;

import org.apache.ignite3.internal.lang.IgniteStringBuilder;
import org.apache.ignite3.internal.pagememory.FullPageId;

public final class DirtyFullPageId
extends FullPageId {
    public static final DirtyFullPageId NULL_PAGE = new DirtyFullPageId(-1L, -1, -1);
    private final int partitionGeneration;

    public DirtyFullPageId(long pageId, int groupId, int partitionGeneration) {
        super(pageId, groupId);
        this.partitionGeneration = partitionGeneration;
    }

    public DirtyFullPageId(FullPageId fullPageId, int partitionGeneration) {
        this(fullPageId.pageId(), fullPageId.groupId(), partitionGeneration);
    }

    public int partitionGeneration() {
        return this.partitionGeneration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirtyFullPageId that = (DirtyFullPageId)o;
        return this.effectivePageId() == that.effectivePageId() && this.groupId() == that.groupId() && this.partitionGeneration == that.partitionGeneration;
    }

    @Override
    public int hashCode() {
        return (int)(DirtyFullPageId.mix64(this.effectivePageId()) ^ (long)DirtyFullPageId.mix32(this.groupId()) ^ (long)DirtyFullPageId.mix32(this.partitionGeneration));
    }

    @Override
    public String toString() {
        return new IgniteStringBuilder("DirtyFullPageId [pageId=").appendHex(this.pageId()).app(", effectivePageId=").appendHex(this.effectivePageId()).app(", groupId=").app(this.groupId()).app(", partitionGeneration=").app(this.partitionGeneration).app(']').toString();
    }

    public FullPageId toFullPageId() {
        return new FullPageId(this.pageId(), this.groupId());
    }
}

