/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.serialization.marshal;

import java.io.ObjectStreamClass;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.apache.ignite3.internal.network.serialization.Classes;
import org.apache.ignite3.internal.network.serialization.marshal.Instantiation;
import org.apache.ignite3.internal.network.serialization.marshal.InstantiationException;

class SerializableInstantiation
implements Instantiation {
    private static final MethodHandle STREAM_CLASS_NEW_INSTANCE;

    SerializableInstantiation() {
    }

    private static MethodHandle streamClassNewInstanceMethodHandle() throws NoSuchMethodException, IllegalAccessException {
        MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(ObjectStreamClass.class, MethodHandles.lookup());
        return lookup.findVirtual(ObjectStreamClass.class, "newInstance", MethodType.methodType(Object.class));
    }

    @Override
    public boolean supports(Class<?> objectClass) {
        return Classes.isSerializable(objectClass);
    }

    @Override
    public Object newInstance(Class<?> objectClass) throws InstantiationException {
        ObjectStreamClass desc = ObjectStreamClass.lookup(objectClass);
        try {
            return STREAM_CLASS_NEW_INSTANCE.invokeExact(desc);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InstantiationException("Cannot instantiate", e);
        }
    }

    static {
        try {
            STREAM_CLASS_NEW_INSTANCE = SerializableInstantiation.streamClassNewInstanceMethodHandle();
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

