/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.serialization;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.Nullable;

public class Classes {
    public static boolean isSerializable(Class<?> objectClass) {
        return Serializable.class.isAssignableFrom(objectClass);
    }

    public static boolean isLambda(Class<?> objectClass) {
        return !objectClass.isPrimitive() && !objectClass.isArray() && !objectClass.isAnonymousClass() && !objectClass.isLocalClass() && objectClass.isSynthetic() && Classes.classCannotBeLoadedByName(objectClass);
    }

    private static boolean classCannotBeLoadedByName(Class<?> objectClass) {
        try {
            Class.forName(objectClass.getName());
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    public static boolean isExternalizable(Class<?> objectClass) {
        return Externalizable.class.isAssignableFrom(objectClass);
    }

    public static boolean isRuntimeEnum(Class<?> objectClass) {
        return Enum.class.isAssignableFrom(objectClass) && objectClass != Enum.class;
    }

    public static Class<?> enumClassAsInSourceCode(Class<?> enumClass) {
        assert (enumClass != null);
        assert (Enum.class.isAssignableFrom(enumClass));
        if (!enumClass.isEnum()) {
            enumClass = enumClass.getSuperclass();
        }
        return enumClass;
    }

    public static boolean isRuntimeTypeKnownUpfront(Class<?> clazz) {
        if (clazz.isArray()) {
            return Classes.isRuntimeTypeKnownUpfront(clazz.getComponentType());
        }
        if (clazz == String.class) {
            return false;
        }
        return clazz.isPrimitive() || Modifier.isFinal(clazz.getModifiers()) || Classes.isRuntimeEnum(clazz);
    }

    public static boolean isSerializationTypeKnownUpfront(Class<?> clazz) {
        return Classes.isRuntimeTypeKnownUpfront(clazz) && !Classes.typeCanBeReplacedDuringSerialization(clazz);
    }

    private static boolean typeCanBeReplacedDuringSerialization(Class<?> clazz) {
        return Serializable.class.isAssignableFrom(clazz) && !Externalizable.class.isAssignableFrom(clazz) && Classes.hasWriteReplace(clazz);
    }

    static boolean hasWriteReplace(Class<?> clazz) {
        return Classes.getWriteReplace(clazz) != null;
    }

    @Nullable
    static Method getWriteReplace(Class<?> clazz) {
        return Classes.findInheritableMethod(clazz, "writeReplace");
    }

    @Nullable
    static Method getReadResolve(Class<?> clazz) {
        return Classes.findInheritableMethod(clazz, "readResolve");
    }

    @Nullable
    private static Method findInheritableMethod(Class<?> clazz, String name) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    private Classes() {
    }
}

