/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.scalecube;

import io.scalecube.cluster.transport.api.Message;
import io.scalecube.cluster.transport.api.Transport;
import io.scalecube.net.Address;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.ChannelType;
import org.apache.ignite3.internal.network.MessagingService;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.network.NetworkMessageTypes;
import org.apache.ignite3.internal.network.NetworkMessagesFactory;
import org.apache.ignite3.internal.network.message.ScaleCubeMessage;
import org.apache.ignite3.internal.network.message.ScaleCubeMessageBuilder;
import org.apache.ignite3.network.NetworkAddress;
import org.jetbrains.annotations.Nullable;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.MonoSink;

class ScaleCubeDirectMarshallerTransport
implements Transport {
    private static final IgniteLogger LOG = Loggers.forClass(Transport.class);
    static final ChannelType SCALE_CUBE_CHANNEL_TYPE = new ChannelType(1, "ScaleCube");
    private final DirectProcessor<Message> subject = DirectProcessor.create();
    private final FluxSink<Message> sink = this.subject.sink();
    private final MonoProcessor<Void> stop = MonoProcessor.create();
    private final MonoProcessor<Void> onStop = MonoProcessor.create();
    private final MessagingService messagingService;
    private final NetworkMessagesFactory messageFactory;
    private final Address address;

    ScaleCubeDirectMarshallerTransport(Address localAddress, MessagingService messagingService, NetworkMessagesFactory messageFactory) {
        this.address = localAddress;
        this.messagingService = messagingService;
        this.messageFactory = messageFactory;
        this.messagingService.addMessageHandler(NetworkMessageTypes.class, (message, sender, correlationId) -> this.onMessage(message));
        this.stop.then(this.doStop()).doFinally(s -> this.onStop.onComplete()).subscribe(null, ex -> LOG.warn("Failed to stop [address={}, reason={}]", this.address, ex.toString()));
    }

    private Mono<Void> doStop() {
        return Mono.defer(() -> {
            LOG.info("Stopping [address={}]", this.address);
            this.sink.complete();
            LOG.info("Stopped [address={}]", this.address);
            return Mono.empty();
        });
    }

    public Address address() {
        return this.address;
    }

    public Mono<Transport> start() {
        return Mono.just((Object)this);
    }

    public Mono<Void> stop() {
        return Mono.defer(() -> {
            this.stop.onComplete();
            return this.onStop;
        });
    }

    public boolean isStopped() {
        return this.onStop.isDisposed();
    }

    public Mono<Void> send(Address address, Message message) {
        NetworkAddress addr = new NetworkAddress(address.host(), address.port());
        return Mono.fromFuture(() -> this.messagingService.send(addr, SCALE_CUBE_CHANNEL_TYPE, this.fromMessage(message)));
    }

    private void onMessage(NetworkMessage msg) {
        Message message = ScaleCubeDirectMarshallerTransport.fromNetworkMessage(msg);
        if (message != null) {
            this.sink.next((Object)message);
        }
    }

    private NetworkMessage fromMessage(Message message) throws IgniteInternalException {
        Object dataObj = message.data();
        ScaleCubeMessageBuilder scaleCubeMessageBuilder = this.messageFactory.scaleCubeMessage();
        if (dataObj instanceof NetworkMessage) {
            scaleCubeMessageBuilder.message((NetworkMessage)dataObj);
        } else {
            scaleCubeMessageBuilder.data(dataObj);
        }
        return scaleCubeMessageBuilder.headers(message.headers()).build();
    }

    @Nullable
    private static Message fromNetworkMessage(NetworkMessage networkMessage) throws IgniteInternalException {
        if (networkMessage instanceof ScaleCubeMessage) {
            ScaleCubeMessage msg = (ScaleCubeMessage)networkMessage;
            Map<String, String> headers = msg.headers();
            Object obj = msg.data();
            NetworkMessage message = msg.message();
            Object data = obj != null ? obj : message;
            return Message.withHeaders(headers).data(data).build();
        }
        return null;
    }

    public Mono<Message> requestResponse(Address address, Message request) {
        return Mono.create(sink -> {
            Objects.requireNonNull(request, "request must be not null");
            Objects.requireNonNull(request.correlationId(), "correlationId must be not null");
            Disposable receive = this.listen().filter(resp -> resp.correlationId() != null).filter(resp -> resp.correlationId().equals(request.correlationId())).take(1L).subscribe(arg_0 -> ((MonoSink)sink).success(arg_0), arg_0 -> ((MonoSink)sink).error(arg_0), () -> ((MonoSink)sink).success());
            Disposable send = this.send(address, request).subscribe(null, ex -> {
                receive.dispose();
                sink.error(ex);
            });
            sink.onDispose((Disposable)Disposables.composite((Disposable[])new Disposable[]{send, receive}));
        });
    }

    public final Flux<Message> listen() {
        return this.subject.onBackpressureBuffer();
    }
}

