/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.metastore;

import java.util.List;
import org.apache.ignite3.deployment.version.Version;
import org.apache.ignite3.internal.deployunit.metastore.status.UnitNodeStatus;

public abstract class NodeEventCallback {
    public void onUpdate(UnitNodeStatus status, List<UnitNodeStatus> holders) {
        switch (status.status()) {
            case UPLOADING: {
                this.onUploading(status.id(), status.version(), holders);
                break;
            }
            case DEPLOYED: {
                this.onDeploy(status.id(), status.version(), holders);
                break;
            }
            case REMOVING: {
                this.onRemoving(status.id(), status.version(), holders);
                break;
            }
            case OBSOLETE: {
                this.onObsolete(status.id(), status.version(), holders);
                break;
            }
        }
    }

    protected void onUploading(String id, Version version, List<UnitNodeStatus> holders) {
    }

    protected void onDeploy(String id, Version version, List<UnitNodeStatus> holders) {
    }

    protected void onObsolete(String id, Version version, List<UnitNodeStatus> holders) {
    }

    protected void onRemoving(String id, Version version, List<UnitNodeStatus> holders) {
    }
}

