/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.util.ByteUtils;

public class ConfigurationSerializationUtil {
    private static final byte BOOLEAN = 1;
    private static final byte BYTE = 2;
    private static final byte SHORT = 3;
    private static final byte INT = 4;
    private static final byte LONG = 5;
    private static final byte CHAR = 6;
    private static final byte FLOAT = 7;
    private static final byte DOUBLE = 8;
    private static final byte STRING = 9;
    private static final byte UUID = 10;
    private static final byte ARRAY = -128;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static byte[] toBytes(Object value) {
        Objects.requireNonNull(value);
        byte header = ConfigurationSerializationUtil.header(value.getClass());
        switch (header) {
            case 1: {
                return new byte[]{header, ByteUtils.booleanToByte((Boolean)value)};
            }
            case 2: {
                return new byte[]{header, (Byte)value};
            }
            case 3: {
                return ConfigurationSerializationUtil.allocateBuffer(3).put(header).putShort((Short)value).array();
            }
            case 4: {
                return ConfigurationSerializationUtil.allocateBuffer(5).put(header).putInt((Integer)value).array();
            }
            case 5: {
                return ConfigurationSerializationUtil.allocateBuffer(9).put(header).putLong((Long)value).array();
            }
            case 6: {
                return ConfigurationSerializationUtil.allocateBuffer(3).put(header).putChar(((Character)value).charValue()).array();
            }
            case 7: {
                return ConfigurationSerializationUtil.allocateBuffer(5).put(header).putFloat(((Float)value).floatValue()).array();
            }
            case 8: {
                return ConfigurationSerializationUtil.allocateBuffer(9).put(header).putDouble((Double)value).array();
            }
            case 9: {
                byte[] strBytes = ((String)value).getBytes(StandardCharsets.UTF_8);
                return ConfigurationSerializationUtil.allocateBuffer(1 + strBytes.length).put(header).put(strBytes).array();
            }
            case 10: {
                UUID uuid = (UUID)value;
                return ConfigurationSerializationUtil.allocateBuffer(17).put(header).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
            }
            case -127: {
                return ConfigurationSerializationUtil.compressBooleanArray((boolean[])value);
            }
            case -126: {
                byte[] bytes2 = (byte[])value;
                return ConfigurationSerializationUtil.allocateBuffer(1 + bytes2.length).put(header).put(bytes2).array();
            }
            case -125: {
                short[] shorts = (short[])value;
                ByteBuffer buf = ConfigurationSerializationUtil.allocateBuffer(1 + 2 * shorts.length);
                buf.put(header);
                for (short s2 : shorts) {
                    buf.putShort(s2);
                }
                return buf.array();
            }
            case -124: {
                int[] ints = (int[])value;
                ByteBuffer buf = ConfigurationSerializationUtil.allocateBuffer(1 + 4 * ints.length);
                buf.put(header);
                for (int n : ints) {
                    buf.putInt(n);
                }
                return buf.array();
            }
            case -123: {
                long[] longs = (long[])value;
                ByteBuffer buf = ConfigurationSerializationUtil.allocateBuffer(1 + 8 * longs.length);
                buf.put(header);
                for (long n : longs) {
                    buf.putLong(n);
                }
                return buf.array();
            }
            case -122: {
                char[] chars = (char[])value;
                ByteBuffer buf = ConfigurationSerializationUtil.allocateBuffer(1 + 2 * chars.length);
                buf.put(header);
                for (char c : chars) {
                    buf.putChar(c);
                }
                return buf.array();
            }
            case -121: {
                float[] floats = (float[])value;
                ByteBuffer buf = ConfigurationSerializationUtil.allocateBuffer(1 + 4 * floats.length);
                buf.put(header);
                for (float f : floats) {
                    buf.putFloat(f);
                }
                return buf.array();
            }
            case -120: {
                double[] doubles = (double[])value;
                ByteBuffer buf = ConfigurationSerializationUtil.allocateBuffer(1 + 8 * doubles.length);
                buf.put(header);
                for (double d : doubles) {
                    buf.putDouble(d);
                }
                return buf.array();
            }
            case -119: {
                String[] strings = (String[])value;
                byte[][] strBytes = (byte[][])Arrays.stream(strings).map(s -> s.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]);
                int totalSize = Arrays.stream(strBytes).mapToInt(bytes -> ((byte[])bytes).length).sum();
                ByteBuffer buf = ConfigurationSerializationUtil.allocateBuffer(1 + 4 * strBytes.length + totalSize);
                buf.put(header);
                for (int i = 0; i < strings.length; ++i) {
                    buf.putInt(strBytes[i].length);
                    buf.put(strBytes[i]);
                }
                return buf.array();
            }
            case -118: {
                UUID[] uuids = (UUID[])value;
                ByteBuffer buf = ConfigurationSerializationUtil.allocateBuffer(1 + 16 * uuids.length);
                buf.put(header);
                for (UUID uuid : uuids) {
                    buf.putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
                }
                return buf.array();
            }
        }
        throw new IllegalArgumentException(value.getClass().getName());
    }

    public static Serializable fromBytes(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        byte header = buf.get();
        switch (header) {
            case 1: {
                return Boolean.valueOf(ByteUtils.byteToBoolean(buf.get()));
            }
            case 2: {
                return Byte.valueOf(buf.get());
            }
            case 3: {
                return Short.valueOf(buf.getShort());
            }
            case 4: {
                return Integer.valueOf(buf.getInt());
            }
            case 5: {
                return Long.valueOf(buf.getLong());
            }
            case 6: {
                return Character.valueOf(buf.getChar());
            }
            case 7: {
                return Float.valueOf(buf.getFloat());
            }
            case 8: {
                return Double.valueOf(buf.getDouble());
            }
            case 9: {
                return new String(bytes, 1, bytes.length - 1, StandardCharsets.UTF_8);
            }
            case 10: {
                return new UUID(buf.getLong(), buf.getLong());
            }
            case -127: {
                return ConfigurationSerializationUtil.decompressBooleanArray(bytes);
            }
            case -126: {
                return Arrays.copyOfRange(bytes, 1, bytes.length);
            }
            case -125: {
                short[] shorts = new short[bytes.length / 2];
                for (int i = 0; i < shorts.length; ++i) {
                    shorts[i] = buf.getShort();
                }
                return shorts;
            }
            case -124: {
                int[] ints = new int[bytes.length / 4];
                for (int i = 0; i < ints.length; ++i) {
                    ints[i] = buf.getInt();
                }
                return ints;
            }
            case -123: {
                long[] longs = new long[bytes.length / 8];
                for (int i = 0; i < longs.length; ++i) {
                    longs[i] = buf.getLong();
                }
                return longs;
            }
            case -122: {
                char[] chars = new char[bytes.length / 2];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = buf.getChar();
                }
                return chars;
            }
            case -121: {
                float[] floats = new float[bytes.length / 4];
                for (int i = 0; i < floats.length; ++i) {
                    floats[i] = buf.getFloat();
                }
                return floats;
            }
            case -120: {
                double[] doubles = new double[bytes.length / 8];
                for (int i = 0; i < doubles.length; ++i) {
                    doubles[i] = buf.getDouble();
                }
                return doubles;
            }
            case -119: {
                int size;
                ArrayList<String> res = new ArrayList<String>();
                for (int offset = 1; offset != bytes.length; offset += 4 + size) {
                    size = buf.getInt(offset);
                    res.add(new String(bytes, offset + 4, size, StandardCharsets.UTF_8));
                }
                return res.toArray(EMPTY_STRING_ARRAY);
            }
            case -118: {
                UUID[] uuids = new UUID[bytes.length / 16];
                for (int i = 0; i < uuids.length; ++i) {
                    uuids[i] = new UUID(buf.getLong(), buf.getLong());
                }
                return uuids;
            }
        }
        throw new IllegalArgumentException(Arrays.toString(bytes));
    }

    private static ByteBuffer allocateBuffer(int size) {
        return ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
    }

    private static byte header(Class<?> clazz) {
        if (clazz == Boolean.class) {
            return 1;
        }
        if (clazz == Byte.class) {
            return 2;
        }
        if (clazz == Short.class) {
            return 3;
        }
        if (clazz == Integer.class) {
            return 4;
        }
        if (clazz == Long.class) {
            return 5;
        }
        if (clazz == Character.class) {
            return 6;
        }
        if (clazz == Float.class) {
            return 7;
        }
        if (clazz == Double.class) {
            return 8;
        }
        if (clazz == String.class) {
            return 9;
        }
        if (clazz == UUID.class) {
            return 10;
        }
        if (clazz == boolean[].class) {
            return -127;
        }
        if (clazz == byte[].class) {
            return -126;
        }
        if (clazz == short[].class) {
            return -125;
        }
        if (clazz == int[].class) {
            return -124;
        }
        if (clazz == long[].class) {
            return -123;
        }
        if (clazz == char[].class) {
            return -122;
        }
        if (clazz == float[].class) {
            return -121;
        }
        if (clazz == double[].class) {
            return -120;
        }
        if (clazz == String[].class) {
            return -119;
        }
        if (clazz == UUID[].class) {
            return -118;
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    private static byte[] compressBooleanArray(boolean[] value) {
        boolean[] booleans = value;
        int payloadSize = (booleans.length + 8 - 1) / 8;
        ByteBuffer buf = ConfigurationSerializationUtil.allocateBuffer(2 + payloadSize);
        buf.put((byte)-127);
        byte paddingLength = (byte)(payloadSize * 8 - booleans.length);
        buf.put(paddingLength);
        byte[] res = buf.array();
        for (int i = 0; i < booleans.length; ++i) {
            if (!booleans[i]) continue;
            int n = 2 + (i >>> 3);
            res[n] = (byte)(res[n] | 1 << (i & 7));
        }
        return res;
    }

    private static boolean[] decompressBooleanArray(byte[] bytes) {
        byte paddingLength = bytes[1];
        boolean[] booleans = new boolean[8 * (bytes.length - 2) - paddingLength];
        for (int i = 0; i < booleans.length; ++i) {
            booleans[i] = (bytes[2 + (i >>> 3)] & 1 << (i & 7)) != 0;
        }
        return booleans;
    }
}

