/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite3.internal.compute.ComputeJobDataHolder;
import org.apache.ignite3.internal.compute.message.JobResultResponse;
import org.apache.ignite3.internal.compute.message.JobResultResponseBuilder;
import org.apache.ignite3.internal.compute.message.JobResultResponseSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class JobResultResponseImpl
implements JobResultResponse,
Cloneable {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 4;
    @IgniteToStringInclude
    private ComputeJobDataHolder result;
    private byte[] resultByteArray;
    @IgniteToStringInclude
    private Throwable throwable;
    private byte[] throwableByteArray;

    private JobResultResponseImpl(ComputeJobDataHolder result, byte[] resultByteArray, Throwable throwable, byte[] throwableByteArray) {
        this.result = result;
        this.resultByteArray = resultByteArray;
        this.throwable = throwable;
        this.throwableByteArray = throwableByteArray;
    }

    byte[] resultByteArray() {
        return this.resultByteArray;
    }

    @Override
    public ComputeJobDataHolder result() {
        return this.result;
    }

    byte[] throwableByteArray() {
        return this.throwableByteArray;
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    public MessageSerializer serializer() {
        return JobResultResponseSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(JobResultResponseImpl.class, this);
    }

    @Override
    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JobResultResponseImpl otherMessage = (JobResultResponseImpl)other;
        return Objects.equals(this.result, otherMessage.result) && Objects.equals(this.throwable, otherMessage.throwable);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.result, this.throwable);
        return result;
    }

    @Override
    public JobResultResponseImpl clone() {
        try {
            return (JobResultResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static JobResultResponseBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject resultByteArraymo = marshaller.marshal(this.result);
        usedDescriptors.addAll((IntCollection)resultByteArraymo.usedDescriptorIds());
        this.resultByteArray = resultByteArraymo.bytes();
        MarshalledObject throwableByteArraymo = marshaller.marshal(this.throwable);
        usedDescriptors.addAll((IntCollection)throwableByteArraymo.usedDescriptorIds());
        this.throwableByteArray = throwableByteArraymo.bytes();
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.result = (ComputeJobDataHolder)marshaller.unmarshal(this.resultByteArray, descriptorsObj);
        this.resultByteArray = null;
        this.throwable = (Throwable)marshaller.unmarshal(this.throwableByteArray, descriptorsObj);
        this.throwableByteArray = null;
    }

    private static class Builder
    implements JobResultResponseBuilder {
        private ComputeJobDataHolder result;
        private byte[] resultByteArray;
        private Throwable throwable;
        private byte[] throwableByteArray;

        private Builder() {
        }

        @Override
        public JobResultResponseBuilder result(ComputeJobDataHolder result) {
            this.result = result;
            return this;
        }

        @Override
        public JobResultResponseBuilder resultByteArray(byte[] resultByteArray) {
            this.resultByteArray = resultByteArray;
            return this;
        }

        @Override
        public JobResultResponseBuilder throwable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        @Override
        public JobResultResponseBuilder throwableByteArray(byte[] throwableByteArray) {
            this.throwableByteArray = throwableByteArray;
            return this;
        }

        @Override
        public ComputeJobDataHolder result() {
            return this.result;
        }

        @Override
        public byte[] resultByteArray() {
            return this.resultByteArray;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public byte[] throwableByteArray() {
            return this.throwableByteArray;
        }

        @Override
        public JobResultResponse build() {
            return new JobResultResponseImpl(this.result, this.resultByteArray, this.throwable, this.throwableByteArray);
        }
    }
}

