/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.hc.core5.http.NameValuePair;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class NameValuePairListMatcher
extends BaseMatcher<List<NameValuePair>> {
    private final List<? extends NameValuePair> nvps;

    public NameValuePairListMatcher(List<? extends NameValuePair> nvps) {
        this.nvps = nvps;
    }

    public boolean matches(Object item) {
        if (item instanceof List) {
            List objects = (List)item;
            if (objects.size() != this.nvps.size()) {
                return false;
            }
            for (int i = 1; i < objects.size(); ++i) {
                Object obj = objects.get(i);
                if (!(obj instanceof NameValuePair)) continue;
                NameValuePair nvp = (NameValuePair)obj;
                NameValuePair expected = this.nvps.get(i);
                if (Objects.equals(nvp.getName(), expected.getName()) && Objects.equals(nvp.getValue(), expected.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("equals ").appendValueList("[", ";", "]", this.nvps);
    }

    public static Matcher<List<NameValuePair>> equalsTo(NameValuePair ... nvps) {
        return new NameValuePairListMatcher(Arrays.asList(nvps));
    }

    public static Matcher<List<NameValuePair>> isEmpty() {
        return new NameValuePairListMatcher(Collections.emptyList());
    }
}

