/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllDirectCompactItemsSketch;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantilescommon.GenericSortedViewIterator;
import org.apache.datasketches.quantilescommon.ItemsSketchSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesGenericSketchIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDirectCompactItemsSketchIteratorTest {
    private ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
    private static final boolean enablePrinting = false;

    @Test
    public void emptySketch() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        byte[] byteArr = sk.toByteArray();
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])byteArr), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectCompactItemsSketch));
        QuantilesGenericSketchIterator itr = sk2.iterator();
        Assert.assertFalse((boolean)itr.next());
    }

    @Test
    public void oneItemSketch() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"1");
        byte[] byteArr = sk.toByteArray();
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])byteArr), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectCompactItemsSketch));
        QuantilesGenericSketchIterator itr = sk2.iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"1");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertFalse((boolean)itr.next());
    }

    @Test
    public void twoItemSketchForIterator() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"1");
        sk.update((Object)"2");
        byte[] byteArr = sk.toByteArray();
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])byteArr), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectCompactItemsSketch));
        QuantilesGenericSketchIterator itr = sk2.iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"2");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"1");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
    }

    @Test
    public void twoItemSketchForSortedViewIterator() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"1");
        sk.update((Object)"2");
        KllDirectCompactItemsSketchIteratorTest.println(sk.toString(true, true));
        byte[] byteArr = sk.toByteArray();
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])byteArr), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)(sk2 instanceof KllDirectCompactItemsSketch));
        ItemsSketchSortedView sv = sk2.getSortedView();
        GenericSortedViewIterator itr = sv.iterator();
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"1");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.EXCLUSIVE), (long)0L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)1L);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE), (double)0.5);
        Assert.assertTrue((boolean)itr.next());
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"2");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.EXCLUSIVE), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)2L);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.EXCLUSIVE), (double)0.5);
        Assert.assertEquals((double)itr.getNormalizedRank(QuantileSearchCriteria.INCLUSIVE), (double)1.0);
    }

    @Test
    public void bigSketches() {
        int digits = 6;
        for (int n = 1000; n < 100000; n += 2000) {
            KllItemsSketch sk = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
            for (int i = 0; i < n; ++i) {
                sk.update((Object)Util.longToFixedLengthString((long)i, (int)6));
            }
            byte[] byteArr = sk.toByteArray();
            KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])byteArr), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
            Assert.assertTrue((boolean)(sk2 instanceof KllDirectCompactItemsSketch));
            QuantilesGenericSketchIterator itr = sk2.iterator();
            int count = 0;
            int weight = 0;
            while (itr.next()) {
                ++count;
                weight += (int)itr.getWeight();
            }
            Assert.assertEquals((int)count, (int)sk.getNumRetained());
            Assert.assertEquals((int)weight, (int)n);
        }
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

