/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.analysis.interpolation;

import org.apache.commons.math4.legacy.analysis.interpolation.BivariateGridInterpolator;
import org.apache.commons.math4.legacy.analysis.interpolation.PiecewiseBicubicSplineInterpolatingFunction;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.NoDataException;
import org.apache.commons.math4.legacy.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;

public class PiecewiseBicubicSplineInterpolator
implements BivariateGridInterpolator {
    @Override
    public PiecewiseBicubicSplineInterpolatingFunction interpolate(double[] xval, double[] yval, double[][] fval) throws DimensionMismatchException, NullArgumentException, NoDataException, NonMonotonicSequenceException {
        if (xval == null || yval == null || fval == null || fval[0] == null) {
            throw new NullArgumentException();
        }
        if (xval.length == 0 || yval.length == 0 || fval.length == 0) {
            throw new NoDataException();
        }
        MathArrays.checkOrder((double[])xval);
        MathArrays.checkOrder((double[])yval);
        return new PiecewiseBicubicSplineInterpolatingFunction(xval, yval, fval);
    }
}

