/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.beanutils2.AlphaBean;
import org.apache.commons.beanutils2.BasicDynaBean;
import org.apache.commons.beanutils2.BasicDynaClass;
import org.apache.commons.beanutils2.BeanIntrospector;
import org.apache.commons.beanutils2.BeanUtils;
import org.apache.commons.beanutils2.BeanWithInnerBean;
import org.apache.commons.beanutils2.BetaBean;
import org.apache.commons.beanutils2.DefaultBeanIntrospector;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.DynaClass;
import org.apache.commons.beanutils2.DynaProperty;
import org.apache.commons.beanutils2.ExtendMapBean;
import org.apache.commons.beanutils2.MappedPropertyDescriptor;
import org.apache.commons.beanutils2.NestedNullException;
import org.apache.commons.beanutils2.NestedTestBean;
import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.beanutils2.PropsFirstPropertyUtilsBean;
import org.apache.commons.beanutils2.SonOfAlphaBean;
import org.apache.commons.beanutils2.TestBean;
import org.apache.commons.beanutils2.TestBeanPackageSubclass;
import org.apache.commons.beanutils2.TestBeanPublicSubclass;
import org.apache.commons.beanutils2.priv.PrivateBeanFactory;
import org.apache.commons.beanutils2.priv.PrivateDirect;
import org.apache.commons.beanutils2.priv.PublicSubBean;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PropertyUtilsTest {
    private static final String PRIVATE_DIRECT_CLASS = "org.apache.commons.beanutils2.priv.PrivateDirect";
    private static final String PRIVATE_INDIRECT_CLASS = "org.apache.commons.beanutils2.priv.PrivateIndirect";
    private static final String TEST_BEAN_CLASS = "org.apache.commons.beanutils2.TestBean";
    protected static final String[] properties = new String[]{"booleanProperty", "booleanSecond", "doubleProperty", "dupProperty", "floatProperty", "intArray", "intIndexed", "intProperty", "listIndexed", "longProperty", "nested", "nullProperty", "readOnlyProperty", "shortProperty", "stringArray", "stringIndexed", "stringProperty", "writeOnlyProperty"};
    protected TestBean bean;
    protected TestBeanPackageSubclass beanPackageSubclass;
    protected PrivateDirect beanPrivate;
    protected PrivateDirect beanPrivateSubclass;
    protected TestBeanPublicSubclass beanPublicSubclass;
    protected String[] describes = new String[]{"booleanProperty", "booleanSecond", "doubleProperty", "floatProperty", "intArray", "intProperty", "listIndexed", "longProperty", "nested", "nullProperty", "shortProperty", "stringArray", "stringProperty"};

    private static PropertyDescriptor findNameDescriptor(PropertyDescriptor[] desc) {
        for (PropertyDescriptor element : desc) {
            if (!element.getName().equals("name")) continue;
            return element;
        }
        return null;
    }

    private String keysToString(Map<String, ?> map) {
        return StringUtils.join(new TreeSet<String>(map.keySet()), (String)", ");
    }

    @BeforeEach
    public void setUp() {
        this.bean = new TestBean();
        this.beanPackageSubclass = new TestBeanPackageSubclass();
        this.beanPrivate = PrivateBeanFactory.create();
        this.beanPrivateSubclass = PrivateBeanFactory.createSubclass();
        this.beanPublicSubclass = new TestBeanPublicSubclass();
        DynaProperty[] properties = new DynaProperty[]{new DynaProperty("stringProperty", String.class), new DynaProperty("nestedBean", TestBean.class), new DynaProperty("nullDynaBean", DynaBean.class)};
        BasicDynaClass dynaClass = new BasicDynaClass("nestedDynaBean", BasicDynaBean.class, properties);
        BasicDynaBean nestedDynaBean = new BasicDynaBean((DynaClass)dynaClass);
        nestedDynaBean.set("nestedBean", (Object)this.bean);
        this.bean.setNestedDynaBean((DynaBean)nestedDynaBean);
        PropertyUtils.clearDescriptors();
    }

    @AfterEach
    public void tearDown() {
        this.bean = null;
        this.beanPackageSubclass = null;
        this.beanPrivate = null;
        this.beanPrivateSubclass = null;
        this.beanPublicSubclass = null;
        PropertyUtils.resetBeanIntrospectors();
    }

    @Test
    public void testAddBeanIntrospectorNull() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.addBeanIntrospector(null));
    }

    @Test
    public void testCopyPropertiesMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("booleanProperty", Boolean.FALSE);
        map.put("doubleProperty", 333.0);
        map.put("dupProperty", new String[]{"New 0", "New 1", "New 2"});
        map.put("floatProperty", Float.valueOf(222.0f));
        map.put("intArray", new int[]{0, 100, 200});
        map.put("intProperty", 111);
        map.put("longProperty", 444L);
        map.put("shortProperty", (short)555);
        map.put("stringProperty", "New String Property");
        PropertyUtils.copyProperties((Object)this.bean, map);
        Assertions.assertEquals((Object)false, (Object)this.bean.getBooleanProperty(), (String)"booleanProperty");
        Assertions.assertEquals((double)333.0, (double)this.bean.getDoubleProperty(), (double)0.005, (String)"doubleProperty");
        Assertions.assertEquals((float)222.0f, (float)this.bean.getFloatProperty(), (float)0.005f, (String)"floatProperty");
        Assertions.assertEquals((int)111, (int)this.bean.getIntProperty(), (String)"intProperty");
        Assertions.assertEquals((long)444L, (long)this.bean.getLongProperty(), (String)"longProperty");
        Assertions.assertEquals((short)555, (short)this.bean.getShortProperty(), (String)"shortProperty");
        Assertions.assertEquals((Object)"New String Property", (Object)this.bean.getStringProperty(), (String)"stringProperty");
        String[] dupProperty = this.bean.getDupProperty();
        Assertions.assertNotNull((Object)dupProperty, (String)"dupProperty present");
        Assertions.assertEquals((int)3, (int)dupProperty.length, (String)"dupProperty length");
        Assertions.assertEquals((Object)"New 0", (Object)dupProperty[0], (String)"dupProperty[0]");
        Assertions.assertEquals((Object)"New 1", (Object)dupProperty[1], (String)"dupProperty[1]");
        Assertions.assertEquals((Object)"New 2", (Object)dupProperty[2], (String)"dupProperty[2]");
        int[] intArray = this.bean.getIntArray();
        Assertions.assertNotNull((Object)intArray, (String)"intArray present");
        Assertions.assertEquals((int)3, (int)intArray.length, (String)"intArray length");
        Assertions.assertEquals((int)0, (int)intArray[0], (String)"intArray[0]");
        Assertions.assertEquals((int)100, (int)intArray[1], (String)"intArray[1]");
        Assertions.assertEquals((int)200, (int)intArray[2], (String)"intArray[2]");
    }

    @Test
    public void testCustomIntrospection() {
        PropertyDescriptor[] desc1 = PropertyUtils.getPropertyDescriptors(AlphaBean.class);
        PropertyDescriptor nameDescriptor = PropertyUtilsTest.findNameDescriptor(desc1);
        Assertions.assertNotNull((Object)nameDescriptor.getWriteMethod(), (String)"No write method");
        BeanIntrospector bi = icontext -> {
            Set names = icontext.propertyNames();
            PropertyDescriptor[] newDescs = new PropertyDescriptor[names.size()];
            int idx = 0;
            for (String propName : names) {
                PropertyDescriptor pd = icontext.getPropertyDescriptor(propName);
                newDescs[idx] = new PropertyDescriptor(pd.getName(), pd.getReadMethod(), null);
                ++idx;
            }
            icontext.addPropertyDescriptors(newDescs);
        };
        PropertyUtils.clearDescriptors();
        PropertyUtils.addBeanIntrospector((BeanIntrospector)bi);
        PropertyDescriptor[] desc2 = PropertyUtils.getPropertyDescriptors(AlphaBean.class);
        Assertions.assertEquals((int)desc1.length, (int)desc2.length, (String)"Different number of properties");
        nameDescriptor = PropertyUtilsTest.findNameDescriptor(desc2);
        Assertions.assertNull((Object)nameDescriptor.getWriteMethod(), (String)"Got a write method");
        PropertyUtils.removeBeanIntrospector((BeanIntrospector)bi);
    }

    @Test
    public void testCustomIntrospectionEx() {
        BeanIntrospector bi = icontext -> {
            throw new IntrospectionException("TestException");
        };
        PropertyUtils.clearDescriptors();
        PropertyUtils.addBeanIntrospector((BeanIntrospector)bi);
        PropertyDescriptor[] desc = PropertyUtils.getPropertyDescriptors(AlphaBean.class);
        Assertions.assertNotNull((Object)PropertyUtilsTest.findNameDescriptor(desc), (String)"Introspection did not work");
        PropertyUtils.removeBeanIntrospector((BeanIntrospector)bi);
    }

    @Test
    public void testDescribe() throws Exception {
        Map map = PropertyUtils.describe((Object)this.bean);
        for (String describe : this.describes) {
            Assertions.assertTrue((boolean)map.containsKey(describe), (String)("Property '" + describe + "' is present"));
        }
        Assertions.assertFalse((boolean)map.containsKey("writeOnlyProperty"), (String)"Property 'writeOnlyProperty' is not present");
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("booleanProperty"), (String)"Value of 'booleanProperty'");
        Assertions.assertEquals((Object)321.0, map.get("doubleProperty"), (String)"Value of 'doubleProperty'");
        Assertions.assertEquals((Object)Float.valueOf(123.0f), map.get("floatProperty"), (String)"Value of 'floatProperty'");
        Assertions.assertEquals((Object)123, map.get("intProperty"), (String)"Value of 'intProperty'");
        Assertions.assertEquals((Object)321L, map.get("longProperty"), (String)"Value of 'longProperty'");
        Assertions.assertEquals((Object)987, map.get("shortProperty"), (String)"Value of 'shortProperty'");
        Assertions.assertEquals((Object)"This is a string", (Object)((String)map.get("stringProperty")), (String)"Value of 'stringProperty'");
    }

    @Test
    public void testExceptionFromInvoke() throws Exception {
        try {
            PropertyUtils.setSimpleProperty((Object)this.bean, (String)"intProperty", (Object)"XXX");
        }
        catch (IllegalArgumentException t) {
            Throwable cause = (Throwable)PropertyUtils.getProperty((Object)t, (String)"cause");
            Assertions.assertNotNull((Object)cause, (String)"Cause not found");
            Assertions.assertInstanceOf(IllegalArgumentException.class, (Object)cause, (String)("Expected cause to be IllegalArgumentException, but was: " + cause.getClass()));
        }
    }

    @Test
    public void testGetDescriptorArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getPropertyDescriptor(null, (String)"stringProperty"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getPropertyDescriptor((Object)this.bean, null));
    }

    private void testGetDescriptorBase(String name, String read, String write) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)this.bean, (String)name);
        if (read == null && write == null) {
            Assertions.assertNull((Object)pd, (String)"Got descriptor");
            return;
        }
        Assertions.assertNotNull((Object)pd, (String)"Got descriptor");
        Method rm = pd.getReadMethod();
        if (read != null) {
            Assertions.assertNotNull((Object)rm, (String)"Got read method");
            Assertions.assertEquals((Object)rm.getName(), (Object)read, (String)"Got correct read method");
        } else {
            Assertions.assertNull((Object)rm, (String)"Got read method");
        }
        Method wm = pd.getWriteMethod();
        if (write != null) {
            Assertions.assertNotNull((Object)wm, (String)"Got write method");
            Assertions.assertEquals((Object)wm.getName(), (Object)write, (String)"Got correct write method");
        } else {
            Assertions.assertNull((Object)wm, (String)"Got write method");
        }
    }

    @Test
    public void testGetDescriptorBoolean() throws Exception {
        this.testGetDescriptorBase("booleanProperty", "getBooleanProperty", "setBooleanProperty");
    }

    @Test
    public void testGetDescriptorDouble() throws Exception {
        this.testGetDescriptorBase("doubleProperty", "getDoubleProperty", "setDoubleProperty");
    }

    @Test
    public void testGetDescriptorFloat() throws Exception {
        this.testGetDescriptorBase("floatProperty", "getFloatProperty", "setFloatProperty");
    }

    @Test
    public void testGetDescriptorInt() throws Exception {
        this.testGetDescriptorBase("intProperty", "getIntProperty", "setIntProperty");
    }

    @Test
    public void testGetDescriptorInvalidBoolean() throws Exception {
        PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)this.bean, (String)"invalidBoolean");
        Assertions.assertNotNull((Object)pd, (String)"invalidBoolean is a property");
        Assertions.assertNotNull((Object)pd.getReadMethod(), (String)"invalidBoolean has a getter method");
        Assertions.assertNull((Object)pd.getWriteMethod(), (String)"invalidBoolean has no write method");
        Assertions.assertTrue((boolean)Arrays.asList("isInvalidBoolean", "getInvalidBoolean").contains(pd.getReadMethod().getName()), (String)"invalidBoolean getter method is isInvalidBoolean or getInvalidBoolean");
    }

    @Test
    public void testGetDescriptorLong() throws Exception {
        this.testGetDescriptorBase("longProperty", "getLongProperty", "setLongProperty");
    }

    @Test
    public void testGetDescriptorMappedPeriods() throws Exception {
        this.bean.getMappedIntProperty("xyz");
        Integer testIntegerValue = 1234;
        this.bean.setMappedIntProperty("key.with.a.dot", testIntegerValue);
        Assertions.assertEquals((Integer)testIntegerValue, (Integer)this.bean.getMappedIntProperty("key.with.a.dot"), (String)"Can retrieve directly");
        PropertyDescriptor desc = PropertyUtils.getPropertyDescriptor((Object)this.bean, (String)"mappedIntProperty(key.with.a.dot)");
        Assertions.assertEquals(Integer.TYPE, (Object)((MappedPropertyDescriptor)desc).getMappedPropertyType(), (String)"Check descriptor type (A)");
        this.bean.setMappedObjects("nested.property", new TestBean((int)testIntegerValue));
        Assertions.assertEquals((Integer)testIntegerValue, (Integer)((TestBean)this.bean.getMappedObjects("nested.property")).getIntProperty(), (String)"Can retrieve directly");
        desc = PropertyUtils.getPropertyDescriptor((Object)this.bean, (String)"mappedObjects(nested.property).intProperty");
        Assertions.assertEquals(Integer.TYPE, desc.getPropertyType(), (String)"Check descriptor type (B)");
    }

    @Test
    public void testGetDescriptorReadOnly() throws Exception {
        this.testGetDescriptorBase("readOnlyProperty", "getReadOnlyProperty", null);
    }

    @Test
    public void testGetDescriptors() {
        PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors((Object)this.bean);
        Assertions.assertNotNull((Object)pd, (String)"Got descriptors");
        int[] count = new int[properties.length];
        for (PropertyDescriptor element : pd) {
            String name = element.getName();
            for (int j = 0; j < properties.length; ++j) {
                if (!name.equals(properties[j])) continue;
                int n = j;
                count[n] = count[n] + 1;
            }
        }
        for (int j = 0; j < properties.length; ++j) {
            Assertions.assertFalse((count[j] < 0 ? 1 : 0) != 0, (String)("Missing property " + properties[j]));
            Assertions.assertFalse((count[j] > 1 ? 1 : 0) != 0, (String)("Missing property " + properties[j]));
        }
    }

    @Test
    public void testGetDescriptorsArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getPropertyDescriptors(null));
    }

    @Test
    public void testGetDescriptorSecond() throws Exception {
        this.testGetDescriptorBase("booleanSecond", "isBooleanSecond", "setBooleanSecond");
    }

    @Test
    public void testGetDescriptorShort() throws Exception {
        this.testGetDescriptorBase("shortProperty", "getShortProperty", "setShortProperty");
    }

    @Test
    public void testGetDescriptorString() throws Exception {
        this.testGetDescriptorBase("stringProperty", "getStringProperty", "setStringProperty");
    }

    @Test
    public void testGetDescriptorUnknown() throws Exception {
        this.testGetDescriptorBase("unknown", null, null);
    }

    @Test
    public void testGetDescriptorWriteOnly() throws Exception {
        this.testGetDescriptorBase("writeOnlyProperty", null, "setWriteOnlyProperty");
    }

    @Test
    public void testGetIndexedArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getIndexedProperty(null, (String)"intArray", (int)0));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, null, (int)0));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getIndexedProperty(null, (String)"intArray[0]"));
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"[0]"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getIndexedProperty(null, (String)"intIndexed", (int)0));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, null, (int)0));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getIndexedProperty(null, (String)"intIndexed[0]"));
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"[0]"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed"));
    }

    @Test
    public void testGetIndexedArray() throws Exception {
        String[] firstArray = new String[]{"FIRST-1", "FIRST-2", "FIRST-3"};
        String[] secondArray = new String[]{"SECOND-1", "SECOND-2", "SECOND-3", "SECOND-4"};
        String[][] mainArray = new String[][]{firstArray, secondArray};
        TestBean bean = new TestBean(mainArray);
        Assertions.assertEquals((Object)firstArray[0], (Object)PropertyUtils.getProperty((Object)bean, (String)"string2dArray[0][0]"), (String)"firstArray[0]");
        Assertions.assertEquals((Object)firstArray[1], (Object)PropertyUtils.getProperty((Object)bean, (String)"string2dArray[0][1]"), (String)"firstArray[1]");
        Assertions.assertEquals((Object)firstArray[2], (Object)PropertyUtils.getProperty((Object)bean, (String)"string2dArray[0][2]"), (String)"firstArray[2]");
        Assertions.assertEquals((Object)secondArray[0], (Object)PropertyUtils.getProperty((Object)bean, (String)"string2dArray[1][0]"), (String)"secondArray[0]");
        Assertions.assertEquals((Object)secondArray[1], (Object)PropertyUtils.getProperty((Object)bean, (String)"string2dArray[1][1]"), (String)"secondArray[1]");
        Assertions.assertEquals((Object)secondArray[2], (Object)PropertyUtils.getProperty((Object)bean, (String)"string2dArray[1][2]"), (String)"secondArray[2]");
        Assertions.assertEquals((Object)secondArray[3], (Object)PropertyUtils.getProperty((Object)bean, (String)"string2dArray[1][3]"), (String)"secondArray[3]");
    }

    @Test
    public void testGetIndexedList() throws Exception {
        String[] firstArray = new String[]{"FIRST-1", "FIRST-2", "FIRST-3"};
        String[] secondArray = new String[]{"SECOND-1", "SECOND-2", "SECOND-3", "SECOND-4"};
        ArrayList<Object> mainList = new ArrayList<Object>();
        mainList.add(Arrays.asList(firstArray));
        mainList.add(Arrays.asList(secondArray));
        TestBean bean = new TestBean(mainList);
        Assertions.assertEquals((Object)firstArray[0], (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[0][0]"), (String)"firstArray[0]");
        Assertions.assertEquals((Object)firstArray[1], (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[0][1]"), (String)"firstArray[1]");
        Assertions.assertEquals((Object)firstArray[2], (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[0][2]"), (String)"firstArray[2]");
        Assertions.assertEquals((Object)secondArray[0], (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[1][0]"), (String)"secondArray[0]");
        Assertions.assertEquals((Object)secondArray[1], (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[1][1]"), (String)"secondArray[1]");
        Assertions.assertEquals((Object)secondArray[2], (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[1][2]"), (String)"secondArray[2]");
        Assertions.assertEquals((Object)secondArray[3], (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[1][3]"), (String)"secondArray[3]");
    }

    @Test
    public void testGetIndexedMap() throws Exception {
        HashMap<String, String> firstMap = new HashMap<String, String>();
        firstMap.put("FIRST-KEY-1", "FIRST-VALUE-1");
        firstMap.put("FIRST-KEY-2", "FIRST-VALUE-2");
        HashMap<String, String> secondMap = new HashMap<String, String>();
        secondMap.put("SECOND-KEY-1", "SECOND-VALUE-1");
        secondMap.put("SECOND-KEY-2", "SECOND-VALUE-2");
        ArrayList<Object> mainList = new ArrayList<Object>();
        mainList.add(firstMap);
        mainList.add(secondMap);
        TestBean bean = new TestBean(mainList);
        Assertions.assertEquals((Object)"FIRST-VALUE-1", (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[0](FIRST-KEY-1)"), (String)"listIndexed[0](FIRST-KEY-1)");
        Assertions.assertEquals((Object)"FIRST-VALUE-2", (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[0](FIRST-KEY-2)"), (String)"listIndexed[0](FIRST-KEY-2)");
        Assertions.assertEquals((Object)"SECOND-VALUE-1", (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[1](SECOND-KEY-1)"), (String)"listIndexed[1](SECOND-KEY-1)");
        Assertions.assertEquals((Object)"SECOND-VALUE-2", (Object)PropertyUtils.getProperty((Object)bean, (String)"listIndexed[1](SECOND-KEY-2)"), (String)"listIndexed[1](SECOND-KEY-2)");
    }

    @Test
    public void testGetIndexedValues() throws Exception {
        int i;
        Object value = null;
        for (i = 0; i < 5; ++i) {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"dupProperty", (int)i);
            Assertions.assertNotNull((Object)value, (String)("dupProperty returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("dupProperty returned String " + i));
            Assertions.assertEquals((Object)("Dup " + i), (Object)((String)value), (String)("dupProperty returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)i);
            Assertions.assertNotNull((Object)value, (String)("intArray returned value " + i));
            Assertions.assertInstanceOf(Integer.class, (Object)value, (String)("intArray returned Integer " + i));
            Assertions.assertEquals((int)(i * 10), (int)((Integer)value), (String)("intArray returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)i);
            Assertions.assertNotNull((Object)value, (String)("intIndexed returned value " + i));
            Assertions.assertInstanceOf(Integer.class, (Object)value, (String)("intIndexed returned Integer " + i));
            Assertions.assertEquals((int)(i * 10), (int)((Integer)value), (String)("intIndexed returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)i);
            Assertions.assertNotNull((Object)value, (String)("listIndexed returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("list returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("listIndexed returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)i);
            Assertions.assertNotNull((Object)value, (String)("stringArray returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("stringArray returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("stringArray returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)i);
            Assertions.assertNotNull((Object)value, (String)("stringIndexed returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("stringIndexed returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("stringIndexed returned correct " + i));
        }
        for (i = 0; i < 5; ++i) {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("dupProperty[" + i + "]"));
            Assertions.assertNotNull((Object)value, (String)("dupProperty returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("dupProperty returned String " + i));
            Assertions.assertEquals((Object)("Dup " + i), (Object)((String)value), (String)("dupProperty returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("intArray[" + i + "]"));
            Assertions.assertNotNull((Object)value, (String)("intArray returned value " + i));
            Assertions.assertInstanceOf(Integer.class, (Object)value, (String)("intArray returned Integer " + i));
            Assertions.assertEquals((int)(i * 10), (int)((Integer)value), (String)("intArray returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("intIndexed[" + i + "]"));
            Assertions.assertNotNull((Object)value, (String)("intIndexed returned value " + i));
            Assertions.assertInstanceOf(Integer.class, (Object)value, (String)("intIndexed returned Integer " + i));
            Assertions.assertEquals((int)(i * 10), (int)((Integer)value), (String)("intIndexed returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("listIndexed[" + i + "]"));
            Assertions.assertNotNull((Object)value, (String)("listIndexed returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("listIndexed returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("listIndexed returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("stringArray[" + i + "]"));
            Assertions.assertNotNull((Object)value, (String)("stringArray returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("stringArray returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("stringArray returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("stringIndexed[" + i + "]"));
            Assertions.assertNotNull((Object)value, (String)("stringIndexed returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("stringIndexed returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("stringIndexed returned correct " + i));
        }
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"dupProperty", (int)-1));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"dupProperty", (int)5));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)-1));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)5));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)-1));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)5));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)5));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)-1));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)5));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)-1));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)5));
    }

    @Test
    public void testGetMappedArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getMappedProperty(null, (String)"mappedProperty", (String)"First Key"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getMappedProperty((Object)this.bean, null, (String)"First Key"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", null));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getMappedProperty(null, (String)"mappedProperty(First Key)"));
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getMappedProperty((Object)this.bean, (String)"(Second Key)"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty"));
    }

    @Test
    public void testGetMappedArray() throws Exception {
        TestBean bean = new TestBean();
        String[] array = new String[]{"abc", "def", "ghi"};
        bean.getMapProperty().put("mappedArray", array);
        Assertions.assertEquals((Object)"abc", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedArray)[0]"));
        Assertions.assertEquals((Object)"def", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedArray)[1]"));
        Assertions.assertEquals((Object)"ghi", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedArray)[2]"));
    }

    @Test
    public void testGetMappedList() throws Exception {
        TestBean bean = new TestBean();
        ArrayList<String> list = new ArrayList<String>();
        list.add("klm");
        list.add("nop");
        list.add("qrs");
        bean.getMapProperty().put("mappedList", list);
        Assertions.assertEquals((Object)"klm", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedList)[0]"));
        Assertions.assertEquals((Object)"nop", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedList)[1]"));
        Assertions.assertEquals((Object)"qrs", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedList)[2]"));
    }

    @Test
    public void testGetMappedMap() throws Exception {
        TestBean bean = new TestBean();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sub-key-1", "sub-value-1");
        map.put("sub-key-2", "sub-value-2");
        map.put("sub-key-3", "sub-value-3");
        bean.getMapProperty().put("mappedMap", map);
        Assertions.assertEquals((Object)"sub-value-1", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedMap)(sub-key-1)"));
        Assertions.assertEquals((Object)"sub-value-2", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedMap)(sub-key-2)"));
        Assertions.assertEquals((Object)"sub-value-3", (Object)PropertyUtils.getProperty((Object)bean, (String)"mapProperty(mappedMap)(sub-key-3)"));
    }

    @Test
    public void testGetMappedPeriods() throws Exception {
        this.bean.setMappedProperty("key.with.a.dot", "Special Value");
        Assertions.assertEquals((Object)"Special Value", (Object)this.bean.getMappedProperty("key.with.a.dot"), (String)"Can retrieve directly");
        Assertions.assertEquals((Object)"Special Value", (Object)PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"key.with.a.dot"), (String)"Can retrieve via getMappedProperty");
        Assertions.assertEquals((Object)"Special Value", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedProperty(key.with.a.dot)"), (String)"Can retrieve via getNestedProperty");
        this.bean.setMappedObjects("nested.property", new TestBean());
        Assertions.assertNotNull((Object)this.bean.getMappedObjects("nested.property"), (String)"Can retrieve directly");
        Assertions.assertEquals((Object)"This is a string", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedObjects(nested.property).stringProperty"), (String)"Can retrieve nested");
        Assertions.assertEquals((Object)"Mapped Value", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedNested.value(Mapped Key)"), (String)"Can't retrieved nested with mapped property");
    }

    @Test
    public void testGetMappedSlashes() throws Exception {
        this.bean.setMappedProperty("key/with/a/slash", "Special Value");
        Assertions.assertEquals((Object)"Special Value", (Object)this.bean.getMappedProperty("key/with/a/slash"), (String)"Can retrieve directly");
        Assertions.assertEquals((Object)"Special Value", (Object)PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"key/with/a/slash"), (String)"Can retrieve via getMappedProperty");
        Assertions.assertEquals((Object)"Special Value", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedProperty(key/with/a/slash)"), (String)"Can retrieve via getNestedProperty");
        this.bean.setMappedObjects("nested/property", new TestBean());
        Assertions.assertNotNull((Object)this.bean.getMappedObjects("nested/property"), (String)"Can retrieve directly");
        Assertions.assertEquals((Object)"This is a string", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedObjects(nested/property).stringProperty"), (String)"Can retrieve nested");
    }

    @Test
    public void testGetMappedValues() throws Exception {
        Object value = null;
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"First Key");
        Assertions.assertEquals((Object)"First Value", (Object)value, (String)"Can find first value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Second Key");
        Assertions.assertEquals((Object)"Second Value", (Object)value, (String)"Can find second value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Third Key");
        Assertions.assertNull((Object)value, (String)"Can not find third value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(First Key)");
        Assertions.assertEquals((Object)"First Value", (Object)value, (String)"Can find first value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Second Key)");
        Assertions.assertEquals((Object)"Second Value", (Object)value, (String)"Can find second value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Third Key)");
        Assertions.assertNull((Object)value, (String)"Can not find third value");
        value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.First Key");
        Assertions.assertEquals((Object)"First Value", (Object)value, (String)"Can find first value");
        value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Second Key");
        Assertions.assertEquals((Object)"Second Value", (Object)value, (String)"Can find second value");
        value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Third Key");
        Assertions.assertNull((Object)value, (String)"Can not find third value");
    }

    @Test
    public void testGetNestedArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getNestedProperty(null, (String)"stringProperty"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getNestedProperty((Object)this.bean, null));
    }

    @Test
    public void testGetNestedBoolean() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.booleanProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Boolean.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((Object)((Boolean)value), (Object)this.bean.getNested().getBooleanProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetNestedDouble() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.doubleProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Double.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((double)((Double)value), (double)this.bean.getNested().getDoubleProperty(), (double)0.005, (String)"Got correct value");
    }

    @Test
    public void testGetNestedFloat() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.floatProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Float.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((float)((Float)value).floatValue(), (float)this.bean.getNested().getFloatProperty(), (float)0.005f, (String)"Got correct value");
    }

    @Test
    public void testGetNestedInt() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.intProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((int)((Integer)value), (int)this.bean.getNested().getIntProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetNestedLong() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.longProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Long.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((long)((Long)value), (long)this.bean.getNested().getLongProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetNestedReadOnly() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.readOnlyProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((Object)((String)value), (Object)this.bean.getReadOnlyProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetNestedShort() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.shortProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Short.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((short)((Short)value), (short)this.bean.getNested().getShortProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetNestedString() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.stringProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((Object)((String)value), (Object)this.bean.getNested().getStringProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetNestedUnknown() throws Exception {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.unknown"));
    }

    @Test
    public void testGetNestedWriteOnly() throws Exception {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getNestedProperty((Object)this.bean, (String)"writeOnlyProperty"));
    }

    @Test
    public void testGetPropertyType() throws Exception {
        Class clazz = null;
        int[] intArray = new int[]{};
        String[] stringArray = new String[]{};
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"booleanProperty");
        Assertions.assertEquals(Boolean.TYPE, (Object)clazz, (String)"booleanProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"booleanSecond");
        Assertions.assertEquals(Boolean.TYPE, (Object)clazz, (String)"booleanSecond type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"doubleProperty");
        Assertions.assertEquals(Double.TYPE, (Object)clazz, (String)"doubleProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"dupProperty");
        Assertions.assertEquals(String.class, (Object)clazz, (String)"dupProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"floatProperty");
        Assertions.assertEquals(Float.TYPE, (Object)clazz, (String)"floatProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"intArray");
        Assertions.assertEquals(intArray.getClass(), (Object)clazz, (String)"intArray type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"intIndexed");
        Assertions.assertEquals(Integer.TYPE, (Object)clazz, (String)"intIndexed type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"intProperty");
        Assertions.assertEquals(Integer.TYPE, (Object)clazz, (String)"intProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"listIndexed");
        Assertions.assertEquals(List.class, (Object)clazz, (String)"listIndexed type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"longProperty");
        Assertions.assertEquals(Long.TYPE, (Object)clazz, (String)"longProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"mappedProperty");
        Assertions.assertEquals(String.class, (Object)clazz, (String)"mappedProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"mappedIntProperty");
        Assertions.assertEquals(Integer.TYPE, (Object)clazz, (String)"mappedIntProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"readOnlyProperty");
        Assertions.assertEquals(String.class, (Object)clazz, (String)"readOnlyProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"shortProperty");
        Assertions.assertEquals(Short.TYPE, (Object)clazz, (String)"shortProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"stringArray");
        Assertions.assertEquals(stringArray.getClass(), (Object)clazz, (String)"stringArray type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"stringIndexed");
        Assertions.assertEquals(String.class, (Object)clazz, (String)"stringIndexed type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"stringProperty");
        Assertions.assertEquals(String.class, (Object)clazz, (String)"stringProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"writeOnlyProperty");
        Assertions.assertEquals(String.class, (Object)clazz, (String)"writeOnlyProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.booleanProperty");
        Assertions.assertEquals(Boolean.TYPE, (Object)clazz, (String)"booleanProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.booleanSecond");
        Assertions.assertEquals(Boolean.TYPE, (Object)clazz, (String)"booleanSecond type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.doubleProperty");
        Assertions.assertEquals(Double.TYPE, (Object)clazz, (String)"doubleProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.dupProperty");
        Assertions.assertEquals(String.class, (Object)clazz, (String)"dupProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.floatProperty");
        Assertions.assertEquals(Float.TYPE, (Object)clazz, (String)"floatProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.intArray");
        Assertions.assertEquals(intArray.getClass(), (Object)clazz, (String)"intArray type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.intIndexed");
        Assertions.assertEquals(Integer.TYPE, (Object)clazz, (String)"intIndexed type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.intProperty");
        Assertions.assertEquals(Integer.TYPE, (Object)clazz, (String)"intProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.listIndexed");
        Assertions.assertEquals(List.class, (Object)clazz, (String)"listIndexed type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.longProperty");
        Assertions.assertEquals(Long.TYPE, (Object)clazz, (String)"longProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.mappedProperty");
        Assertions.assertEquals(String.class, (Object)clazz, (String)"mappedProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.mappedIntProperty");
        Assertions.assertEquals(Integer.TYPE, (Object)clazz, (String)"mappedIntProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.readOnlyProperty");
        Assertions.assertEquals(String.class, (Object)clazz, (String)"readOnlyProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.shortProperty");
        Assertions.assertEquals(Short.TYPE, (Object)clazz, (String)"shortProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.stringArray");
        Assertions.assertEquals(stringArray.getClass(), (Object)clazz, (String)"stringArray type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.stringIndexed");
        Assertions.assertEquals(String.class, (Object)clazz, (String)"stringIndexed type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.stringProperty");
        Assertions.assertEquals(String.class, (Object)clazz, (String)"stringProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nested.writeOnlyProperty");
        Assertions.assertEquals(String.class, (Object)clazz, (String)"writeOnlyProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nestedDynaBean");
        Assertions.assertEquals(DynaBean.class, (Object)clazz, (String)"nestedDynaBean type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nestedDynaBean.stringProperty");
        Assertions.assertEquals(String.class, (Object)clazz, (String)"nestedDynaBean.stringProperty type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nestedDynaBean.nestedBean");
        Assertions.assertEquals(TestBean.class, (Object)clazz, (String)"nestedDynaBean.nestedBean type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nestedDynaBean.nestedBean.nestedDynaBean");
        Assertions.assertEquals(DynaBean.class, (Object)clazz, (String)"nestedDynaBean.nestedBean.nestedDynaBean type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nestedDynaBean.nestedBean.nestedDynaBean.stringProperty");
        Assertions.assertEquals(String.class, (Object)clazz, (String)"nestedDynaBean.nestedBean.nestedDynaBean.stringPropert type");
        clazz = PropertyUtils.getPropertyType((Object)this.bean, (String)"nestedDynaBean.nullDynaBean");
        Assertions.assertEquals(DynaBean.class, (Object)clazz, (String)"nestedDynaBean.nullDynaBean type");
        Assertions.assertThrows(NestedNullException.class, () -> PropertyUtils.getPropertyType((Object)this.bean, (String)"nestedDynaBean.nullDynaBean.foo"));
    }

    @Test
    public void testGetPublicSubBean_of_PackageBean() throws Exception {
        PublicSubBean bean = new PublicSubBean();
        bean.setFoo("foo-start");
        bean.setBar("bar-start");
        Object result = null;
        result = PropertyUtils.getProperty((Object)bean, (String)"foo");
        Assertions.assertEquals((Object)"foo-start", (Object)result, (String)"foo property");
        result = PropertyUtils.getProperty((Object)bean, (String)"bar");
        Assertions.assertEquals((Object)"bar-start", (Object)result, (String)"bar property");
    }

    private void testGetReadMethod(Object bean, String[] properties, String className) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors((Object)bean);
        String[] stringArray = properties;
        int n = stringArray.length;
        block10: for (int i = 0; i < n; ++i) {
            String propertie;
            switch (propertie = stringArray[i]) {
                case "intIndexed": {
                    continue block10;
                }
                case "stringIndexed": {
                    continue block10;
                }
                case "writeOnlyProperty": {
                    continue block10;
                }
                default: {
                    int n2 = -1;
                    for (int j = 0; j < pd.length; ++j) {
                        if (!propertie.equals(pd[j].getName())) continue;
                        n2 = j;
                        break;
                    }
                    Assertions.assertTrue((n2 >= 0 ? 1 : 0) != 0, (String)("PropertyDescriptor for " + propertie));
                    Method reader = PropertyUtils.getReadMethod((PropertyDescriptor)pd[n2]);
                    Assertions.assertNotNull((Object)reader, (String)("Reader for " + propertie));
                    Class<?> clazz = reader.getDeclaringClass();
                    Assertions.assertNotNull(clazz, (String)("Declaring class for " + propertie));
                    Assertions.assertEquals((Object)clazz.getName(), (Object)className, (String)("Correct declaring class for " + propertie));
                    reader.invoke(bean, (Object[])new Class[0]);
                }
            }
        }
    }

    @Test
    public void testGetReadMethodBasic() throws Exception {
        this.testGetReadMethod(this.bean, properties, TEST_BEAN_CLASS);
    }

    @Test
    public void testGetReadMethodPackageSubclass() throws Exception {
        this.testGetReadMethod(this.beanPackageSubclass, properties, TEST_BEAN_CLASS);
    }

    @Test
    public void testGetReadMethodPublicInterface() throws Exception {
        this.testGetReadMethod(this.beanPrivate, new String[]{"bar"}, PRIVATE_DIRECT_CLASS);
        this.testGetReadMethod(this.beanPrivate, new String[]{"baz"}, PRIVATE_INDIRECT_CLASS);
        this.testGetReadMethod(this.beanPrivateSubclass, new String[]{"bar"}, PRIVATE_DIRECT_CLASS);
        this.testGetReadMethod(this.beanPrivateSubclass, new String[]{"baz"}, PRIVATE_INDIRECT_CLASS);
        PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors((Object)this.beanPrivate);
        int n = -1;
        for (int i = 0; i < pd.length; ++i) {
            if (!"foo".equals(pd[i].getName())) continue;
            n = i;
            break;
        }
        Assertions.assertTrue((n >= 0 ? 1 : 0) != 0, (String)"Found foo descriptor");
        Method reader = pd[n].getReadMethod();
        Assertions.assertNotNull((Object)reader, (String)"Found foo read method");
        Assertions.assertThrows(IllegalAccessException.class, () -> reader.invoke((Object)this.beanPrivate, (Object[])new Class[0]));
    }

    @Test
    public void testGetReadMethodPublicSubclass() throws Exception {
        this.testGetReadMethod(this.beanPublicSubclass, properties, TEST_BEAN_CLASS);
    }

    @Test
    public void testGetSetInnerBean() throws Exception {
        BeanWithInnerBean bean = new BeanWithInnerBean();
        PropertyUtils.setProperty((Object)bean, (String)"innerBean.fish(loiterTimer)", (Object)"5");
        String out = (String)PropertyUtils.getProperty((Object)bean.getInnerBean(), (String)"fish(loiterTimer)");
        Assertions.assertEquals((Object)"5", (Object)out, (String)"(1) Inner class property set/get property failed.");
        out = (String)PropertyUtils.getProperty((Object)bean, (String)"innerBean.fish(loiterTimer)");
        Assertions.assertEquals((Object)"5", (Object)out, (String)"(2) Inner class property set/get property failed.");
    }

    @Test
    public void testGetSetParentBean() throws Exception {
        SonOfAlphaBean bean = new SonOfAlphaBean("Roger");
        String out = (String)PropertyUtils.getProperty((Object)bean, (String)"name");
        Assertions.assertEquals((Object)"Roger", (Object)out, (String)"(1) Get/Set On Parent.");
        PropertyUtils.setProperty((Object)bean, (String)"name", (Object)"abcd");
        Assertions.assertEquals((Object)"abcd", (Object)bean.getName(), (String)"(2) Get/Set On Parent.");
    }

    @Test
    public void testGetSimpleArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getSimpleProperty(null, (String)"stringProperty"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getSimpleProperty((Object)this.bean, null));
    }

    @Test
    public void testGetSimpleBoolean() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"booleanProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Boolean.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((Object)((Boolean)value), (Object)this.bean.getBooleanProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetSimpleDouble() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"doubleProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Double.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((double)((Double)value), (double)this.bean.getDoubleProperty(), (double)0.005, (String)"Got correct value");
    }

    @Test
    public void testGetSimpleFloat() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"floatProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Float.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((float)((Float)value).floatValue(), (float)this.bean.getFloatProperty(), (float)0.005f, (String)"Got correct value");
    }

    @Test
    public void testGetSimpleIndexed() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.getSimpleProperty((Object)this.bean, (String)"intIndexed[0]"));
    }

    @Test
    public void testGetSimpleInt() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"intProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((int)((Integer)value), (int)this.bean.getIntProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetSimpleLong() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"longProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Long.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((long)((Long)value), (long)this.bean.getLongProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetSimpleNested() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.getSimpleProperty((Object)this.bean, (String)"nested.stringProperty"));
    }

    @Test
    public void testGetSimpleReadOnly() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"readOnlyProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((Object)((String)value), (Object)this.bean.getReadOnlyProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetSimpleShort() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"shortProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Short.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((short)((Short)value), (short)this.bean.getShortProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetSimpleString() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((Object)((String)value), (Object)this.bean.getStringProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetSimpleUnknown() throws Exception {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getSimpleProperty((Object)this.bean, (String)"unknown"));
    }

    @Test
    public void testGetSimpleWriteOnly() throws Exception {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getSimpleProperty((Object)this.bean, (String)"writeOnlyProperty"));
    }

    private void testGetWriteMethod(Object bean, String[] properties, String className) {
        PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors((Object)bean);
        String[] stringArray = properties;
        int n = stringArray.length;
        block14: for (int i = 0; i < n; ++i) {
            String property;
            switch (property = stringArray[i]) {
                case "intIndexed": {
                    continue block14;
                }
                case "listIndexed": {
                    continue block14;
                }
                case "nested": {
                    continue block14;
                }
                case "readOnlyProperty": {
                    continue block14;
                }
                case "stringIndexed": {
                    continue block14;
                }
                default: {
                    int n2 = -1;
                    for (int j = 0; j < pd.length; ++j) {
                        if (!property.equals(pd[j].getName())) continue;
                        n2 = j;
                        break;
                    }
                    Assertions.assertTrue((n2 >= 0 ? 1 : 0) != 0, (String)("PropertyDescriptor for " + property));
                    Method writer = PropertyUtils.getWriteMethod((PropertyDescriptor)pd[n2]);
                    Assertions.assertNotNull((Object)writer, (String)("Writer for " + property));
                    Class<?> clazz = writer.getDeclaringClass();
                    Assertions.assertNotNull(clazz, (String)("Declaring class for " + property));
                    Assertions.assertEquals((Object)clazz.getName(), (Object)className, (String)("Correct declaring class for " + property));
                }
            }
        }
    }

    @Test
    public void testGetWriteMethodBasic() {
        this.testGetWriteMethod(this.bean, properties, TEST_BEAN_CLASS);
    }

    @Test
    public void testGetWriteMethodPackageSubclass() {
        this.testGetWriteMethod(this.beanPackageSubclass, properties, TEST_BEAN_CLASS);
    }

    @Test
    public void testGetWriteMethodPublicSubclass() {
        this.testGetWriteMethod(this.beanPublicSubclass, properties, TEST_BEAN_CLASS);
    }

    @Test
    public void testIsReadable() throws Exception {
        String property = null;
        property = "stringProperty";
        Assertions.assertTrue((boolean)PropertyUtils.isReadable((Object)this.bean, (String)property), (String)("Property " + property + " isReadable expected TRUE"));
        property = "stringIndexed";
        Assertions.assertTrue((boolean)PropertyUtils.isReadable((Object)this.bean, (String)property), (String)("Property " + property + " isReadable expected TRUE"));
        property = "mappedProperty";
        Assertions.assertTrue((boolean)PropertyUtils.isReadable((Object)this.bean, (String)property), (String)("Property " + property + " isReadable expected TRUE"));
        property = "nestedDynaBean";
        Assertions.assertTrue((boolean)PropertyUtils.isReadable((Object)this.bean, (String)property), (String)("Property " + property + " isReadable expected TRUE"));
        property = "nestedDynaBean.stringProperty";
        Assertions.assertTrue((boolean)PropertyUtils.isReadable((Object)this.bean, (String)property), (String)("Property " + property + " isReadable expected TRUE"));
        property = "nestedDynaBean.nestedBean";
        Assertions.assertTrue((boolean)PropertyUtils.isReadable((Object)this.bean, (String)property), (String)("Property " + property + " isReadable expected TRUE"));
        property = "nestedDynaBean.nestedBean.nestedDynaBean";
        Assertions.assertTrue((boolean)PropertyUtils.isReadable((Object)this.bean, (String)property), (String)("Property " + property + " isReadable expected TRUE"));
        property = "nestedDynaBean.nestedBean.nestedDynaBean.stringProperty";
        Assertions.assertTrue((boolean)PropertyUtils.isReadable((Object)this.bean, (String)property), (String)("Property " + property + " isReadable expected TRUE"));
        property = "nestedDynaBean.nullDynaBean";
        Assertions.assertTrue((boolean)PropertyUtils.isReadable((Object)this.bean, (String)property), (String)("Property " + property + " isReadable expected TRUE"));
        Assertions.assertThrows(NestedNullException.class, () -> PropertyUtils.isReadable((Object)this.bean, (String)"nestedDynaBean.nullDynaBean.foo"));
    }

    @Test
    public void testIsWriteable() throws Exception {
        String property = null;
        property = "stringProperty";
        Assertions.assertTrue((boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property), (String)("Property " + property + " isWriteable expected TRUE"));
        property = "stringIndexed";
        Assertions.assertTrue((boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property), (String)("Property " + property + " isWriteable expected TRUE"));
        property = "mappedProperty";
        Assertions.assertTrue((boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property), (String)("Property " + property + " isWriteable expected TRUE"));
        property = "nestedDynaBean";
        Assertions.assertTrue((boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property), (String)("Property " + property + " isWriteable expected TRUE"));
        property = "nestedDynaBean.stringProperty";
        Assertions.assertTrue((boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property), (String)("Property " + property + " isWriteable expected TRUE"));
        property = "nestedDynaBean.nestedBean";
        Assertions.assertTrue((boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property), (String)("Property " + property + " isWriteable expected TRUE"));
        property = "nestedDynaBean.nestedBean.nestedDynaBean";
        Assertions.assertTrue((boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property), (String)("Property " + property + " isWriteable expected TRUE"));
        property = "nestedDynaBean.nestedBean.nestedDynaBean.stringProperty";
        Assertions.assertTrue((boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property), (String)("Property " + property + " isWriteable expected TRUE"));
        property = "nestedDynaBean.nullDynaBean";
        Assertions.assertTrue((boolean)PropertyUtils.isWriteable((Object)this.bean, (String)property), (String)("Property " + property + " isWriteable expected TRUE"));
        Assertions.assertThrows(NestedNullException.class, () -> PropertyUtils.isWriteable((Object)this.bean, (String)"nestedDynaBean.nullDynaBean.foo"));
    }

    @Test
    public void testMapExtensionCustom() throws Exception {
        PropsFirstPropertyUtilsBean utilsBean = new PropsFirstPropertyUtilsBean();
        ExtendMapBean bean = new ExtendMapBean();
        bean.setUnusuallyNamedProperty("bean value");
        Assertions.assertEquals((Object)"bean value", (Object)bean.getUnusuallyNamedProperty(), (String)"Set property direct failed");
        utilsBean.setSimpleProperty(bean, "unusuallyNamedProperty", "new value");
        Assertions.assertEquals((Object)"new value", (Object)bean.getUnusuallyNamedProperty(), (String)"Set property on map failed (1)");
        utilsBean.setProperty(bean, "unusuallyNamedProperty", "next value");
        Assertions.assertEquals((Object)"next value", (Object)bean.getUnusuallyNamedProperty(), (String)"Set property on map failed (2)");
        Assertions.assertEquals((Object)"next value", (Object)utilsBean.getNestedProperty(bean, "unusuallyNamedProperty"), (String)"setNestedProperty on non-simple property failed");
        utilsBean.setProperty(bean, "mapProperty", "value1");
        Assertions.assertEquals((Object)"value1", (Object)utilsBean.getNestedProperty(bean, "mapProperty"), (String)"setNestedProperty on non-simple property failed");
        HashMap<String, ExtendMapBean> myMap = new HashMap<String, ExtendMapBean>();
        myMap.put("thebean", bean);
        utilsBean.getNestedProperty(myMap, "thebean.mapitem");
        utilsBean.getNestedProperty(myMap, "thebean(mapitem)");
    }

    @Test
    public void testMapExtensionDefault() throws Exception {
        ExtendMapBean bean = new ExtendMapBean();
        bean.setUnusuallyNamedProperty("bean value");
        Assertions.assertEquals((Object)"bean value", (Object)bean.getUnusuallyNamedProperty(), (String)"Set property direct failed");
        Assertions.assertNull((Object)PropertyUtils.getNestedProperty((Object)bean, (String)"unusuallyNamedProperty"), (String)"Get on unset map property failed");
        PropertyUtils.setSimpleProperty((Object)bean, (String)"unusuallyNamedProperty", (Object)"new value");
        Assertions.assertEquals((Object)"new value", (Object)bean.getUnusuallyNamedProperty(), (String)"Set property on map failed (1)");
        Assertions.assertNull((Object)PropertyUtils.getNestedProperty((Object)bean, (String)"unusuallyNamedProperty"), (String)"Get on unset map property failed");
        PropertyUtils.setProperty((Object)bean, (String)"unusuallyNamedProperty", (Object)"next value");
        Assertions.assertEquals((Object)"next value", (Object)PropertyUtils.getNestedProperty((Object)bean, (String)"unusuallyNamedProperty"), (String)"setNestedProperty on map not visible to getNestedProperty");
        Assertions.assertEquals((Object)"new value", (Object)bean.getUnusuallyNamedProperty(), (String)"Set nested property on map unexpected affected simple property");
    }

    @Test
    public void testMappedPropertyType() throws Exception {
        MappedPropertyDescriptor desc = (MappedPropertyDescriptor)PropertyUtils.getPropertyDescriptor((Object)this.bean, (String)"mappedProperty");
        Assertions.assertEquals(String.class, (Object)desc.getMappedPropertyType());
        desc = (MappedPropertyDescriptor)PropertyUtils.getPropertyDescriptor((Object)this.bean, (String)"mappedIntProperty");
        Assertions.assertEquals(Integer.TYPE, (Object)desc.getMappedPropertyType());
    }

    @Test
    public void testNestedPropertyKeyOrIndexOnBeanImplementingMap() throws Exception {
        HashMap map = new HashMap();
        HashMap submap = new HashMap();
        BetaBean betaBean1 = new BetaBean("test1");
        BetaBean betaBean2 = new BetaBean("test2");
        PropertyUtils.setNestedProperty(map, (String)"submap", submap);
        PropertyUtils.setNestedProperty(map, (String)"submap.beta1", (Object)betaBean1);
        Assertions.assertEquals((Object)"submap", (Object)this.keysToString(map), (String)"Unexpected keys in map");
        Assertions.assertEquals((Object)"beta1", (Object)this.keysToString(submap), (String)"Unexpected keys in submap");
        IllegalArgumentException e1 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.setNestedProperty((Object)map, (String)"submap(beta2)", (Object)betaBean2));
        Assertions.assertTrue((boolean)e1.getMessage().contains("Indexed or mapped properties are not supported"), (String)"Unexpected exception message");
        IllegalArgumentException e2 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.getNestedProperty((Object)map, (String)"submap[3]"));
        int index = e2.getMessage().indexOf("Indexed or mapped properties are not supported");
        Assertions.assertTrue((index >= 0 ? 1 : 0) != 0, (String)"Unexpected exception message");
    }

    @Test
    public void testNestedWithIndex() throws Exception {
        NestedTestBean nestedBean = new NestedTestBean("base");
        nestedBean.init();
        nestedBean.getSimpleBeanProperty().init();
        NestedTestBean value = (NestedTestBean)PropertyUtils.getProperty((Object)nestedBean, (String)"indexedProperty[0]");
        Assertions.assertEquals((Object)"Bean@0", (Object)value.getName(), (String)"Cannot get simple index(1)");
        Assertions.assertEquals((Object)"NOT SET", (Object)value.getTestString(), (String)"Bug in NestedTestBean");
        value = (NestedTestBean)PropertyUtils.getProperty((Object)nestedBean, (String)"indexedProperty[1]");
        Assertions.assertEquals((Object)"Bean@1", (Object)value.getName(), (String)"Cannot get simple index(1)");
        Assertions.assertEquals((Object)"NOT SET", (Object)value.getTestString(), (String)"Bug in NestedTestBean");
        String prop = (String)PropertyUtils.getProperty((Object)nestedBean, (String)"indexedProperty[0].testString");
        Assertions.assertEquals((Object)"NOT SET", (Object)prop, (String)"Get property on indexes failed (1)");
        prop = (String)PropertyUtils.getProperty((Object)nestedBean, (String)"indexedProperty[1].testString");
        Assertions.assertEquals((Object)"NOT SET", (Object)prop, (String)"Get property on indexes failed (2)");
        PropertyUtils.setProperty((Object)nestedBean, (String)"indexedProperty[0].testString", (Object)"Test#1");
        Assertions.assertEquals((Object)"Test#1", (Object)nestedBean.getIndexedProperty(0).getTestString(), (String)"Cannot set property on indexed bean (1)");
        PropertyUtils.setProperty((Object)nestedBean, (String)"indexedProperty[1].testString", (Object)"Test#2");
        Assertions.assertEquals((Object)"Test#2", (Object)nestedBean.getIndexedProperty(1).getTestString(), (String)"Cannot set property on indexed bean (2)");
        value = (NestedTestBean)PropertyUtils.getProperty((Object)nestedBean, (String)"simpleBeanProperty");
        Assertions.assertEquals((Object)"Simple Property Bean", (Object)value.getName(), (String)"Cannot get simple bean");
        Assertions.assertEquals((Object)"NOT SET", (Object)value.getTestString(), (String)"Bug in NestedTestBean");
        value = (NestedTestBean)PropertyUtils.getProperty((Object)nestedBean, (String)"simpleBeanProperty.indexedProperty[3]");
        Assertions.assertEquals((Object)"Bean@3", (Object)value.getName(), (String)"Cannot get index property on property");
        Assertions.assertEquals((Object)"NOT SET", (Object)value.getTestString(), (String)"Bug in NestedTestBean");
        PropertyUtils.setProperty((Object)nestedBean, (String)"simpleBeanProperty.indexedProperty[3].testString", (Object)"Test#3");
        Assertions.assertEquals((Object)"Test#3", (Object)nestedBean.getSimpleBeanProperty().getIndexedProperty(3).getTestString(), (String)"Cannot set property on indexed property on property");
    }

    @Test
    public void testRemoveBeanIntrospector() {
        Assertions.assertTrue((boolean)PropertyUtils.removeBeanIntrospector((BeanIntrospector)DefaultBeanIntrospector.INSTANCE), (String)"Wrong result");
        PropertyDescriptor[] desc = PropertyUtils.getPropertyDescriptors(AlphaBean.class);
        Assertions.assertEquals((int)0, (int)desc.length, (String)"Got descriptors");
        PropertyUtils.addBeanIntrospector((BeanIntrospector)DefaultBeanIntrospector.INSTANCE);
    }

    @Test
    public void testResetBeanIntrospectors() {
        Assertions.assertTrue((boolean)PropertyUtils.removeBeanIntrospector((BeanIntrospector)DefaultBeanIntrospector.INSTANCE), (String)"Wrong result");
        PropertyUtils.resetBeanIntrospectors();
        PropertyDescriptor[] desc = PropertyUtils.getPropertyDescriptors(AlphaBean.class);
        Assertions.assertTrue((desc.length > 0 ? 1 : 0) != 0, (String)"Got no descriptors");
    }

    @Test
    public void testSetIndexedArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setIndexedProperty(null, (String)"intArray", (int)0, (Object)1));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, null, (int)0, (Object)1));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setIndexedProperty(null, (String)"intArray[0]", (Object)1));
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"[0]", (Object)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (Object)1));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setIndexedProperty(null, (String)"intIndexed", (int)0, (Object)1));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, null, (int)0, (Object)1));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setIndexedProperty(null, (String)"intIndexed[0]", (Object)1));
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"[0]", (Object)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (Object)1));
    }

    @Test
    public void testSetIndexedArray() throws Exception {
        String[] firstArray = new String[]{"FIRST-1", "FIRST-2", "FIRST-3"};
        String[] secondArray = new String[]{"SECOND-1", "SECOND-2", "SECOND-3", "SECOND-4"};
        String[][] mainArray = new String[][]{firstArray, secondArray};
        TestBean bean = new TestBean(mainArray);
        Assertions.assertEquals((Object)"SECOND-3", (Object)bean.getString2dArray(1)[2], (String)"BEFORE");
        PropertyUtils.setProperty((Object)bean, (String)"string2dArray[1][2]", (Object)"SECOND-3-UPDATED");
        Assertions.assertEquals((Object)"SECOND-3-UPDATED", (Object)bean.getString2dArray(1)[2], (String)"AFTER");
    }

    @Test
    public void testSetIndexedList() throws Exception {
        String[] firstArray = new String[]{"FIRST-1", "FIRST-2", "FIRST-3"};
        String[] secondArray = new String[]{"SECOND-1", "SECOND-2", "SECOND-3", "SECOND-4"};
        ArrayList<Object> mainList = new ArrayList<Object>();
        mainList.add(Arrays.asList(firstArray));
        mainList.add(Arrays.asList(secondArray));
        TestBean bean = new TestBean(mainList);
        Assertions.assertEquals((Object)"SECOND-4", ((List)bean.getListIndexed().get(1)).get(3), (String)"BEFORE");
        PropertyUtils.setProperty((Object)bean, (String)"listIndexed[1][3]", (Object)"SECOND-4-UPDATED");
        Assertions.assertEquals((Object)"SECOND-4-UPDATED", ((List)bean.getListIndexed().get(1)).get(3), (String)"AFTER");
    }

    @Test
    public void testSetIndexedMap() throws Exception {
        HashMap<String, String> firstMap = new HashMap<String, String>();
        firstMap.put("FIRST-KEY-1", "FIRST-VALUE-1");
        firstMap.put("FIRST-KEY-2", "FIRST-VALUE-2");
        HashMap<String, String> secondMap = new HashMap<String, String>();
        secondMap.put("SECOND-KEY-1", "SECOND-VALUE-1");
        secondMap.put("SECOND-KEY-2", "SECOND-VALUE-2");
        ArrayList<Object> mainList = new ArrayList<Object>();
        mainList.add(firstMap);
        mainList.add(secondMap);
        TestBean bean = new TestBean(mainList);
        Assertions.assertEquals(null, ((Map)bean.getListIndexed().get(0)).get("FIRST-NEW-KEY"), (String)"BEFORE");
        Assertions.assertEquals((Object)"SECOND-VALUE-1", ((Map)bean.getListIndexed().get(1)).get("SECOND-KEY-1"), (String)"BEFORE");
        PropertyUtils.setProperty((Object)bean, (String)"listIndexed[0](FIRST-NEW-KEY)", (Object)"FIRST-NEW-VALUE");
        PropertyUtils.setProperty((Object)bean, (String)"listIndexed[1](SECOND-KEY-1)", (Object)"SECOND-VALUE-1-UPDATED");
        Assertions.assertEquals((Object)"FIRST-NEW-VALUE", ((Map)bean.getListIndexed().get(0)).get("FIRST-NEW-KEY"), (String)"BEFORE");
        Assertions.assertEquals((Object)"SECOND-VALUE-1-UPDATED", ((Map)bean.getListIndexed().get(1)).get("SECOND-KEY-1"), (String)"AFTER");
    }

    @Test
    public void testSetIndexedValues() throws Exception {
        Object value = null;
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"dupProperty", (int)0, (Object)"New 0");
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"dupProperty", (int)0);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 0");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 0");
        Assertions.assertEquals((Object)"New 0", (Object)((String)value), (String)"Returned correct new value 0");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (int)0, (Object)1);
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)0);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 0");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Returned Integer new value 0");
        Assertions.assertEquals((int)1, (int)((Integer)value), (String)"Returned correct new value 0");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (int)1, (Object)11);
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)1);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 1");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Returned Integer new value 1");
        Assertions.assertEquals((int)11, (int)((Integer)value), (String)"Returned correct new value 1");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed", (int)2, (Object)"New Value 2");
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)2);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 2");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 2");
        Assertions.assertEquals((Object)"New Value 2", (Object)((String)value), (String)"Returned correct new value 2");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)2, (Object)"New Value 2");
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)2);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 2");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 2");
        Assertions.assertEquals((Object)"New Value 2", (Object)((String)value), (String)"Returned correct new value 2");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)3, (Object)"New Value 3");
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)3);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 3");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 3");
        Assertions.assertEquals((Object)"New Value 3", (Object)((String)value), (String)"Returned correct new value 3");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"dupProperty[4]", (Object)"New 4");
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"dupProperty[4]");
        Assertions.assertNotNull((Object)value, (String)"Returned new value 4");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 4");
        Assertions.assertEquals((Object)"New 4", (Object)((String)value), (String)"Returned correct new value 4");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray[4]", (Object)1);
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray[4]");
        Assertions.assertNotNull((Object)value, (String)"Returned new value 4");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Returned Integer new value 4");
        Assertions.assertEquals((int)1, (int)((Integer)value), (String)"Returned correct new value 4");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed[3]", (Object)11);
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed[3]");
        Assertions.assertNotNull((Object)value, (String)"Returned new value 5");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Returned Integer new value 5");
        Assertions.assertEquals((int)11, (int)((Integer)value), (String)"Returned correct new value 5");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed[1]", (Object)"New Value 2");
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed[1]");
        Assertions.assertNotNull((Object)value, (String)"Returned new value 6");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 6");
        Assertions.assertEquals((Object)"New Value 2", (Object)((String)value), (String)"Returned correct new value 6");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray[1]", (Object)"New Value 2");
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray[2]");
        Assertions.assertNotNull((Object)value, (String)"Returned new value 6");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 6");
        Assertions.assertEquals((Object)"New Value 2", (Object)((String)value), (String)"Returned correct new value 6");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray[0]", (Object)"New Value 3");
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray[0]");
        Assertions.assertNotNull((Object)value, (String)"Returned new value 7");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 7");
        Assertions.assertEquals((Object)"New Value 3", (Object)((String)value), (String)"Returned correct new value 7");
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"dupProperty", (int)-1, (Object)"New -1"));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"dupProperty", (int)5, (Object)"New 5"));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (int)-1, (Object)0));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (int)5, (Object)0));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (int)-1, (Object)0));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (int)5, (Object)0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed", (int)5, (Object)"New String"));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed", (int)-1, (Object)"New String"));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)-1, (Object)"New String"));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)5, (Object)"New String"));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)-1, (Object)"New String"));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)5, (Object)"New String"));
    }

    @Test
    public void testSetMappedArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setMappedProperty(null, (String)"mappedProperty", (String)"First Key", (Object)"First Value"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setMappedProperty((Object)this.bean, null, (String)"First Key", (Object)"First Value"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty", null, (Object)"First Value"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setMappedProperty(null, (String)"mappedProperty(First Key)", (Object)"First Value"));
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setMappedProperty((Object)this.bean, (String)"(Second Key)", (Object)"Second Value"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty", (Object)"Third Value"));
    }

    @Test
    public void testSetMappedArray() throws Exception {
        TestBean bean = new TestBean();
        String[] array = new String[]{"abc", "def", "ghi"};
        bean.getMapProperty().put("mappedArray", array);
        Assertions.assertEquals((Object)"def", (Object)((String[])bean.getMapProperty().get("mappedArray"))[1], (String)"BEFORE");
        PropertyUtils.setProperty((Object)bean, (String)"mapProperty(mappedArray)[1]", (Object)"DEF-UPDATED");
        Assertions.assertEquals((Object)"DEF-UPDATED", (Object)((String[])bean.getMapProperty().get("mappedArray"))[1], (String)"AFTER");
    }

    @Test
    public void testSetMappedList() throws Exception {
        TestBean bean = new TestBean();
        ArrayList<String> list = new ArrayList<String>();
        list.add("klm");
        list.add("nop");
        list.add("qrs");
        bean.getMapProperty().put("mappedList", list);
        Assertions.assertEquals((Object)"klm", ((List)bean.getMapProperty().get("mappedList")).get(0), (String)"BEFORE");
        PropertyUtils.setProperty((Object)bean, (String)"mapProperty(mappedList)[0]", (Object)"KLM-UPDATED");
        Assertions.assertEquals((Object)"KLM-UPDATED", ((List)bean.getMapProperty().get("mappedList")).get(0), (String)"AFTER");
    }

    @Test
    public void testSetMappedMap() throws Exception {
        TestBean bean = new TestBean();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sub-key-1", "sub-value-1");
        map.put("sub-key-2", "sub-value-2");
        map.put("sub-key-3", "sub-value-3");
        bean.getMapProperty().put("mappedMap", map);
        Assertions.assertEquals((Object)"sub-value-3", ((Map)bean.getMapProperty().get("mappedMap")).get("sub-key-3"), (String)"BEFORE");
        PropertyUtils.setProperty((Object)bean, (String)"mapProperty(mappedMap)(sub-key-3)", (Object)"SUB-KEY-3-UPDATED");
        Assertions.assertEquals((Object)"SUB-KEY-3-UPDATED", ((Map)bean.getMapProperty().get("mappedMap")).get("sub-key-3"), (String)"AFTER");
    }

    @Test
    public void testSetMappedPeriods() throws Exception {
        this.bean.setMappedProperty("key.with.a.dot", "Special Value");
        Assertions.assertEquals((Object)"Special Value", (Object)this.bean.getMappedProperty("key.with.a.dot"), (String)"Can retrieve directly (A)");
        PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"key.with.a.dot", (Object)"Updated Special Value");
        Assertions.assertEquals((Object)"Updated Special Value", (Object)this.bean.getMappedProperty("key.with.a.dot"), (String)"Check set via setMappedProperty");
        this.bean.setMappedProperty("key.with.a.dot", "Special Value");
        Assertions.assertEquals((Object)"Special Value", (Object)this.bean.getMappedProperty("key.with.a.dot"), (String)"Can retrieve directly (B)");
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"mappedProperty(key.with.a.dot)", (Object)"Updated Special Value");
        Assertions.assertEquals((Object)"Updated Special Value", (Object)this.bean.getMappedProperty("key.with.a.dot"), (String)"Check set via setNestedProperty (B)");
        TestBean testBean = new TestBean();
        this.bean.setMappedObjects("nested.property", testBean);
        Assertions.assertEquals((Object)"This is a string", (Object)testBean.getStringProperty(), (String)"Can retrieve directly (C)");
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"mappedObjects(nested.property).stringProperty", (Object)"Updated String Value");
        Assertions.assertEquals((Object)"Updated String Value", (Object)testBean.getStringProperty(), (String)"Check set via setNestedProperty (C)");
        this.bean.getNested().setMappedProperty("Mapped Key", "Nested Mapped Value");
        Assertions.assertEquals((Object)"Nested Mapped Value", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.mappedProperty(Mapped Key)"), (String)"Can retrieve via getNestedProperty (D)");
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.mappedProperty(Mapped Key)", (Object)"Updated Nested Mapped Value");
        Assertions.assertEquals((Object)"Updated Nested Mapped Value", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.mappedProperty(Mapped Key)"), (String)"Check set via setNestedProperty (D)");
    }

    @Test
    public void testSetMappedValues() throws Exception {
        Object value = null;
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Fourth Key");
        Assertions.assertNull((Object)value, (String)"Can not find fourth value");
        PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Fourth Key", (Object)"Fourth Value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Fourth Key");
        Assertions.assertEquals((Object)"Fourth Value", (Object)value, (String)"Can find fourth value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Fifth Key)");
        Assertions.assertNull((Object)value, (String)"Can not find fifth value");
        PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty(Fifth Key)", (Object)"Fifth Value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Fifth Key)");
        Assertions.assertEquals((Object)"Fifth Value", (Object)value, (String)"Can find fifth value");
        value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Sixth Key");
        Assertions.assertNull((Object)value, (String)"Can not find sixth value");
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"mapProperty.Sixth Key", (Object)"Sixth Value");
        value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Sixth Key");
        Assertions.assertEquals((Object)"Sixth Value", (Object)value, (String)"Can find sixth value");
    }

    @Test
    public void testSetNestedArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setNestedProperty(null, (String)"stringProperty", (Object)""));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setNestedProperty((Object)this.bean, null, (Object)""));
    }

    @Test
    public void testSetNestedBoolean() throws Exception {
        boolean oldValue = this.bean.getNested().getBooleanProperty();
        boolean newValue = !oldValue;
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.booleanProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)this.bean.getNested().getBooleanProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetNestedDouble() throws Exception {
        double oldValue = this.bean.getNested().getDoubleProperty();
        double newValue = oldValue + 1.0;
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.doubleProperty", (Object)newValue);
        Assertions.assertEquals((double)newValue, (double)this.bean.getNested().getDoubleProperty(), (double)0.005, (String)"Matched new value");
    }

    @Test
    public void testSetNestedFloat() throws Exception {
        float oldValue = this.bean.getNested().getFloatProperty();
        float newValue = oldValue + 1.0f;
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.floatProperty", (Object)Float.valueOf(newValue));
        Assertions.assertEquals((float)newValue, (float)this.bean.getNested().getFloatProperty(), (float)0.005f, (String)"Matched new value");
    }

    @Test
    public void testSetNestedInt() throws Exception {
        int oldValue = this.bean.getNested().getIntProperty();
        int newValue = oldValue + 1;
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.intProperty", (Object)newValue);
        Assertions.assertEquals((int)newValue, (int)this.bean.getNested().getIntProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetNestedLong() throws Exception {
        long oldValue = this.bean.getNested().getLongProperty();
        long newValue = oldValue + 1L;
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.longProperty", (Object)newValue);
        Assertions.assertEquals((long)newValue, (long)this.bean.getNested().getLongProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetNestedReadOnly() throws Exception {
        String oldValue = this.bean.getNested().getWriteOnlyPropertyValue();
        String newValue = oldValue + " Extra Value";
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.readOnlyProperty", (Object)newValue));
    }

    @Test
    public void testSetNestedShort() throws Exception {
        short oldValue;
        short newValue = oldValue = this.bean.getNested().getShortProperty();
        newValue = (short)(newValue + 1);
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.shortProperty", (Object)newValue);
        Assertions.assertEquals((short)newValue, (short)this.bean.getNested().getShortProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetNestedString() throws Exception {
        String oldValue = this.bean.getNested().getStringProperty();
        String newValue = oldValue + " Extra Value";
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.stringProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)this.bean.getNested().getStringProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetNestedUnknown() throws Exception {
        String newValue = "New String Value";
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.unknown", (Object)"New String Value"));
    }

    @Test
    public void testSetNestedWriteOnly() throws Exception {
        String oldValue = this.bean.getNested().getWriteOnlyPropertyValue();
        String newValue = oldValue + " Extra Value";
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.writeOnlyProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)this.bean.getNested().getWriteOnlyPropertyValue(), (String)"Matched new value");
    }

    @Test
    public void testSetNoGetter() throws Exception {
        BetaBean bean = new BetaBean("Cedric");
        bean.setNoGetterProperty("Sigma");
        Assertions.assertEquals((Object)"Sigma", (Object)bean.getSecret(), (String)"BetaBean test failed");
        Assertions.assertNotNull((Object)PropertyUtils.getPropertyDescriptor((Object)bean, (String)"noGetterProperty"), (String)"Descriptor is null");
        BeanUtils.setProperty((Object)bean, (String)"noGetterProperty", (Object)"Omega");
        Assertions.assertEquals((Object)"Omega", (Object)bean.getSecret(), (String)"Cannot set no-getter property");
        Assertions.assertNotNull((Object)PropertyUtils.getPropertyDescriptor((Object)bean, (String)"noGetterMappedProperty"), (String)"Map Descriptor is null");
        PropertyUtils.setMappedProperty((Object)bean, (String)"noGetterMappedProperty", (String)"Epsilon", (Object)"Epsilon");
        Assertions.assertEquals((Object)"MAP:Epsilon", (Object)bean.getSecret(), (String)"Cannot set mapped no-getter property");
    }

    @Test
    public void testSetPublicSubBean_of_PackageBean() throws Exception {
        PublicSubBean bean = new PublicSubBean();
        bean.setFoo("foo-start");
        bean.setBar("bar-start");
        PropertyUtils.setProperty((Object)bean, (String)"foo", (Object)"foo-updated");
        Assertions.assertEquals((Object)"foo-updated", (Object)bean.getFoo(), (String)"foo property");
        PropertyUtils.setProperty((Object)bean, (String)"bar", (Object)"bar-updated");
        Assertions.assertEquals((Object)"bar-updated", (Object)bean.getBar(), (String)"bar property");
    }

    @Test
    public void testSetSimpleArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setSimpleProperty(null, (String)"stringProperty", (Object)""));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setSimpleProperty((Object)this.bean, null, (Object)""));
    }

    @Test
    public void testSetSimpleBoolean() throws Exception {
        boolean oldValue = this.bean.getBooleanProperty();
        boolean newValue = !oldValue;
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"booleanProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)this.bean.getBooleanProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleDouble() throws Exception {
        double oldValue = this.bean.getDoubleProperty();
        double newValue = oldValue + 1.0;
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"doubleProperty", (Object)newValue);
        Assertions.assertEquals((double)newValue, (double)this.bean.getDoubleProperty(), (double)0.005, (String)"Matched new value");
    }

    @Test
    public void testSetSimpleFloat() throws Exception {
        float oldValue = this.bean.getFloatProperty();
        float newValue = oldValue + 1.0f;
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"floatProperty", (Object)Float.valueOf(newValue));
        Assertions.assertEquals((float)newValue, (float)this.bean.getFloatProperty(), (float)0.005f, (String)"Matched new value");
    }

    @Test
    public void testSetSimpleIndexed() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.setSimpleProperty((Object)this.bean, (String)"stringIndexed[0]", (Object)"New String Value"));
    }

    @Test
    public void testSetSimpleInt() throws Exception {
        int oldValue = this.bean.getIntProperty();
        int newValue = oldValue + 1;
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"intProperty", (Object)newValue);
        Assertions.assertEquals((int)newValue, (int)this.bean.getIntProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleLong() throws Exception {
        long oldValue = this.bean.getLongProperty();
        long newValue = oldValue + 1L;
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"longProperty", (Object)newValue);
        Assertions.assertEquals((long)newValue, (long)this.bean.getLongProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleNested() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.setSimpleProperty((Object)this.bean, (String)"nested.stringProperty", (Object)"New String Value"));
    }

    @Test
    public void testSetSimpleReadOnly() throws Exception {
        String oldValue = this.bean.getWriteOnlyPropertyValue();
        String newValue = oldValue + " Extra Value";
        NoSuchMethodException e = (NoSuchMethodException)Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setSimpleProperty((Object)this.bean, (String)"readOnlyProperty", (Object)newValue));
        Assertions.assertEquals((Object)("Property 'readOnlyProperty' has no setter method in class '" + this.bean.getClass() + "'"), (Object)e.getMessage());
    }

    @Test
    public void testSetSimpleShort() throws Exception {
        short oldValue;
        short newValue = oldValue = this.bean.getShortProperty();
        newValue = (short)(newValue + 1);
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"shortProperty", (Object)newValue);
        Assertions.assertEquals((short)newValue, (short)this.bean.getShortProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleString() throws Exception {
        String oldValue = this.bean.getStringProperty();
        String newValue = oldValue + " Extra Value";
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"stringProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)this.bean.getStringProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleUnknown() throws Exception {
        String newValue = "New String Value";
        NoSuchMethodException e = (NoSuchMethodException)Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setSimpleProperty((Object)this.bean, (String)"unknown", (Object)"New String Value"));
        Assertions.assertEquals((Object)("Unknown property 'unknown' on class '" + this.bean.getClass() + "'"), (Object)e.getMessage());
    }

    @Test
    public void testSetSimpleWriteOnly() throws Exception {
        String oldValue = this.bean.getWriteOnlyPropertyValue();
        String newValue = oldValue + " Extra Value";
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"writeOnlyProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)this.bean.getWriteOnlyPropertyValue(), (String)"Matched new value");
    }

    @Test
    public void testThrowNestedNull() throws Exception {
        NestedTestBean nestedBean = new NestedTestBean("base");
        Assertions.assertThrows(NestedNullException.class, () -> PropertyUtils.getProperty((Object)nestedBean, (String)"simpleBeanProperty.indexedProperty[0]"));
    }
}

