/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.camel.test.infra.smb.services;

import org.apache.camel.test.infra.common.services.InfrastructureService;

public interface SmbInfraService extends InfrastructureService {
    String address();

    String shareName();

    @Deprecated
    String userName();

    String password();

    String smbFile(String file);

    default String hostname() {
        String addr = address();
        if (addr != null && addr.contains(":")) {
            return addr.substring(0, addr.indexOf(':'));
        }
        return addr;
    }

    default int port() {
        String addr = address();
        if (addr != null && addr.contains(":")) {
            return Integer.parseInt(addr.substring(addr.indexOf(':') + 1));
        }
        return 445; // default SMB port
    }

    default String username() {
        return userName();
    }

    default String endpointUri() {
        return String.format("smb:%s:%d/%s?username=%s&password=RAW(%s)", hostname(), port(), shareName(), username(),
                password());
    }

    default String connectionBase() {
        return String.format("smb:%s:%d", hostname(), port());
    }
}
