/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.test.main.junit6.legacy;

import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.spi.Registry;
import org.apache.camel.test.main.junit6.CamelMainTestSupport;
import org.apache.camel.test.main.junit6.common.Greetings;
import org.apache.camel.test.main.junit6.common.MyConfiguration;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.Mockito.when;

/**
 * The test class ensuring that an existing bean can be replaced with a mock from another extension.
 */
@ExtendWith(MockitoExtension.class)
class ReplaceBeanWithMockTest extends CamelMainTestSupport {

    @Mock
    Greetings greetings;

    @Override
    protected void configure(MainConfigurationProperties configuration) {
        // Add the configuration class
        configuration.addConfiguration(MyConfiguration.class);
    }

    @Override
    protected void postProcessTest() throws Exception {
        super.postProcessTest();

        bindToRegistryAfterInjections(context.getRegistry());
    }

    @Override
    protected void bindToRegistryAfterInjections(Registry registry) throws Exception {
        when(greetings.sayHello()).thenReturn("Hola Will!");
        registry.bind("myGreetings", Greetings.class, greetings);
    }

    @Test
    void shouldReplaceTheBeanWithAMock() throws Exception {
        MockEndpoint mock = context.getEndpoint("mock:out", MockEndpoint.class);
        mock.expectedBodiesReceived("Hola Will!");
        String result = template.requestBody("direct:in", null, String.class);
        mock.assertIsSatisfied();
        assertEquals("Hola Will!", result);
    }
}
