/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Convert text to natural-sounding speech using IBM Watson Text to Speech
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WatsonTextToSpeechEndpointBuilderFactory {

    /**
     * Builder for endpoint for the IBM Watson Text to Speech component.
     */
    public interface WatsonTextToSpeechEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWatsonTextToSpeechEndpointBuilder advanced() {
            return (AdvancedWatsonTextToSpeechEndpointBuilder) this;
        }

        /**
         * The service endpoint URL. If not specified, the default URL will be
         * used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param serviceUrl the value to set
         * @return the dsl builder
         */
        default WatsonTextToSpeechEndpointBuilder serviceUrl(String serviceUrl) {
            doSetProperty("serviceUrl", serviceUrl);
            return this;
        }
        /**
         * The audio format for synthesized speech. Default is audio/wav.
         * Supported formats: audio/wav, audio/mp3, audio/ogg, audio/flac,
         * audio/webm.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: audio/wav
         * Group: producer
         * 
         * @param accept the value to set
         * @return the dsl builder
         */
        default WatsonTextToSpeechEndpointBuilder accept(String accept) {
            doSetProperty("accept", accept);
            return this;
        }
        /**
         * The customization ID (GUID) of a custom voice model to use for
         * synthesis.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param customizationId the value to set
         * @return the dsl builder
         */
        default WatsonTextToSpeechEndpointBuilder customizationId(String customizationId) {
            doSetProperty("customizationId", customizationId);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.ibm.watson.tts.WatsonTextToSpeechOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default WatsonTextToSpeechEndpointBuilder operation(org.apache.camel.component.ibm.watson.tts.WatsonTextToSpeechOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.ibm.watson.tts.WatsonTextToSpeechOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default WatsonTextToSpeechEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The voice to use for synthesis. Default is en-US_MichaelV3Voice.
         * Examples: en-US_AllisonV3Voice, en-GB_KateV3Voice,
         * es-ES_EnriqueV3Voice, fr-FR_NicolasV3Voice.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: en-US_MichaelV3Voice
         * Group: producer
         * 
         * @param voice the value to set
         * @return the dsl builder
         */
        default WatsonTextToSpeechEndpointBuilder voice(String voice) {
            doSetProperty("voice", voice);
            return this;
        }
        /**
         * The IBM Cloud API key for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default WatsonTextToSpeechEndpointBuilder apiKey(String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IBM Watson Text to Speech component.
     */
    public interface AdvancedWatsonTextToSpeechEndpointBuilder
            extends
                EndpointProducerBuilder {
        default WatsonTextToSpeechEndpointBuilder basic() {
            return (WatsonTextToSpeechEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonTextToSpeechEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonTextToSpeechEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface WatsonTextToSpeechBuilders {
        /**
         * IBM Watson Text to Speech (camel-ibm-watson-text-to-speech)
         * Convert text to natural-sounding speech using IBM Watson Text to
         * Speech
         * 
         * Category: ai,cloud
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-ibm-watson-text-to-speech
         * 
         * @return the dsl builder for the headers' name.
         */
        default WatsonTextToSpeechHeaderNameBuilder ibmWatsonTextToSpeech() {
            return WatsonTextToSpeechHeaderNameBuilder.INSTANCE;
        }
        /**
         * IBM Watson Text to Speech (camel-ibm-watson-text-to-speech)
         * Convert text to natural-sounding speech using IBM Watson Text to
         * Speech
         * 
         * Category: ai,cloud
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-ibm-watson-text-to-speech
         * 
         * Syntax: <code>ibm-watson-text-to-speech:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path label
         * @return the dsl builder
         */
        default WatsonTextToSpeechEndpointBuilder ibmWatsonTextToSpeech(String path) {
            return WatsonTextToSpeechEndpointBuilderFactory.endpointBuilder("ibm-watson-text-to-speech", path);
        }
        /**
         * IBM Watson Text to Speech (camel-ibm-watson-text-to-speech)
         * Convert text to natural-sounding speech using IBM Watson Text to
         * Speech
         * 
         * Category: ai,cloud
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-ibm-watson-text-to-speech
         * 
         * Syntax: <code>ibm-watson-text-to-speech:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default WatsonTextToSpeechEndpointBuilder ibmWatsonTextToSpeech(String componentName, String path) {
            return WatsonTextToSpeechEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the IBM Watson Text to Speech component.
     */
    public static class WatsonTextToSpeechHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final WatsonTextToSpeechHeaderNameBuilder INSTANCE = new WatsonTextToSpeechHeaderNameBuilder();

        /**
         * The operation to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonTTSOperation}.
         */
        public String iBMWatsonTTSOperation() {
            return "CamelIBMWatsonTTSOperation";
        }
        /**
         * The text to synthesize into speech.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonTTSText}.
         */
        public String iBMWatsonTTSText() {
            return "CamelIBMWatsonTTSText";
        }
        /**
         * The voice to use for synthesis.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonTTSVoice}.
         */
        public String iBMWatsonTTSVoice() {
            return "CamelIBMWatsonTTSVoice";
        }
        /**
         * The audio format (e.g., audio/wav, audio/mp3, audio/ogg).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonTTSAccept}.
         */
        public String iBMWatsonTTSAccept() {
            return "CamelIBMWatsonTTSAccept";
        }
        /**
         * The customization ID for a custom voice model.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonTTSCustomizationId}.
         */
        public String iBMWatsonTTSCustomizationId() {
            return "CamelIBMWatsonTTSCustomizationId";
        }
        /**
         * The word for which to get pronunciation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonTTSWord}.
         */
        public String iBMWatsonTTSWord() {
            return "CamelIBMWatsonTTSWord";
        }
        /**
         * The pronunciation format (ipa or ibm).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonTTSFormat}.
         */
        public String iBMWatsonTTSFormat() {
            return "CamelIBMWatsonTTSFormat";
        }
        /**
         * The language for filtering custom models.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonTTSLanguage}.
         */
        public String iBMWatsonTTSLanguage() {
            return "CamelIBMWatsonTTSLanguage";
        }
        /**
         * The custom model ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonTTSModelId}.
         */
        public String iBMWatsonTTSModelId() {
            return "CamelIBMWatsonTTSModelId";
        }
        /**
         * The name of the voice.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonTTSVoiceName}.
         */
        public String iBMWatsonTTSVoiceName() {
            return "CamelIBMWatsonTTSVoiceName";
        }
    }
    static WatsonTextToSpeechEndpointBuilder endpointBuilder(String componentName, String path) {
        class WatsonTextToSpeechEndpointBuilderImpl extends AbstractEndpointBuilder implements WatsonTextToSpeechEndpointBuilder, AdvancedWatsonTextToSpeechEndpointBuilder {
            public WatsonTextToSpeechEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new WatsonTextToSpeechEndpointBuilderImpl(path);
    }
}