#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <time.h>
#include <sys/utsname.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/ax25.h>
#include <linux/rose.h>
#include <linux/in.h>
#include <netdb.h>
#include <arpa/inet.h>

#include "node.h"
#include "io.h"
#include "md2.h"

static int sys_mode = 0;

int is_sysop(void)
{
	return(sys_mode);
}

int do_sysop(int argc, char **argv)
{
	char *p;
	time_t md2key;
	char md2str[40];
	char source[256];

	md2key = time(NULL);

	node_msg("%s> [%010ld]", cfg.alt_callsign, md2key);

	sprintf(source, "%010ld%s", md2key, cfg.password);
	MD2String(md2str, source);

	usflush(User.fd);
	User.state = STATE_IDLE;
	time(&User.cmdtime);
	update_user();
	alarm(IdleTimeout);
	for (;;)
	{
		if ((p = readline(User.fd)) == NULL) 
		{
			if (errno == EINTR)
				continue;
			logout("User disconnected");
		}
		break;
	}

	if (strcasecmp(p, md2str) == 0)
	{
		sys_mode = 1;
		node_msg("OK");
	}
	/*
	sys_mode = 1;
	node_msg("OK");
	*/
	
	return(0);
}

int do_dir(int argc, char **argv)
{
	return(0);
}

int do_yapp(int argc, char **argv)
{
	return(0);
}

