/*
 * Copyright 1996, 1997 Heikki Hannikainen OH7LZB <hessu@pspt.fi>
 *
 * Portions and ideas (like the ibm character mapping) from
 *	Tomi Manninen OH2BNS <Tomi.Manninen@hut.fi>
 */

#include <stdio.h>
#include <stdarg.h>
#include <netdb.h>
#include <netinet/in.h>
#include <string.h>

#include "listen.h"

int sevenbit = 1;	/* Are we on a 7-bit terminal? */
int ibmhack = 0;	/* IBM mapping? */

/* mapping of IBM codepage 437 chars 128-159 to ISO latin1 equivalents
 * (158 and 159 are mapped to space)
 */

unsigned char ibm_map[32] =
{
	199, 252, 233, 226, 228, 224, 229, 231,
	234, 235, 232, 239, 238, 236, 196, 197,
	201, 230, 198, 244, 246, 242, 251, 249,
	255, 214, 220, 162, 163, 165,  32,  32
};
                                  
/*
 *	Printf in Technicolor (TM) (available in selected theatres only)
 */
 
void lprintf(int dtype, char *fmt, ...)
{
	va_list args;
	char str[1024];
	unsigned char *p;
	
	va_start(args, fmt);
	vsnprintf(str, 1024, fmt, args);
	va_end(args);

	for (p = str; *p != '\0'; p++)
		if ((*p < 32 && *p != '\n')
		    || (*p > 126 && *p < 160 && sevenbit))
				*p = '.';
	fputs(str, stdout);
	fflush(stdout);
}
                                                          
char *servname(int port, char *proto)
{
	struct servent *serv;
	static char str[16];
	
	if ((serv = getservbyport(htons(port), proto)))
		strncpy(str, serv->s_name, 16);
	else
		snprintf(str, 16, "%i", port);

	return str;
}
