/*****************************************************************************/

/*
 *      sm.h  --  User soundmodem driver header.
 *
 *      Copyright (C) 1996-1998  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *        Swiss Federal Institute of Technology (ETH), Electronics Lab
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *  Linux user mode soundcard modem driver header file.
 *
 *  Please note that the GPL allows you to use the driver, NOT the radio.
 *  In order to use the radio, you need a license from the communications
 *  authority of your country.
 *
 */

#ifndef _SM_H
#define _SM_H
/* --------------------------------------------------------------------- */

#include <sys/types.h>
#include "util.h"
#include "soundmodem.h"
#include "usersmdiag.h"

/* ---------------------------------------------------------------------- */

#define MAXFLEN           512
#define RXBUFFER_SIZE     ((MAXFLEN*6/5)+8)
#define TXBUFFER_SIZE     8192

#define MAXMODEM             4   /* must be a power of 2 */
#define KISSOUTBUF_SIZE      16384
#define KISSINBUF_SIZE       (2*MAXFLEN+8)

#define SAMPLEBUF_SIZE       1024

#define SNDDRVMODE_CONVBYTESWAP  1
#define SNDDRVMODE_CONVU8        2
#define SNDDRVMODE_HALFDUPLEX    4

/* --------------------------------------------------------------------- */

#define KISS_FEND   ((unsigned char)0300)
#define KISS_FESC   ((unsigned char)0333)
#define KISS_TFEND  ((unsigned char)0334)
#define KISS_TFESC  ((unsigned char)0335)

#define KISS_CMD_DATA       0
#define KISS_CMD_TXDELAY    1
#define KISS_CMD_PPERSIST   2
#define KISS_CMD_SLOTTIME   3
#define KISS_CMD_TXTAIL     4
#define KISS_CMD_FULLDUP    5
#define KISS_CMD_HARDWARE   6
#define KISS_CMD_FECLEVEL   8
#define KISS_CMD_RETURN     255

/* ---------------------------------------------------------------------- */
/*
 * Information that need to be kept for each board.
 */

/* this whole structure must be aligned to at least 256 bytes */

struct soundmodem_state {
	struct {      /* must be at the beginning */
		void *mod;
		void *demod;
	} state[MAXMODEM];

	unsigned int dcd;   /* bitmap for DCD of channel */
	unsigned int samplerate, samplerateby100;
	unsigned int overlap;
	unsigned int drvmode;

	unsigned int nrmodulator, nrdemodulator;

	int audiofd, kissfd, serpttfd, parpttfd, midipttfd;

	u_int8_t invert_dcd, invert_ptt, ptt;

	struct {
		int16_t rxsbuf[SAMPLEBUF_SIZE];
	} snd;

	struct {
		int slotcnt;
	} access;

	struct generalstatistics {
		unsigned long kiss_out;
		unsigned long kiss_outerr;
		unsigned long kiss_in;
		unsigned long kiss_inerr;
		unsigned long ptt_keyed;
		unsigned int dma_residue1, dma_residue2, int_rate;
	} stat;

	struct chaccesspar {
		unsigned int txdelay;
		unsigned int slottime;
		unsigned int ppersist;
		unsigned int txtail;
		unsigned int fulldup;
	} chaccesspar;

	struct {
		unsigned ptr;
		u_int8_t b[KISSINBUF_SIZE];
	} kissin;

	struct {
		unsigned rd;
		unsigned wr;
		u_int8_t b[KISSOUTBUF_SIZE];
	} kissout;

	struct modulator {
		unsigned int calibrate;

		struct txstatistics {
			unsigned long tx_packets;
			unsigned long tx_dropped;
			unsigned long tx_errors;
			unsigned long tx_cycles;
		} stat;

		struct soundmodem_modulator *code;
		void *dlhandle;
	} modulator[MAXMODEM];

	struct demodulator {

		struct rxstatistics {
			unsigned long rx_packets;
			unsigned long rx_errors;
			unsigned long rx_cycles;
		} stat;

		u_int16_t diagmode;
		u_int32_t diagseq[16];

		struct soundmodem_demodulator *code;
		void *dlhandle;
	} demodulator[MAXMODEM];
};

/* --------------------------------------------------------------------- */

#define min(a, b) (((a) < (b)) ? (a) : (b))
#define max(a, b) (((a) > (b)) ? (a) : (b))

/* --------------------------------------------------------------------- */

/* misc.c */

extern int snprintpkt(char *buf, size_t sz, const u_int8_t *pkt, unsigned len);

/* --------------------------------------------------------------------- */
#endif /* _SM_H */
