/*
 * Generate an inline assembler FIR filter optimized for the Pentium.
 * This is inspired by the works of Phil Karn and Thomas Sailer.
 *
 * The output is pretty ugly so running through `indent might be a
 * good idea.
 */

#include <stdio.h>

#include "config.h"

#include "modemconfig.h"

#define asmline(s)		puts("\"" s ";\\n\\t\"")
#define asmline2(s1,d,s2)	printf("\"%s%d%s;\\n\\t\"\n", s1, d, s2)

int main(int argc, char **argv)
{
	int i;

	puts("#ifndef _FILTER_I386_H");
	puts("#define _FILTER_I386_H");
	puts("#define __HAVE_ARCH_MAC");

	puts("extern inline float mac(const float *a, const float *b, unsigned int size)");
	puts("{float f;");
	puts("asm volatile (");

	asmline("flds (%1)");
	asmline("fmuls (%2)");
	asmline("flds 4(%1)");
	asmline("fmuls 4(%2)");

	for (i = 2; i < AliasFilterLen; i++) {
		asmline2("flds ", i * 4, "(%1)");
		asmline2("fmuls ", i * 4, "(%2)");
		asmline("fxch %%st(2)");
		asmline("faddp");
	}

	asmline("faddp");

	puts(": \"=t\" (f) : \"r\" (a) , \"r\" (b) : \"memory\");");
	puts("return f;}");

	puts("#endif");

	return 0;
}
