/*
 * gaxheard.c : A gnome ax25 mheard program
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <gnome.h>
#include <errno.h>

#include <netax25/ax25.h>
#include <netrose/rose.h>
#include <netax25/axlib.h>
#include <netax25/mheard.h>
/*
#include "axutils.h"
#include "version.h"*/

#include "config.h"
#include "main.h"
#include "props.h"

/* Function declarations */
static void LoadPortData(struct mhapp *app);
static void ClearPortData(void);
static void SortByTime(void);
static void SortByCall(void);
static void SortByPort(void);
static void SortByFrame(void);
static void ListAllPorts(struct mhapp *app);

/* The CLIST titles */
static gchar *default_titles[4] = {
	N_("Callsign"), N_("Port"), N_("Packets"), N_("Last Heard")
};
static gchar *call_titles[4] = {
	N_("Callsign"), N_("To"), N_("Digipeaters"), N_("Port")
};
static gchar *stats_titles[7] = {
	N_("Callsign"), N_("Port"), N_("# Info"), N_("# Super"), N_("# UN"),
	N_("First Heard"), N_("Last Heard")
};
static gchar *misc_titles[5] = {
	N_("Callsign"), N_("Port"), N_("Packets"), N_("Type"), N_("PIDs")
};





static void quit_cb(GtkWidget *widget, struct mhapp *app)
{
  prop_save(app);
  gtk_main_quit();
  return;
}

static void
about_cb(GtkWidget *widget, void *data)
{
  GtkWidget *about;
  const gchar *authors[] = {
    "Craig Small VK2XLZ <csmall@small.dropbear.id.au>",
    "Jonathon Naylor G4KLX <g4klx@k4klx.demon.co.uk>",
    NULL
  };

  about = gnome_about_new(APP_NAME, VERSION,
          _("(C) 1999 Craig Small"),
          authors,
	  _("This software comes with NO WARRANTY at all, please\n"
            "refer to COPYING file for more details.\n"
	    "Web Page: http://www.eye-net.com.au/hamradio/ghu/"),
                          NULL);
  gtk_widget_show(about);

  return;
}

gint update_cb(struct mhapp *app)
{
	gtk_clist_clear(GTK_CLIST(app->dclist));
	gtk_clist_clear(GTK_CLIST(app->cclist));
	gtk_clist_clear(GTK_CLIST(app->sclist));
	gtk_clist_clear(GTK_CLIST(app->mclist));

	ClearPortData();
	LoadPortData(app);

	switch (app->sortmode) {
		case MHEARD_SORT_TIME: SortByTime();  break;
		case MHEARD_SORT_PORT: SortByPort();  break;
		case MHEARD_SORT_FROM: SortByCall();  break;
		case MHEARD_SORT_FRAMES: SortByFrame(); break;
	}

    ListAllPorts(app);
	/* Add an update interval */
	return TRUE;
}


static GnomeUIInfo file_menu[] = {
    GNOMEUIINFO_MENU_EXIT_ITEM(quit_cb, NULL),
    GNOMEUIINFO_END
};

static GnomeUIInfo settings_menu[] = {
    GNOMEUIINFO_MENU_PREFERENCES_ITEM(prop_dialog, NULL),
    GNOMEUIINFO_END
};
static GnomeUIInfo help_menu[] = {
    GNOMEUIINFO_HELP(APP_NAME),
    GNOMEUIINFO_MENU_ABOUT_ITEM(about_cb, NULL),
    GNOMEUIINFO_END
};

static GnomeUIInfo main_menu[] = {
    GNOMEUIINFO_MENU_FILE_TREE(&file_menu),
    GNOMEUIINFO_MENU_SETTINGS_TREE(&settings_menu),
    GNOMEUIINFO_MENU_HELP_TREE(&help_menu),
    GNOMEUIINFO_END
};

struct PortRecord {
	struct mheard_struct entry;
	struct PortRecord *Next;
};

static char *types[] = {
	"SABM",
	"SABME",
	"DISC",
	"UA",
	"DM",
	"RR",
	"RNR",
	"REJ",
	"FRMR",
	"I",
	"UI",
	"????"};

static struct PortRecord *PortList = NULL;

static void prepare_app(struct mhapp *app)
{
	GtkWidget *w;

	app->app = gnome_app_new(APP_NAME, _("Gnome AX.25 mheard"));
	gtk_widget_set_usize(app->app, MHEARD_WIDTH, MHEARD_HEIGHT);
	gtk_signal_connect(GTK_OBJECT(app->app), "delete_event",
			   GTK_SIGNAL_FUNC(quit_cb),
			   app);
	gnome_app_create_menus_with_data(GNOME_APP(app->app), main_menu, (gpointer)app);

	app->notebook = gtk_notebook_new();
	gnome_app_set_contents(GNOME_APP(app->app), app->notebook);
	gtk_widget_show(app->notebook);

	app->dclist = gtk_clist_new_with_titles(4, default_titles);
	gtk_clist_set_column_width(GTK_CLIST(app->dclist), 0, CL_CALL_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->dclist), 1, CL_PORT_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->dclist), 2, CL_NUM_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->dclist), 0, CL_TIME_WIDTH);

	w = gtk_label_new(N_("Default"));
	gtk_notebook_append_page(GTK_NOTEBOOK(app->notebook), app->dclist, w);
	gtk_widget_show(app->dclist);
	gtk_widget_show(w);
	
	app->cclist = gtk_clist_new_with_titles(4, call_titles);
	gtk_clist_set_column_width(GTK_CLIST(app->cclist), 0, CL_CALL_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->cclist), 1, CL_CALL_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->cclist), 2, (CL_CALL_WIDTH*4));
	/*gtk_clist_set_column_width(GTK_CLIST(app->cclist), 0, CL_PORT_WIDTH);*/

	w = gtk_label_new(N_("Callsigns"));
	gtk_notebook_append_page(GTK_NOTEBOOK(app->notebook), app->cclist, w);
	gtk_widget_show(app->cclist);
	gtk_widget_show(w);
	
	app->sclist = gtk_clist_new_with_titles(7, stats_titles);
	gtk_clist_set_column_width(GTK_CLIST(app->sclist), 0, CL_CALL_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->sclist), 1, CL_PORT_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->sclist), 2, CL_NUM_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->sclist), 3, CL_NUM_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->sclist), 4, CL_NUM_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->sclist), 5, CL_TIME_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->sclist), 6, CL_TIME_WIDTH);
	w = gtk_label_new(N_("Statistics"));
	gtk_notebook_append_page(GTK_NOTEBOOK(app->notebook), app->sclist, w);
	gtk_widget_show(app->sclist);
	gtk_widget_show(w);
	
	app->mclist = gtk_clist_new_with_titles(5, misc_titles);
	gtk_clist_set_column_width(GTK_CLIST(app->mclist), 0, CL_CALL_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->mclist), 1, CL_PORT_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->mclist), 2, CL_NUM_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->mclist), 3, CL_NUM_WIDTH);
	gtk_clist_set_column_width(GTK_CLIST(app->mclist), 4, CL_NUM_WIDTH);
	w = gtk_label_new(N_("Misc"));
	gtk_notebook_append_page(GTK_NOTEBOOK(app->notebook), app->mclist, w);
	gtk_widget_show(app->mclist);
	gtk_widget_show(w);
	
	gtk_widget_show(app->app);
}


static void PrintPortEntry(struct PortRecord *pr, struct mhapp *app)
{
	char *call, *s;
	int i;
	gchar *ntext[4];
	gchar *ctext[4];
	gchar *stext[7];
	gchar *mtext[5];
	GString *gs;

	/* Fill the default clist */
	ntext[0] = g_strdup(ax25_ntoa(&pr->entry.from_call));
	if ((s = strstr(ntext[0], "-0")) != NULL)
		*s = '\0';
	ntext[1] = pr->entry.portname;
        ntext[2] = g_strdup_printf("%d",pr->entry.count);
	ntext[3] = g_strndup(ctime(&pr->entry.last_heard),19);
	gtk_clist_append(GTK_CLIST(app->dclist), ntext);
	g_free(ntext[0]);
	g_free(ntext[2]);
	g_free(ntext[3]);

	/* The Callsign clist */
	ctext[0] = g_strdup(ax25_ntoa(&pr->entry.from_call));
	if ((s = strstr(ctext[0], "-0")) != NULL)
		*s = '\0';
	ctext[1] = g_strdup(ax25_ntoa(&pr->entry.to_call));
	if ((s = strstr(ctext[1], "-0")) != NULL)
		*s = '\0';
	gs = g_string_new("");	
	for (i=0; i < pr->entry.ndigis && i < 4; i++) {
		gs = g_string_append(gs, ax25_ntoa(&pr->entry.digis[i]));
		if ((s = strstr(call, "-0")) != NULL)
			*s = '\0';
		gs = g_string_append(gs, ",");
	}
	ctext[2] = gs->str;
	ctext[3] = pr->entry.portname;
	gtk_clist_append(GTK_CLIST(app->cclist), ctext);
	g_string_free(gs,TRUE);
	g_free(ctext[0]);
	g_free(ctext[1]);
	/*g_free(ctext[2]);*/

	/* Stats clist */
	stext[0] = g_strdup(ax25_ntoa(&pr->entry.from_call));
	if ((s = strstr(stext[0], "-0")) != NULL)
		*s = '\0';
	stext[1] = pr->entry.portname;
	stext[2] = g_strdup_printf("%d", pr->entry.iframes);
	stext[3] = g_strdup_printf("%d", pr->entry.sframes);
	stext[4] = g_strdup_printf("%d", pr->entry.uframes);
	stext[5] = g_strndup(ctime(&pr->entry.first_heard),19);
	stext[6] = g_strndup(ctime(&pr->entry.last_heard),19);
	gtk_clist_append(GTK_CLIST(app->sclist), stext);
	g_free(stext[0]);
	g_free(stext[2]);
	g_free(stext[3]);
	g_free(stext[4]);
	g_free(stext[5]);
	g_free(stext[6]);

	/* misc clist */
	mtext[0] = g_strdup(ax25_ntoa(&pr->entry.from_call));
	if ((s = strstr(mtext[0], "-0")) != NULL)
		*s = '\0';
	mtext[1] = pr->entry.portname;
	mtext[2] = g_strdup_printf("%d", pr->entry.count);
	mtext[3] = types[pr->entry.type]; 
	mtext[4] = g_strconcat(
		(pr->entry.mode & MHEARD_MODE_ARP)? N_(" ARP"): "",
		(pr->entry.mode & MHEARD_MODE_FLEXNET)? N_(" FlexNet"): "",
		(pr->entry.mode & MHEARD_MODE_IP_DG)? N_(" IP-DG"): "",
		(pr->entry.mode & MHEARD_MODE_IP_VC)? N_(" IP-VC"): "",
		(pr->entry.mode & MHEARD_MODE_NETROM)? N_(" NET/ROM"): "",
		(pr->entry.mode & MHEARD_MODE_ROSE)? N_(" Rose"): "",
		(pr->entry.mode & MHEARD_MODE_SEGMENT)? N_(" Segment"): "",
		(pr->entry.mode & MHEARD_MODE_TEXNET)? N_(" TexNet"): "",
		(pr->entry.mode & MHEARD_MODE_TEXT)? N_(" Text"): "",
		(pr->entry.mode & MHEARD_MODE_PSATFT)? N_(" PacsatFT"): "",
		(pr->entry.mode & MHEARD_MODE_PSATPB)? N_(" PacsatPB"): "",
		(pr->entry.mode & MHEARD_MODE_UNKNOWN)? N_(" Unknown"): "",
		NULL);
	gtk_clist_append(GTK_CLIST(app->mclist), mtext);
	g_free(mtext[0]);
	g_free(mtext[2]);
	g_free(mtext[4]);

}

static void ListAllPorts(struct mhapp *app)
{
	struct PortRecord *pr;

	gtk_clist_freeze(GTK_CLIST(app->dclist));
	gtk_clist_freeze(GTK_CLIST(app->cclist));
	gtk_clist_freeze(GTK_CLIST(app->sclist));
	gtk_clist_freeze(GTK_CLIST(app->mclist));

	for (pr = PortList; pr != NULL; pr = pr->Next)
		PrintPortEntry(pr, app);

	gtk_clist_thaw(GTK_CLIST(app->dclist));
	gtk_clist_thaw(GTK_CLIST(app->cclist));
	gtk_clist_thaw(GTK_CLIST(app->sclist));
	gtk_clist_thaw(GTK_CLIST(app->mclist));
}
/*
static void ListOnlyPort(char *name, int data)
{
	struct PortRecord *pr;

	for (pr = PortList; pr != NULL; pr = pr->Next)
		if (strcmp(pr->entry.portname, name) == 0)
			PrintPortEntry(pr, data);
}
*/
static void ClearPortData(void)
{
	struct PortRecord *pr;

	for(pr = PortList; pr != NULL; pr = PortList)
	{
		PortList = pr->Next;
		g_free(pr);
	}
}

static void LoadPortData(struct mhapp *app)
{
	FILE *fp;
	struct PortRecord *pr;
	struct mheard_struct mheard;

	if ((fp = fopen(app->mheard_file, "r")) == NULL) {
		g_error( "mheard: Cannot open mheard data file \"%s\": %s\n",app->mheard_file, sys_errlist[errno]);
		exit(1);
	}

	while (fread(&mheard, sizeof(struct mheard_struct), 1, fp) == 1) {
		pr = g_malloc(sizeof(struct PortRecord));
		pr->entry = mheard;
		pr->Next  = PortList;
		PortList  = pr;
	}

	fclose(fp);
}

static void SortByTime(void)
{
	struct PortRecord *p = PortList;
	struct PortRecord *n;
	PortList = NULL;

	while (p != NULL) {
		struct PortRecord *w = PortList;

		n = p->Next;

		if (w == NULL || p->entry.last_heard > w->entry.last_heard) {
			p->Next  = w;
			PortList = p;
			p = n;
			continue;
		}

		while (w->Next != NULL && p->entry.last_heard <= w->Next->entry.last_heard)
			w = w->Next;

		p->Next = w->Next;
		w->Next = p;
		p = n;
	}
}


static void SortByPort(void)
{
	struct PortRecord *p = PortList;
	struct PortRecord *n;
	PortList = NULL;

	while (p != NULL) {
		struct PortRecord *w = PortList;

		n = p->Next;

		if (w == NULL || strcmp(p->entry.portname, w->entry.portname) < 0) {
			p->Next  = w;
			PortList = p;
			p = n;
			continue;
		}

		while (w->Next != NULL && strcmp(p->entry.portname, w->Next->entry.portname) >= 0)
			w = w->Next;

		p->Next = w->Next;
		w->Next = p;
		p = n;
	}
}

static void SortByCall(void)
{
	struct PortRecord *p = PortList;
	struct PortRecord *n;
	PortList = NULL;

	while (p != NULL) {
		struct PortRecord *w = PortList;

		n = p->Next;

		if (w == NULL || memcmp(&p->entry.from_call, &w->entry.from_call, sizeof(ax25_address)) < 0) {
			p->Next  = w;
			PortList = p;
			p = n;
			continue;
		}

		while (w->Next != NULL && memcmp(&p->entry.from_call, &w->Next->entry.from_call, sizeof(ax25_address)) >= 0)
			w = w->Next;

		p->Next = w->Next;
		w->Next = p;
		p = n;
	}
}

static void SortByFrame(void)
{
	struct PortRecord *p = PortList;
	struct PortRecord *n;
	PortList = NULL;

	while (p != NULL) {
		struct PortRecord *w = PortList;

		n = p->Next;

		if (w == NULL || p->entry.count > w->entry.count) {
			p->Next  = w;
			PortList = p;
			p = n;
			continue;
		}

		while (w->Next != NULL && p->entry.count <= w->Next->entry.count)
			w = w->Next;

		p->Next = w->Next;
		w->Next = p;
		p = n;
	}
}
		
void change_update_time(struct mhapp *app)
{
	gtk_timeout_remove(app->update_tag);

	app->update_tag = gtk_timeout_add(app->update_time, 
			(GtkFunction)update_cb,
			app);
}

int main(int argc, char *argv[])
{
	struct mhapp *app;

	app = (struct mhapp*)malloc(sizeof(struct mhapp));
	app->headers = TRUE;
	app->sortmode = MHEARD_SORT_TIME;

	gnome_init(APP_NAME, VERSION, argc, argv);
	prop_load(app);
	prepare_app(app);
	update_cb(app);

	app->update_tag = gtk_timeout_add(app->update_time, 
			(GtkFunction)update_cb,
			app);
	gtk_main();
	return 0;
}
