/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.doxia.module.confluence.parser.AnchorBlock;
import org.apache.maven.doxia.module.confluence.parser.Block;
import org.apache.maven.doxia.module.confluence.parser.BoldBlock;
import org.apache.maven.doxia.module.confluence.parser.ItalicBlock;
import org.apache.maven.doxia.module.confluence.parser.LinebreakBlock;
import org.apache.maven.doxia.module.confluence.parser.LinethroughBlock;
import org.apache.maven.doxia.module.confluence.parser.LinkBlock;
import org.apache.maven.doxia.module.confluence.parser.MonospaceBlock;
import org.apache.maven.doxia.module.confluence.parser.SubBlock;
import org.apache.maven.doxia.module.confluence.parser.SupBlock;
import org.apache.maven.doxia.module.confluence.parser.TextBlock;
import org.apache.maven.doxia.module.confluence.parser.UnderlineBlock;
import org.codehaus.plexus.util.StringUtils;

public class ChildBlocksBuilder {
    private boolean insideBold = false;
    private boolean insideItalic = false;
    private boolean insideLink = false;
    private boolean insideLinethrough = false;
    private boolean insideUnderline = false;
    private boolean insideSub = false;
    private boolean insideSup = false;
    private List<Block> blocks = new ArrayList<Block>();
    private StringBuilder text = new StringBuilder();
    private String input;
    private boolean insideMonospaced;

    public ChildBlocksBuilder(String input) {
        this.input = input;
    }

    public List<Block> getBlocks() {
        List<Block> specialBlocks = new ArrayList<Block>();
        for (int i = 0; i < this.input.length(); ++i) {
            char c = this.input.charAt(i);
            switch (c) {
                case '*': {
                    if (this.insideBold) {
                        this.insideBold = false;
                        specialBlocks = this.getList(new BoldBlock(this.getChildren(this.text, specialBlocks)), specialBlocks);
                        this.text = new StringBuilder();
                        break;
                    }
                    if (this.insideMonospaced) {
                        this.text.append(c);
                        break;
                    }
                    this.text = this.addTextBlockIfNecessary(this.blocks, specialBlocks, this.text);
                    this.insideBold = true;
                    break;
                }
                case '_': {
                    if (this.insideItalic) {
                        this.insideItalic = false;
                        specialBlocks = this.getList(new ItalicBlock(this.getChildren(this.text, specialBlocks)), specialBlocks);
                        this.text = new StringBuilder();
                        break;
                    }
                    if (this.insideLink || this.insideMonospaced) {
                        this.text.append(c);
                        break;
                    }
                    this.text = this.addTextBlockIfNecessary(this.blocks, specialBlocks, this.text);
                    this.insideItalic = true;
                    break;
                }
                case '-': {
                    if (this.insideLinethrough) {
                        this.insideLinethrough = false;
                        this.blocks.add(new LinethroughBlock(this.text.toString()));
                        this.text = new StringBuilder();
                        break;
                    }
                    if (this.insideLink || this.insideMonospaced) {
                        this.text.append(c);
                        break;
                    }
                    this.text = this.addTextBlockIfNecessary(this.blocks, specialBlocks, this.text);
                    this.insideLinethrough = true;
                    break;
                }
                case '+': {
                    if (this.insideUnderline) {
                        this.insideUnderline = false;
                        this.blocks.add(new UnderlineBlock(this.text.toString()));
                        this.text = new StringBuilder();
                        break;
                    }
                    if (this.insideLink || this.insideMonospaced) {
                        this.text.append(c);
                        break;
                    }
                    this.text = this.addTextBlockIfNecessary(this.blocks, specialBlocks, this.text);
                    this.insideUnderline = true;
                    break;
                }
                case '~': {
                    if (this.insideSub) {
                        this.insideSub = false;
                        this.blocks.add(new SubBlock(this.text.toString()));
                        this.text = new StringBuilder();
                        break;
                    }
                    if (this.insideLink || this.insideMonospaced) {
                        this.text.append(c);
                        break;
                    }
                    this.text = this.addTextBlockIfNecessary(this.blocks, specialBlocks, this.text);
                    this.insideSub = true;
                    break;
                }
                case '^': {
                    if (this.insideSup) {
                        this.insideSup = false;
                        this.blocks.add(new SupBlock(this.text.toString()));
                        this.text = new StringBuilder();
                        break;
                    }
                    if (this.insideLink || this.insideMonospaced) {
                        this.text.append(c);
                        break;
                    }
                    this.text = this.addTextBlockIfNecessary(this.blocks, specialBlocks, this.text);
                    this.insideSup = true;
                    break;
                }
                case '[': {
                    if (this.insideMonospaced) {
                        this.text.append(c);
                        break;
                    }
                    this.insideLink = true;
                    this.text = this.addTextBlockIfNecessary(this.blocks, specialBlocks, this.text);
                    break;
                }
                case ']': {
                    if (this.insideLink) {
                        String[] temp;
                        boolean addHTMLSuffix = false;
                        String link = this.text.toString();
                        if (!link.endsWith(".html") && !link.contains("http")) {
                            addHTMLSuffix = true;
                        }
                        if (link.contains("|")) {
                            String[] pieces = StringUtils.split((String)this.text.toString(), (String)"|");
                            if (pieces[1].startsWith("^")) {
                                pieces[1] = pieces[1].substring(1);
                                addHTMLSuffix = false;
                            }
                            if (addHTMLSuffix) {
                                if (!pieces[1].contains("#")) {
                                    pieces[1] = pieces[1].concat(".html");
                                } else if (!pieces[1].startsWith("#")) {
                                    temp = pieces[1].split("#");
                                    pieces[1] = temp[0] + ".html#" + temp[1];
                                }
                            }
                            this.blocks.add(new LinkBlock(pieces[1], pieces[0]));
                        } else {
                            String value = link;
                            if (link.startsWith("#")) {
                                value = link.substring(1);
                            } else if (link.startsWith("^")) {
                                value = link = link.substring(1);
                                addHTMLSuffix = false;
                            }
                            if (addHTMLSuffix) {
                                if (!link.contains("#")) {
                                    link = link.concat(".html");
                                } else if (!link.startsWith("#")) {
                                    temp = link.split("#");
                                    link = temp[0] + ".html#" + temp[1];
                                }
                            }
                            this.blocks.add(new LinkBlock(link, value));
                        }
                        this.text = new StringBuilder();
                        this.insideLink = false;
                        break;
                    }
                    if (!this.insideMonospaced) break;
                    this.text.append(c);
                    break;
                }
                case '{': {
                    if (this.insideMonospaced) {
                        this.text.append(c);
                        break;
                    }
                    this.text = this.addTextBlockIfNecessary(this.blocks, specialBlocks, this.text);
                    if (ChildBlocksBuilder.nextChar(this.input, i) != '{') break;
                    ++i;
                    this.insideMonospaced = true;
                    break;
                }
                case '}': {
                    if (ChildBlocksBuilder.nextChar(this.input, i) == '}') {
                        ++i;
                        this.insideMonospaced = false;
                        specialBlocks = this.getList(new MonospaceBlock(this.getChildren(this.text, specialBlocks)), specialBlocks);
                        this.text = new StringBuilder();
                        break;
                    }
                    if (this.insideMonospaced) {
                        this.text.append(c);
                        break;
                    }
                    String name = this.text.toString();
                    if (name.startsWith("anchor:")) {
                        this.blocks.add(new AnchorBlock(name.substring("anchor:".length())));
                    } else {
                        this.blocks.add(new TextBlock("{" + name + "}"));
                    }
                    this.text = new StringBuilder();
                    break;
                }
                case '\\': {
                    if (this.insideMonospaced) {
                        this.text.append(c);
                        break;
                    }
                    if (ChildBlocksBuilder.nextChar(this.input, i) == '\\') {
                        ++i;
                        this.text = this.addTextBlockIfNecessary(this.blocks, specialBlocks, this.text);
                        this.blocks.add(new LinebreakBlock());
                        break;
                    }
                    if (i == this.input.length() - 1) {
                        this.text.append('\\');
                        break;
                    }
                    this.text.append(this.input.charAt(++i));
                    break;
                }
                default: {
                    this.text.append(c);
                }
            }
            if (specialBlocks.isEmpty() || this.insideItalic || this.insideBold || this.insideMonospaced) continue;
            this.blocks.addAll(specialBlocks);
            specialBlocks.clear();
        }
        if (this.text.length() > 0) {
            this.blocks.add(new TextBlock(this.text.toString()));
        }
        return this.blocks;
    }

    private List<Block> getList(Block block, List<Block> currentBlocks) {
        ArrayList<Block> list = new ArrayList<Block>();
        if (this.insideBold || this.insideItalic || this.insideMonospaced) {
            list.addAll(currentBlocks);
        }
        list.add(block);
        return list;
    }

    private List<Block> getChildren(StringBuilder buffer, List<Block> currentBlocks) {
        String txt = buffer.toString().trim();
        if (currentBlocks.isEmpty() && StringUtils.isEmpty((String)txt)) {
            return new ArrayList<Block>();
        }
        ArrayList<Block> list = new ArrayList<Block>();
        if (!(this.insideBold || this.insideItalic || this.insideMonospaced)) {
            list.addAll(currentBlocks);
        }
        if (StringUtils.isEmpty((String)txt)) {
            return list;
        }
        list.add(new TextBlock(txt));
        return list;
    }

    private static char nextChar(String input, int i) {
        return input.length() > i + 1 ? input.charAt(i + 1) : (char)'\u0000';
    }

    private StringBuilder addTextBlockIfNecessary(List<Block> blcks, List<Block> specialBlocks, StringBuilder txt) {
        if (txt.length() == 0) {
            return txt;
        }
        TextBlock textBlock = new TextBlock(txt.toString());
        if (!(this.insideBold || this.insideItalic || this.insideMonospaced)) {
            blcks.add(textBlock);
        } else {
            specialBlocks.add(textBlock);
        }
        return new StringBuilder();
    }
}

