/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSLogicalNode;
import com.oracle.truffle.js.nodes.unary.JSIsNullOrUndefinedNode;
import java.util.Set;

@NodeInfo(shortName="??")
public class JSNullishCoalescingNode
extends JSLogicalNode {
    @Node.Child
    private JSIsNullOrUndefinedNode isNullOrUndefinedNode;

    public JSNullishCoalescingNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right, false);
    }

    public static JSNullishCoalescingNode create(JavaScriptNode left, JavaScriptNode right) {
        return new JSNullishCoalescingNode(left, right);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return this.getLeft().isResultAlwaysOfType(clazz) && this.getRight().isResultAlwaysOfType(clazz);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new JSNullishCoalescingNode(JSNullishCoalescingNode.cloneUninitialized(this.getLeft(), materializedTags), JSNullishCoalescingNode.cloneUninitialized(this.getRight(), materializedTags));
    }

    @Override
    protected boolean useLeftValue(Object leftValue) {
        if (this.isNullOrUndefinedNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isNullOrUndefinedNode = (JSIsNullOrUndefinedNode)this.insert(JSIsNullOrUndefinedNode.create());
        }
        return !this.isNullOrUndefinedNode.executeBoolean(leftValue);
    }
}

