/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import java.lang.ref.WeakReference;
import java.util.Iterator;

final class PolyglotReferences {
    private PolyglotReferences() {
    }

    static TruffleLanguage.ContextReference<Object> createAlwaysSingleContext(PolyglotLanguage language, boolean strong) {
        if (strong) {
            return new StrongSingleContext(language);
        }
        return new WeakSingleContext(language);
    }

    static TruffleLanguage.ContextReference<Object> createAssumeSingleContext(PolyglotLanguage language, Assumption validIf0, Assumption validIf1, TruffleLanguage.ContextReference<Object> fallback, boolean strong) {
        assert (!(fallback instanceof WeakSingleContext) && !(fallback instanceof StrongSingleContext));
        return new AssumeSingleContext(language, validIf0, validIf1, fallback, strong);
    }

    static TruffleLanguage.ContextReference<Object> createAlwaysMultiContext(PolyglotLanguage language) {
        return new MultiContextSupplier(language);
    }

    static TruffleLanguage.LanguageReference<TruffleLanguage<Object>> createAlwaysSingleLanguage(PolyglotLanguage language, PolyglotLanguageInstance initValue) {
        return new SingleLanguage(language, initValue);
    }

    static TruffleLanguage.LanguageReference<TruffleLanguage<Object>> createAssumeSingleLanguage(PolyglotLanguage language, PolyglotLanguageInstance initValue, Assumption validIf, TruffleLanguage.LanguageReference<TruffleLanguage<Object>> fallback) {
        assert (!(fallback instanceof SingleLanguage));
        return new AssumeSingleLanguage(language, initValue, validIf, fallback);
    }

    static TruffleLanguage.LanguageReference<TruffleLanguage<Object>> createAlwaysMultiLanguage(PolyglotLanguage language) {
        return new MultiLanguageSupplier(language);
    }

    private static AssertionError invalidSharingError(PolyglotEngineImpl usedEngine) throws AssertionError {
        Exception e = new Exception();
        StringBuilder stack = new StringBuilder();
        Exception exceptionCreating = null;
        try {
            TruffleStackTraceElement stackTrace;
            RootNode root;
            PolyglotEngineImpl engine;
            TruffleStackTrace.fillIn(e);
            TruffleLanguage.ContextPolicy prevPolicy = null;
            Iterator<TruffleStackTraceElement> iterator = TruffleStackTrace.getStackTrace(e).iterator();
            while (iterator.hasNext() && ((engine = (PolyglotEngineImpl)EngineAccessor.NODES.getPolyglotEngine(root = (stackTrace = iterator.next()).getTarget().getRootNode())) == null || usedEngine == engine)) {
                PolyglotLanguageInstance instance = PolyglotReferences.lookupLanguageInstance(root);
                TruffleLanguage.ContextPolicy policy = instance.language.getEffectiveContextPolicy(instance.language);
                SourceSection sourceSection = null;
                Node location = stackTrace.getLocation();
                if (location != null) {
                    sourceSection = location.getEncapsulatingSourceSection();
                }
                if (sourceSection == null) {
                    sourceSection = root.getSourceSection();
                }
                if ((prevPolicy == TruffleLanguage.ContextPolicy.EXCLUSIVE || policy == TruffleLanguage.ContextPolicy.EXCLUSIVE) && prevPolicy != policy && prevPolicy != null) {
                    stack.append(String.format("    <-- Likely Invalid Sharing --> %n", new Object[0]));
                }
                stack.append(String.format("  %-9s %s%n", new Object[]{policy, PolyglotReferences.createJavaStackFrame(instance.language, root.getName(), sourceSection)}));
                prevPolicy = policy;
            }
        }
        catch (Exception ex) {
            exceptionCreating = ex;
        }
        AssertionError error = new AssertionError((Object)String.format("Invalid sharing of runtime values in AST nodes detected.Stack trace: %n%s", stack.toString()));
        if (exceptionCreating != null) {
            ((Throwable)((Object)error)).addSuppressed(exceptionCreating);
        }
        return error;
    }

    static StackTraceElement createJavaStackFrame(PolyglotLanguage language, String rootName, SourceSection sourceLocation) {
        String declaringClass = "<" + language.getId() + ">";
        String methodName = rootName == null ? "" : rootName;
        String fileName = sourceLocation != null ? sourceLocation.getSource().getName() : "Unknown";
        int startLine = sourceLocation != null ? sourceLocation.getStartLine() : -1;
        return new StackTraceElement(declaringClass, methodName, fileName, startLine);
    }

    private static PolyglotLanguageInstance lookupLanguageInstance(RootNode root) {
        TruffleLanguage<?> spi = EngineAccessor.NODES.getLanguage(root);
        if (spi != null) {
            return (PolyglotLanguageInstance)EngineAccessor.LANGUAGE.getPolyglotLanguageInstance(spi);
        }
        return null;
    }

    private static boolean assertDirectContextAccess(PolyglotLanguageContext languageContext, Object languageContextImpl) throws AssertionError {
        boolean valid;
        if (languageContext == null) {
            return true;
        }
        PolyglotContextImpl otherContext = PolyglotContextImpl.requireContext();
        PolyglotLanguageContext otherLanguageContext = otherContext.getContext(languageContext.language);
        boolean bl = valid = otherLanguageContext.getContextImpl() == languageContextImpl;
        if (!valid) {
            throw PolyglotReferences.invalidSharingError(languageContext.getEngine());
        }
        return true;
    }

    private static boolean checkContextCollected(Object context) {
        if (context == null) {
            throw PolyglotReferences.invalidSharingError(null);
        }
        return true;
    }

    private static final class MultiContextSupplier
    extends TruffleLanguage.ContextReference<Object> {
        final PolyglotLanguage language;

        MultiContextSupplier(PolyglotLanguage language) {
            this.language = language;
        }

        @Override
        public Object get() {
            assert (this.language.assertCorrectEngine());
            return PolyglotContextImpl.currentEntered(this.language.engine).getContextImpl(this.language);
        }
    }

    private static final class MultiLanguageSupplier
    extends TruffleLanguage.LanguageReference<TruffleLanguage<Object>> {
        final PolyglotLanguage language;

        MultiLanguageSupplier(PolyglotLanguage language) {
            this.language = language;
        }

        @Override
        public TruffleLanguage<Object> get() {
            assert (this.language.assertCorrectEngine());
            return PolyglotContextImpl.currentEntered((PolyglotEngineImpl)this.language.engine).getContext((PolyglotLanguage)this.language).getLanguageInstance().spi;
        }
    }

    private static final class AssumeSingleLanguage
    extends TruffleLanguage.LanguageReference<TruffleLanguage<Object>> {
        private final TruffleLanguage.LanguageReference<TruffleLanguage<Object>> singleLanguageReference;
        private final TruffleLanguage.LanguageReference<TruffleLanguage<Object>> fallbackReference;
        private final Assumption singleLanguage;

        AssumeSingleLanguage(PolyglotLanguage language, PolyglotLanguageInstance initValue, Assumption singleContextAssumption, TruffleLanguage.LanguageReference<TruffleLanguage<Object>> fallbackReference) {
            this.singleLanguage = singleContextAssumption;
            this.singleLanguageReference = PolyglotReferences.createAlwaysSingleLanguage(language, initValue);
            this.fallbackReference = fallbackReference;
        }

        @Override
        public TruffleLanguage<Object> get() {
            if (this.singleLanguage.isValid()) {
                return this.singleLanguageReference.get();
            }
            return this.fallbackReference.get();
        }
    }

    private static final class AssumeSingleContext
    extends TruffleLanguage.ContextReference<Object> {
        private final TruffleLanguage.ContextReference<Object> singleContextReference;
        private final TruffleLanguage.ContextReference<Object> fallbackReference;
        private final Assumption validIf0;
        private final Assumption validIf1;

        AssumeSingleContext(PolyglotLanguage language, Assumption validIf0, Assumption validIf1, TruffleLanguage.ContextReference<Object> fallback, boolean strong) {
            this.validIf0 = validIf0;
            this.validIf1 = validIf1;
            this.singleContextReference = PolyglotReferences.createAlwaysSingleContext(language, strong);
            this.fallbackReference = fallback;
        }

        @Override
        public Object get() {
            Object context = !(this.validIf0 != null && !this.validIf0.isValid() || this.validIf1 != null && !this.validIf1.isValid()) ? this.singleContextReference.get() : this.fallbackReference.get();
            assert (this.fallbackReference.get() == context);
            return context;
        }
    }

    private static final class StrongSingleContext
    extends TruffleLanguage.ContextReference<Object> {
        private static final Object NO_CONTEXT = new Object();
        private final PolyglotLanguage language;
        @CompilerDirectives.CompilationFinal
        private volatile Object languageContextImpl = NO_CONTEXT;
        private volatile PolyglotLanguageContext languageContext;

        StrongSingleContext(PolyglotLanguage language) {
            this.language = language;
        }

        @Override
        public Object get() {
            assert (this.language.assertCorrectEngine());
            Object context = this.languageContextImpl;
            if (context == NO_CONTEXT) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                PolyglotLanguageContext langContext = this.language.getCurrentLanguageContext();
                assert (this.setLanguageContext(langContext));
                this.languageContextImpl = context = langContext.getContextImpl();
            }
            assert (PolyglotReferences.checkContextCollected(context));
            assert (PolyglotReferences.assertDirectContextAccess(this.languageContext, context));
            return context;
        }

        private boolean setLanguageContext(PolyglotLanguageContext langContext) {
            this.languageContext = langContext;
            return true;
        }
    }

    private static final class WeakSingleContext
    extends TruffleLanguage.ContextReference<Object> {
        private final PolyglotLanguage language;
        @CompilerDirectives.CompilationFinal
        private volatile WeakReference<Object> languageContextImpl;
        private volatile WeakReference<PolyglotLanguageContext> languageContext;

        WeakSingleContext(PolyglotLanguage language) {
            this.language = language;
        }

        @Override
        public Object get() {
            assert (this.language.assertCorrectEngine());
            WeakReference<Object> ref = this.languageContextImpl;
            if (ref == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                PolyglotLanguageContext langContext = this.language.getCurrentLanguageContext();
                assert (this.setLanguageContext(langContext));
                this.languageContextImpl = ref = new WeakReference<Object>(langContext.getContextImpl());
            }
            Object context = ref.get();
            assert (PolyglotReferences.checkContextCollected(context));
            assert (WeakSingleContext.assertDirectContextAccess(context, this.languageContext));
            return context;
        }

        private static boolean assertDirectContextAccess(Object seenContext, WeakReference<PolyglotLanguageContext> contextRef) {
            if (contextRef == null) {
                return true;
            }
            PolyglotLanguageContext context = (PolyglotLanguageContext)contextRef.get();
            if (context == null) {
                throw PolyglotReferences.invalidSharingError(null);
            }
            return PolyglotReferences.assertDirectContextAccess(context, seenContext);
        }

        private boolean setLanguageContext(PolyglotLanguageContext langContext) {
            this.languageContext = new WeakReference<PolyglotLanguageContext>(langContext);
            return true;
        }
    }

    private static final class SingleLanguage
    extends TruffleLanguage.LanguageReference<TruffleLanguage<Object>> {
        private final PolyglotLanguage language;
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage<Object> spi;

        SingleLanguage(PolyglotLanguage language, PolyglotLanguageInstance initValue) {
            this.language = language;
            this.spi = initValue != null ? initValue.spi : null;
        }

        @Override
        public TruffleLanguage<Object> get() {
            assert (this.language.assertCorrectEngine());
            TruffleLanguage<Object> languageSpi = this.spi;
            if (languageSpi == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.spi = languageSpi = this.language.getCurrentLanguageContext().getLanguageInstance().spi;
            }
            assert (SingleLanguage.assertDirectLanguageAccess(this.language, languageSpi));
            return languageSpi;
        }

        private static boolean assertDirectLanguageAccess(PolyglotLanguage language, TruffleLanguage<Object> seenLanguage) {
            TruffleLanguage<Object> conservativeLanguage = language.getConservativeLanguageReference().get();
            if (conservativeLanguage != seenLanguage) {
                throw PolyglotReferences.invalidSharingError(language.getEngine());
            }
            return true;
        }
    }
}

