/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import com.oracle.truffle.js.nodes.array.JSArrayElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayPreviousElementIndexNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSArrayPreviousElementIndexNode.class)
public final class JSArrayPreviousElementIndexNodeGen
extends JSArrayPreviousElementIndexNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private WithoutHolesCachedData withoutHolesCached_cache;
    @Node.Child
    private PreviousWithHolesCachedData previousWithHolesCached_cache;
    @Node.Child
    private PreviousWithHolesUncachedData previousWithHolesUncached_cache;
    @Node.Child
    private JSHasPropertyNode previousObjectViaEnumeration_hasPropertyNode_;
    @Node.Child
    private JSHasPropertyNode previousObjectViaFullEnumeration_hasPropertyNode_;
    @Node.Child
    private JSHasPropertyNode previousObjectViaIteration_hasPropertyNode_;

    private JSArrayPreviousElementIndexNodeGen(JSContext context) {
        super(context);
    }

    @Override
    @ExplodeLoop
    public long executeLong(Object arg0Value, long arg1Value, boolean arg2Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 0x3F) != 0 && JSTypes.isDynamicObject(arg0Value)) {
                PreviousWithHolesUncachedData s4_;
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if ((state & 1) != 0 && arg2Value && !this.hasPrototypeElements(arg0Value_)) {
                    WithoutHolesCachedData s1_ = this.withoutHolesCached_cache;
                    while (s1_ != null) {
                        if (JSArrayElementIndexNode.getArrayType(arg0Value_, arg2Value) == s1_.cachedArrayType_ && !s1_.cachedArrayType_.hasHoles(arg0Value_, arg2Value)) {
                            return this.doWithoutHolesCached(arg0Value_, arg1Value, arg2Value, s1_.cachedArrayType_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0 && arg2Value && !this.hasPrototypeElements(arg0Value_) && !JSArrayElementIndexNode.hasHoles(arg0Value_, arg2Value)) {
                    return this.doWithoutHolesUncached(arg0Value_, arg1Value, arg2Value);
                }
                if ((state & 4) != 0 && arg2Value && !this.hasPrototypeElements(arg0Value_)) {
                    PreviousWithHolesCachedData s3_ = this.previousWithHolesCached_cache;
                    while (s3_ != null) {
                        if (JSArrayElementIndexNode.getArrayType(arg0Value_, arg2Value) == s3_.cachedArrayType_ && s3_.cachedArrayType_.hasHoles(arg0Value_, arg2Value)) {
                            return this.previousWithHolesCached(arg0Value_, arg1Value, arg2Value, s3_.cachedArrayType_, s3_.previousElementIndexNode_, s3_.isMinusOne_);
                        }
                        s3_ = s3_.next_;
                    }
                }
                if ((state & 8) != 0 && (s4_ = this.previousWithHolesUncached_cache) != null && arg2Value && (this.hasPrototypeElements(arg0Value_) || JSArrayElementIndexNode.hasHoles(arg0Value_, arg2Value))) {
                    return this.previousWithHolesUncached(arg0Value_, arg1Value, arg2Value, s4_.previousElementIndexNode_, s4_.isMinusOne_, s4_.arrayTypeProfile_);
                }
                if ((state & 0x10) != 0 && !arg2Value && this.isSuitableForEnumBasedProcessingUsingOwnKeys(arg0Value_, arg1Value)) {
                    return this.previousObjectViaEnumeration(arg0Value_, arg1Value, arg2Value, this.previousObjectViaEnumeration_hasPropertyNode_);
                }
                if ((state & 0x20) != 0 && !arg2Value && !this.isSuitableForEnumBasedProcessingUsingOwnKeys(arg0Value_, arg1Value) && JSArrayElementIndexNode.isSuitableForEnumBasedProcessing(arg0Value_, arg1Value)) {
                    return this.previousObjectViaFullEnumeration(arg0Value_, arg1Value, arg2Value, this.previousObjectViaFullEnumeration_hasPropertyNode_);
                }
            }
            if ((state & 0x40) != 0 && !arg2Value && !JSArrayElementIndexNode.isSuitableForEnumBasedProcessing(arg0Value, arg1Value)) {
                return this.previousObjectViaIteration(arg0Value, arg1Value, arg2Value, this.previousObjectViaIteration_hasPropertyNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private long executeAndSpecialize(Object arg0Value, long arg1Value, boolean arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        int oldState = state;
        int oldExclude = exclude;
        int oldCacheCount = state == 0 ? 0 : this.countCaches();
        try {
            if (JSTypes.isDynamicObject(arg0Value)) {
                ScriptArray cachedArrayType__2;
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if ((exclude & 1) == 0 && arg2Value && !this.hasPrototypeElements(arg0Value_)) {
                    int count1_ = 0;
                    WithoutHolesCachedData s1_ = this.withoutHolesCached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null && (JSArrayElementIndexNode.getArrayType(arg0Value_, arg2Value) != s1_.cachedArrayType_ || s1_.cachedArrayType_.hasHoles(arg0Value_, arg2Value))) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null) {
                        cachedArrayType__2 = JSArrayElementIndexNode.getArrayTypeIfArray(arg0Value_, arg2Value);
                        if (JSArrayElementIndexNode.getArrayType(arg0Value_, arg2Value) == cachedArrayType__2 && !cachedArrayType__2.hasHoles(arg0Value_, arg2Value) && count1_ < 4) {
                            s1_ = new WithoutHolesCachedData(this.withoutHolesCached_cache);
                            s1_.cachedArrayType_ = cachedArrayType__2;
                            this.withoutHolesCached_cache = s1_;
                            this.state_ = state |= 1;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        long cachedArrayType__2 = this.doWithoutHolesCached(arg0Value_, arg1Value, arg2Value, s1_.cachedArrayType_);
                        return cachedArrayType__2;
                    }
                }
                if (arg2Value && !this.hasPrototypeElements(arg0Value_) && !JSArrayElementIndexNode.hasHoles(arg0Value_, arg2Value)) {
                    this.exclude_ = exclude |= 1;
                    this.withoutHolesCached_cache = null;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    long count1_ = this.doWithoutHolesUncached(arg0Value_, arg1Value, arg2Value);
                    return count1_;
                }
                if ((exclude & 2) == 0 && arg2Value && !this.hasPrototypeElements(arg0Value_)) {
                    int count3_ = 0;
                    PreviousWithHolesCachedData s3_ = this.previousWithHolesCached_cache;
                    if ((state & 4) != 0) {
                        while (!(s3_ == null || JSArrayElementIndexNode.getArrayType(arg0Value_, arg2Value) == s3_.cachedArrayType_ && s3_.cachedArrayType_.hasHoles(arg0Value_, arg2Value))) {
                            s3_ = s3_.next_;
                            ++count3_;
                        }
                    }
                    if (s3_ == null) {
                        cachedArrayType__2 = JSArrayElementIndexNode.getArrayTypeIfArray(arg0Value_, arg2Value);
                        if (JSArrayElementIndexNode.getArrayType(arg0Value_, arg2Value) == cachedArrayType__2 && cachedArrayType__2.hasHoles(arg0Value_, arg2Value) && count3_ < 4) {
                            s3_ = (PreviousWithHolesCachedData)super.insert((Node)new PreviousWithHolesCachedData(this.previousWithHolesCached_cache));
                            s3_.cachedArrayType_ = cachedArrayType__2;
                            s3_.previousElementIndexNode_ = s3_.insertAccessor(JSArrayPreviousElementIndexNode.create(this.context));
                            s3_.isMinusOne_ = ConditionProfile.createBinaryProfile();
                            this.previousWithHolesCached_cache = s3_;
                            this.state_ = state |= 4;
                        }
                    }
                    if (s3_ != null) {
                        lock.unlock();
                        hasLock = false;
                        long l = this.previousWithHolesCached(arg0Value_, arg1Value, arg2Value, s3_.cachedArrayType_, s3_.previousElementIndexNode_, s3_.isMinusOne_);
                        return l;
                    }
                }
                if (arg2Value && (this.hasPrototypeElements(arg0Value_) || JSArrayElementIndexNode.hasHoles(arg0Value_, arg2Value))) {
                    PreviousWithHolesUncachedData s4_ = (PreviousWithHolesUncachedData)super.insert((Node)new PreviousWithHolesUncachedData());
                    s4_.previousElementIndexNode_ = s4_.insertAccessor(JSArrayPreviousElementIndexNode.create(this.context));
                    s4_.isMinusOne_ = ConditionProfile.createBinaryProfile();
                    s4_.arrayTypeProfile_ = ValueProfile.createClassProfile();
                    this.previousWithHolesUncached_cache = s4_;
                    this.exclude_ = exclude |= 2;
                    this.previousWithHolesCached_cache = null;
                    state &= 0xFFFFFFFB;
                    this.state_ = state |= 8;
                    lock.unlock();
                    hasLock = false;
                    long l = this.previousWithHolesUncached(arg0Value_, arg1Value, arg2Value, s4_.previousElementIndexNode_, s4_.isMinusOne_, s4_.arrayTypeProfile_);
                    return l;
                }
                if (!arg2Value && this.isSuitableForEnumBasedProcessingUsingOwnKeys(arg0Value_, arg1Value)) {
                    this.previousObjectViaEnumeration_hasPropertyNode_ = (JSHasPropertyNode)super.insert((Node)JSHasPropertyNode.create());
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    long l = this.previousObjectViaEnumeration(arg0Value_, arg1Value, arg2Value, this.previousObjectViaEnumeration_hasPropertyNode_);
                    return l;
                }
                if (!arg2Value && !this.isSuitableForEnumBasedProcessingUsingOwnKeys(arg0Value_, arg1Value) && JSArrayElementIndexNode.isSuitableForEnumBasedProcessing(arg0Value_, arg1Value)) {
                    this.previousObjectViaFullEnumeration_hasPropertyNode_ = (JSHasPropertyNode)super.insert((Node)JSHasPropertyNode.create());
                    this.state_ = state |= 0x20;
                    lock.unlock();
                    hasLock = false;
                    long l = this.previousObjectViaFullEnumeration(arg0Value_, arg1Value, arg2Value, this.previousObjectViaFullEnumeration_hasPropertyNode_);
                    return l;
                }
            }
            if (!arg2Value && !JSArrayElementIndexNode.isSuitableForEnumBasedProcessing(arg0Value, arg1Value)) {
                this.previousObjectViaIteration_hasPropertyNode_ = (JSHasPropertyNode)super.insert((Node)JSHasPropertyNode.create());
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                long l = this.previousObjectViaIteration(arg0Value, arg1Value, arg2Value, this.previousObjectViaIteration_hasPropertyNode_);
                return l;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null, null}, new Object[]{arg0Value, arg1Value, arg2Value});
        }
        finally {
            if (oldState != 0 || oldExclude != 0) {
                this.checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
        int newState = this.state_;
        int newExclude = this.exclude_;
        if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < this.countCaches()) {
            this.reportPolymorphicSpecialize();
        }
    }

    private int countCaches() {
        int cacheCount = 0;
        WithoutHolesCachedData s1_ = this.withoutHolesCached_cache;
        while (s1_ != null) {
            ++cacheCount;
            s1_ = s1_.next_;
        }
        PreviousWithHolesCachedData s3_ = this.previousWithHolesCached_cache;
        while (s3_ != null) {
            ++cacheCount;
            s3_ = s3_.next_;
        }
        return cacheCount;
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            WithoutHolesCachedData s1_ = this.withoutHolesCached_cache;
            PreviousWithHolesCachedData s3_ = this.previousWithHolesCached_cache;
            if (!(s1_ != null && s1_.next_ != null || s3_ != null && s3_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[8];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doWithoutHolesCached";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            WithoutHolesCachedData s1_ = this.withoutHolesCached_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedArrayType_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doWithoutHolesUncached";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "previousWithHolesCached";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            PreviousWithHolesCachedData s3_ = this.previousWithHolesCached_cache;
            while (s3_ != null) {
                cached.add(Arrays.asList(new Object[]{s3_.cachedArrayType_, s3_.previousElementIndexNode_, s3_.isMinusOne_}));
                s3_ = s3_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "previousWithHolesUncached";
        if ((state & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            PreviousWithHolesUncachedData s4_ = this.previousWithHolesUncached_cache;
            if (s4_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s4_.previousElementIndexNode_, s4_.isMinusOne_, s4_.arrayTypeProfile_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "previousObjectViaEnumeration";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.previousObjectViaEnumeration_hasPropertyNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "previousObjectViaFullEnumeration";
        if ((state & 0x20) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.previousObjectViaFullEnumeration_hasPropertyNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "previousObjectViaIteration";
        if ((state & 0x40) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.previousObjectViaIteration_hasPropertyNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[7] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSArrayPreviousElementIndexNode create(JSContext context) {
        return new JSArrayPreviousElementIndexNodeGen(context);
    }

    @GeneratedBy(value=JSArrayPreviousElementIndexNode.class)
    private static final class PreviousWithHolesUncachedData
    extends Node {
        @Node.Child
        JSArrayPreviousElementIndexNode previousElementIndexNode_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile isMinusOne_;
        @CompilerDirectives.CompilationFinal
        ValueProfile arrayTypeProfile_;

        PreviousWithHolesUncachedData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=JSArrayPreviousElementIndexNode.class)
    private static final class PreviousWithHolesCachedData
    extends Node {
        @Node.Child
        PreviousWithHolesCachedData next_;
        @CompilerDirectives.CompilationFinal
        ScriptArray cachedArrayType_;
        @Node.Child
        JSArrayPreviousElementIndexNode previousElementIndexNode_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile isMinusOne_;

        PreviousWithHolesCachedData(PreviousWithHolesCachedData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=JSArrayPreviousElementIndexNode.class)
    private static final class WithoutHolesCachedData {
        @CompilerDirectives.CompilationFinal
        WithoutHolesCachedData next_;
        @CompilerDirectives.CompilationFinal
        ScriptArray cachedArrayType_;

        WithoutHolesCachedData(WithoutHolesCachedData next_) {
            this.next_ = next_;
        }
    }
}

